package com.flurry.org.codehaus.jackson.map.deser.std;

import com.flurry.org.codehaus.jackson.JsonParser;
import com.flurry.org.codehaus.jackson.JsonProcessingException;
import com.flurry.org.codehaus.jackson.JsonToken;
import com.flurry.org.codehaus.jackson.map.DeserializationContext;
import com.flurry.org.codehaus.jackson.map.annotate.JacksonStdImpl;
import java.io.IOException;

@JacksonStdImpl
/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
public class ClassDeserializer extends StdScalarDeserializer<Class<?>> {
    public ClassDeserializer() {
        super(Class.class);
    }

    @Override // com.flurry.org.codehaus.jackson.map.JsonDeserializer
    public Class<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken curr = jp.getCurrentToken();
        if (curr == JsonToken.VALUE_STRING) {
            String className = jp.getText();
            if (className.indexOf(46) < 0) {
                if ("int".equals(className)) {
                    return Integer.TYPE;
                }
                if ("long".equals(className)) {
                    return Long.TYPE;
                }
                if ("float".equals(className)) {
                    return Float.TYPE;
                }
                if ("double".equals(className)) {
                    return Double.TYPE;
                }
                if ("boolean".equals(className)) {
                    return Boolean.TYPE;
                }
                if ("byte".equals(className)) {
                    return Byte.TYPE;
                }
                if ("char".equals(className)) {
                    return Character.TYPE;
                }
                if ("short".equals(className)) {
                    return Short.TYPE;
                }
                if ("void".equals(className)) {
                    return Void.TYPE;
                }
            }
            try {
                return Class.forName(jp.getText());
            } catch (ClassNotFoundException e) {
                throw ctxt.instantiationException(this._valueClass, e);
            }
        }
        throw ctxt.mappingException(this._valueClass, curr);
    }
}
