package com.flurry.org.codehaus.jackson.map.deser.impl;

import com.flurry.org.codehaus.jackson.JsonProcessingException;
import com.flurry.org.codehaus.jackson.map.deser.SettableAnyProperty;
import com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty;
import java.io.IOException;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
public abstract class PropertyValue {
    public final PropertyValue next;
    public final Object value;

    public abstract void assign(Object obj) throws IOException, JsonProcessingException;

    protected PropertyValue(PropertyValue next, Object value) {
        this.next = next;
        this.value = value;
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
    static final class Regular extends PropertyValue {
        final SettableBeanProperty _property;

        public Regular(PropertyValue next, Object value, SettableBeanProperty prop) {
            super(next, value);
            this._property = prop;
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.impl.PropertyValue
        public void assign(Object bean) throws IOException, JsonProcessingException {
            this._property.set(bean, this.value);
        }
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
    static final class Any extends PropertyValue {
        final SettableAnyProperty _property;
        final String _propertyName;

        public Any(PropertyValue next, Object value, SettableAnyProperty prop, String propName) {
            super(next, value);
            this._property = prop;
            this._propertyName = propName;
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.impl.PropertyValue
        public void assign(Object bean) throws IOException, JsonProcessingException {
            this._property.set(bean, this._propertyName, this.value);
        }
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
    static final class Map extends PropertyValue {
        final Object _key;

        public Map(PropertyValue next, Object value, Object key) {
            super(next, value);
            this._key = key;
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.impl.PropertyValue
        public void assign(Object bean) throws IOException, JsonProcessingException {
            ((java.util.Map) bean).put(this._key, this.value);
        }
    }
}
