package com.flurry.org.codehaus.jackson.map.deser;

import com.flurry.org.codehaus.jackson.JsonNode;
import com.flurry.org.codehaus.jackson.JsonParser;
import com.flurry.org.codehaus.jackson.JsonProcessingException;
import com.flurry.org.codehaus.jackson.io.SerializedString;
import com.flurry.org.codehaus.jackson.map.AbstractTypeResolver;
import com.flurry.org.codehaus.jackson.map.AnnotationIntrospector;
import com.flurry.org.codehaus.jackson.map.BeanProperty;
import com.flurry.org.codehaus.jackson.map.ContextualDeserializer;
import com.flurry.org.codehaus.jackson.map.ContextualKeyDeserializer;
import com.flurry.org.codehaus.jackson.map.DeserializationConfig;
import com.flurry.org.codehaus.jackson.map.DeserializationContext;
import com.flurry.org.codehaus.jackson.map.DeserializerFactory;
import com.flurry.org.codehaus.jackson.map.DeserializerProvider;
import com.flurry.org.codehaus.jackson.map.Deserializers;
import com.flurry.org.codehaus.jackson.map.JsonDeserializer;
import com.flurry.org.codehaus.jackson.map.JsonMappingException;
import com.flurry.org.codehaus.jackson.map.KeyDeserializer;
import com.flurry.org.codehaus.jackson.map.KeyDeserializers;
import com.flurry.org.codehaus.jackson.map.ResolvableDeserializer;
import com.flurry.org.codehaus.jackson.map.TypeDeserializer;
import com.flurry.org.codehaus.jackson.map.introspect.AnnotatedClass;
import com.flurry.org.codehaus.jackson.map.type.ArrayType;
import com.flurry.org.codehaus.jackson.map.type.CollectionLikeType;
import com.flurry.org.codehaus.jackson.map.type.CollectionType;
import com.flurry.org.codehaus.jackson.map.type.MapLikeType;
import com.flurry.org.codehaus.jackson.map.type.MapType;
import com.flurry.org.codehaus.jackson.map.util.ClassUtil;
import com.flurry.org.codehaus.jackson.map.util.RootNameLookup;
import com.flurry.org.codehaus.jackson.type.JavaType;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
public class StdDeserializerProvider extends DeserializerProvider {
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _cachedDeserializers;
    protected DeserializerFactory _factory;
    protected final HashMap<JavaType, JsonDeserializer<Object>> _incompleteDeserializers;
    protected final RootNameLookup _rootNames;

    public StdDeserializerProvider() {
        this(BeanDeserializerFactory.instance);
    }

    public StdDeserializerProvider(DeserializerFactory f) {
        this._cachedDeserializers = new ConcurrentHashMap<>(64, 0.75f, 2);
        this._incompleteDeserializers = new HashMap<>(8);
        this._factory = f;
        this._rootNames = new RootNameLookup();
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerProvider
    public DeserializerProvider withAdditionalDeserializers(Deserializers d) {
        return withFactory(this._factory.withAdditionalDeserializers(d));
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerProvider
    public DeserializerProvider withAdditionalKeyDeserializers(KeyDeserializers d) {
        return withFactory(this._factory.withAdditionalKeyDeserializers(d));
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerProvider
    public DeserializerProvider withDeserializerModifier(BeanDeserializerModifier modifier) {
        return withFactory(this._factory.withDeserializerModifier(modifier));
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerProvider
    public DeserializerProvider withAbstractTypeResolver(AbstractTypeResolver resolver) {
        return withFactory(this._factory.withAbstractTypeResolver(resolver));
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerProvider
    public DeserializerProvider withValueInstantiators(ValueInstantiators instantiators) {
        return withFactory(this._factory.withValueInstantiators(instantiators));
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerProvider
    public StdDeserializerProvider withFactory(DeserializerFactory factory) {
        if (getClass() != StdDeserializerProvider.class) {
            throw new IllegalStateException("DeserializerProvider of type " + getClass().getName() + " does not override 'withFactory()' method");
        }
        return new StdDeserializerProvider(factory);
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerProvider
    public JavaType mapAbstractType(DeserializationConfig config, JavaType type) throws JsonMappingException {
        return this._factory.mapAbstractType(config, type);
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerProvider
    public SerializedString findExpectedRootName(DeserializationConfig config, JavaType type) throws JsonMappingException {
        return this._rootNames.findRootName(type, config);
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerProvider
    public JsonDeserializer<Object> findValueDeserializer(DeserializationConfig config, JavaType propertyType, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser = _findCachedDeserializer(propertyType);
        if (deser != null) {
            if (deser instanceof ContextualDeserializer) {
                JsonDeserializer<Object> d = ((ContextualDeserializer) deser).createContextual(config, property);
                deser = d;
            }
            return deser;
        }
        JsonDeserializer<Object> deser2 = _createAndCacheValueDeserializer(config, propertyType, property);
        if (deser2 == null) {
            deser2 = _handleUnknownValueDeserializer(propertyType);
        }
        if (deser2 instanceof ContextualDeserializer) {
            JsonDeserializer<Object> d2 = ((ContextualDeserializer) deser2).createContextual(config, property);
            deser2 = d2;
        }
        return deser2;
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerProvider
    public JsonDeserializer<Object> findTypedValueDeserializer(DeserializationConfig config, JavaType type, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser = findValueDeserializer(config, type, property);
        TypeDeserializer typeDeser = this._factory.findTypeDeserializer(config, type, property);
        if (typeDeser != null) {
            return new WrappedDeserializer(typeDeser, deser);
        }
        return deser;
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerProvider
    public KeyDeserializer findKeyDeserializer(DeserializationConfig config, JavaType type, BeanProperty property) throws JsonMappingException {
        KeyDeserializer kd = this._factory.createKeyDeserializer(config, type, property);
        if (kd instanceof ContextualKeyDeserializer) {
            kd = ((ContextualKeyDeserializer) kd).createContextual(config, property);
        }
        if (kd == null) {
            return _handleUnknownKeyDeserializer(type);
        }
        return kd;
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerProvider
    public boolean hasValueDeserializerFor(DeserializationConfig config, JavaType type) {
        JsonDeserializer<Object> deser = _findCachedDeserializer(type);
        if (deser == null) {
            try {
                deser = _createAndCacheValueDeserializer(config, type, null);
            } catch (Exception e) {
                return false;
            }
        }
        return deser != null;
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerProvider
    public int cachedDeserializersCount() {
        return this._cachedDeserializers.size();
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerProvider
    public void flushCachedDeserializers() {
        this._cachedDeserializers.clear();
    }

    protected JsonDeserializer<Object> _findCachedDeserializer(JavaType type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return this._cachedDeserializers.get(type);
    }

    protected JsonDeserializer<Object> _createAndCacheValueDeserializer(DeserializationConfig config, JavaType type, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> deser;
        synchronized (this._incompleteDeserializers) {
            JsonDeserializer<Object> deser2 = _findCachedDeserializer(type);
            if (deser2 != null) {
                return deser2;
            }
            int count = this._incompleteDeserializers.size();
            if (count <= 0 || (deser = this._incompleteDeserializers.get(type)) == null) {
                JsonDeserializer<Object> _createAndCache2 = _createAndCache2(config, type, property);
                if (count == 0 && this._incompleteDeserializers.size() > 0) {
                    this._incompleteDeserializers.clear();
                }
                return _createAndCache2;
            }
            return deser;
        }
    }

    protected JsonDeserializer<Object> _createAndCache2(DeserializationConfig config, JavaType type, BeanProperty property) throws JsonMappingException {
        try {
            JsonDeserializer<Object> deser = _createDeserializer(config, type, property);
            if (deser == null) {
                return null;
            }
            boolean isResolvable = deser instanceof ResolvableDeserializer;
            boolean addToCache = deser.getClass() == BeanDeserializer.class;
            if (!addToCache && config.isEnabled(DeserializationConfig.Feature.USE_ANNOTATIONS)) {
                AnnotationIntrospector aintr = config.getAnnotationIntrospector();
                AnnotatedClass ac = AnnotatedClass.construct(deser.getClass(), aintr, null);
                Boolean cacheAnn = aintr.findCachability(ac);
                if (cacheAnn != null) {
                    addToCache = cacheAnn.booleanValue();
                }
            }
            if (isResolvable) {
                this._incompleteDeserializers.put(type, deser);
                _resolveDeserializer(config, (ResolvableDeserializer) deser);
                this._incompleteDeserializers.remove(type);
            }
            if (addToCache) {
                this._cachedDeserializers.put(type, deser);
                return deser;
            }
            return deser;
        } catch (IllegalArgumentException iae) {
            throw new JsonMappingException(iae.getMessage(), null, iae);
        }
    }

    protected JsonDeserializer<Object> _createDeserializer(DeserializationConfig config, JavaType type, BeanProperty property) throws JsonMappingException {
        if (type.isEnumType()) {
            return this._factory.createEnumDeserializer(config, this, type, property);
        }
        if (type.isContainerType()) {
            if (type.isArrayType()) {
                return this._factory.createArrayDeserializer(config, this, (ArrayType) type, property);
            }
            if (type.isMapLikeType()) {
                MapLikeType mlt = (MapLikeType) type;
                if (mlt.isTrueMapType()) {
                    return this._factory.createMapDeserializer(config, this, (MapType) mlt, property);
                }
                return this._factory.createMapLikeDeserializer(config, this, mlt, property);
            } else if (type.isCollectionLikeType()) {
                CollectionLikeType clt = (CollectionLikeType) type;
                if (clt.isTrueCollectionType()) {
                    return this._factory.createCollectionDeserializer(config, this, (CollectionType) clt, property);
                }
                return this._factory.createCollectionLikeDeserializer(config, this, clt, property);
            }
        }
        if (JsonNode.class.isAssignableFrom(type.getRawClass())) {
            return this._factory.createTreeDeserializer(config, this, type, property);
        }
        return this._factory.createBeanDeserializer(config, this, type, property);
    }

    protected void _resolveDeserializer(DeserializationConfig config, ResolvableDeserializer ser) throws JsonMappingException {
        ser.resolve(config, this);
    }

    protected JsonDeserializer<Object> _handleUnknownValueDeserializer(JavaType type) throws JsonMappingException {
        Class<?> rawClass = type.getRawClass();
        if (!ClassUtil.isConcrete(rawClass)) {
            throw new JsonMappingException("Can not find a Value deserializer for abstract type " + type);
        }
        throw new JsonMappingException("Can not find a Value deserializer for type " + type);
    }

    protected KeyDeserializer _handleUnknownKeyDeserializer(JavaType type) throws JsonMappingException {
        throw new JsonMappingException("Can not find a (Map) Key deserializer for type " + type);
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
    protected static final class WrappedDeserializer extends JsonDeserializer<Object> {
        final JsonDeserializer<Object> _deserializer;
        final TypeDeserializer _typeDeserializer;

        public WrappedDeserializer(TypeDeserializer typeDeser, JsonDeserializer<Object> deser) {
            this._typeDeserializer = typeDeser;
            this._deserializer = deser;
        }

        @Override // com.flurry.org.codehaus.jackson.map.JsonDeserializer
        public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return this._deserializer.deserializeWithType(jp, ctxt, this._typeDeserializer);
        }

        @Override // com.flurry.org.codehaus.jackson.map.JsonDeserializer
        public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
            throw new IllegalStateException("Type-wrapped deserializer's deserializeWithType should never get called");
        }
    }
}
