package com.flurry.org.codehaus.jackson.map.deser;

import com.flurry.org.codehaus.jackson.JsonParser;
import com.flurry.org.codehaus.jackson.JsonProcessingException;
import com.flurry.org.codehaus.jackson.JsonToken;
import com.flurry.org.codehaus.jackson.map.BeanProperty;
import com.flurry.org.codehaus.jackson.map.DeserializationConfig;
import com.flurry.org.codehaus.jackson.map.DeserializationContext;
import com.flurry.org.codehaus.jackson.map.JsonDeserializer;
import com.flurry.org.codehaus.jackson.map.JsonMappingException;
import com.flurry.org.codehaus.jackson.map.TypeDeserializer;
import com.flurry.org.codehaus.jackson.map.introspect.AnnotatedField;
import com.flurry.org.codehaus.jackson.map.introspect.AnnotatedMember;
import com.flurry.org.codehaus.jackson.map.introspect.AnnotatedMethod;
import com.flurry.org.codehaus.jackson.map.util.Annotations;
import com.flurry.org.codehaus.jackson.map.util.ClassUtil;
import com.flurry.org.codehaus.jackson.type.JavaType;
import com.flurry.org.codehaus.jackson.util.InternCache;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
public abstract class SettableBeanProperty implements BeanProperty {
    protected final Annotations _contextAnnotations;
    protected String _managedReferenceName;
    protected NullProvider _nullProvider;
    protected final String _propName;
    protected int _propertyIndex;
    protected final JavaType _type;
    protected JsonDeserializer<Object> _valueDeserializer;
    protected TypeDeserializer _valueTypeDeserializer;

    public abstract void deserializeAndSet(JsonParser jsonParser, DeserializationContext deserializationContext, Object obj) throws IOException, JsonProcessingException;

    @Override // com.flurry.org.codehaus.jackson.map.BeanProperty
    public abstract <A extends Annotation> A getAnnotation(Class<A> cls);

    @Override // com.flurry.org.codehaus.jackson.map.BeanProperty
    public abstract AnnotatedMember getMember();

    public abstract void set(Object obj, Object obj2) throws IOException;

    public abstract SettableBeanProperty withValueDeserializer(JsonDeserializer<Object> jsonDeserializer);

    /* JADX INFO: Access modifiers changed from: protected */
    public SettableBeanProperty(String propName, JavaType type, TypeDeserializer typeDeser, Annotations contextAnnotations) {
        this._propertyIndex = -1;
        if (propName == null || propName.length() == 0) {
            this._propName = "";
        } else {
            this._propName = InternCache.instance.intern(propName);
        }
        this._type = type;
        this._contextAnnotations = contextAnnotations;
        this._valueTypeDeserializer = typeDeser;
    }

    protected SettableBeanProperty(SettableBeanProperty src) {
        this._propertyIndex = -1;
        this._propName = src._propName;
        this._type = src._type;
        this._contextAnnotations = src._contextAnnotations;
        this._valueDeserializer = src._valueDeserializer;
        this._valueTypeDeserializer = src._valueTypeDeserializer;
        this._nullProvider = src._nullProvider;
        this._managedReferenceName = src._managedReferenceName;
        this._propertyIndex = src._propertyIndex;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public SettableBeanProperty(SettableBeanProperty src, JsonDeserializer<Object> deser) {
        this._propertyIndex = -1;
        this._propName = src._propName;
        this._type = src._type;
        this._contextAnnotations = src._contextAnnotations;
        this._valueTypeDeserializer = src._valueTypeDeserializer;
        this._managedReferenceName = src._managedReferenceName;
        this._propertyIndex = src._propertyIndex;
        this._valueDeserializer = deser;
        if (deser == null) {
            this._nullProvider = null;
            return;
        }
        Object nvl = deser.getNullValue();
        this._nullProvider = nvl != null ? new NullProvider(this._type, nvl) : null;
    }

    @Deprecated
    public void setValueDeserializer(JsonDeserializer<Object> deser) {
        if (this._valueDeserializer != null) {
            throw new IllegalStateException("Already had assigned deserializer for property '" + getName() + "' (class " + getDeclaringClass().getName() + ")");
        }
        this._valueDeserializer = deser;
        Object nvl = this._valueDeserializer.getNullValue();
        this._nullProvider = nvl == null ? null : new NullProvider(this._type, nvl);
    }

    public void setManagedReferenceName(String n) {
        this._managedReferenceName = n;
    }

    public void assignIndex(int index) {
        if (this._propertyIndex != -1) {
            throw new IllegalStateException("Property '" + getName() + "' already had index (" + this._propertyIndex + "), trying to assign " + index);
        }
        this._propertyIndex = index;
    }

    @Override // com.flurry.org.codehaus.jackson.map.BeanProperty, com.flurry.org.codehaus.jackson.map.util.Named
    public final String getName() {
        return this._propName;
    }

    @Override // com.flurry.org.codehaus.jackson.map.BeanProperty
    public JavaType getType() {
        return this._type;
    }

    @Override // com.flurry.org.codehaus.jackson.map.BeanProperty
    public <A extends Annotation> A getContextAnnotation(Class<A> acls) {
        return (A) this._contextAnnotations.get(acls);
    }

    protected final Class<?> getDeclaringClass() {
        return getMember().getDeclaringClass();
    }

    @Deprecated
    public String getPropertyName() {
        return this._propName;
    }

    public String getManagedReferenceName() {
        return this._managedReferenceName;
    }

    public boolean hasValueDeserializer() {
        return this._valueDeserializer != null;
    }

    public boolean hasValueTypeDeserializer() {
        return this._valueTypeDeserializer != null;
    }

    public JsonDeserializer<Object> getValueDeserializer() {
        return this._valueDeserializer;
    }

    public TypeDeserializer getValueTypeDeserializer() {
        return this._valueTypeDeserializer;
    }

    public int getPropertyIndex() {
        return this._propertyIndex;
    }

    @Deprecated
    public int getProperytIndex() {
        return getPropertyIndex();
    }

    public Object getInjectableValueId() {
        return null;
    }

    public final Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            if (this._nullProvider == null) {
                return null;
            }
            return this._nullProvider.nullValue(ctxt);
        } else if (this._valueTypeDeserializer != null) {
            return this._valueDeserializer.deserializeWithType(jp, ctxt, this._valueTypeDeserializer);
        } else {
            return this._valueDeserializer.deserialize(jp, ctxt);
        }
    }

    protected void _throwAsIOE(Exception e, Object value) throws IOException {
        if (e instanceof IllegalArgumentException) {
            String actType = value == null ? "[NULL]" : value.getClass().getName();
            StringBuilder msg = new StringBuilder("Problem deserializing property '").append(getPropertyName());
            msg.append("' (expected type: ").append(getType());
            msg.append("; actual type: ").append(actType).append(")");
            String origMsg = e.getMessage();
            if (origMsg != null) {
                msg.append(", problem: ").append(origMsg);
            } else {
                msg.append(" (no error message provided)");
            }
            throw new JsonMappingException(msg.toString(), null, e);
        }
        _throwAsIOE(e);
    }

    protected IOException _throwAsIOE(Exception e) throws IOException {
        if (e instanceof IOException) {
            throw ((IOException) e);
        }
        if (e instanceof RuntimeException) {
            throw ((RuntimeException) e);
        }
        Throwable th = e;
        while (th.getCause() != null) {
            th = th.getCause();
        }
        throw new JsonMappingException(th.getMessage(), null, th);
    }

    public String toString() {
        return "[property '" + getName() + "']";
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
    public static final class MethodProperty extends SettableBeanProperty {
        protected final AnnotatedMethod _annotated;
        protected final Method _setter;

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public /* bridge */ /* synthetic */ SettableBeanProperty withValueDeserializer(JsonDeserializer x0) {
            return withValueDeserializer((JsonDeserializer<Object>) x0);
        }

        public MethodProperty(String name, JavaType type, TypeDeserializer typeDeser, Annotations contextAnnotations, AnnotatedMethod method) {
            super(name, type, typeDeser, contextAnnotations);
            this._annotated = method;
            this._setter = method.getAnnotated();
        }

        protected MethodProperty(MethodProperty src, JsonDeserializer<Object> deser) {
            super(src, deser);
            this._annotated = src._annotated;
            this._setter = src._setter;
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public MethodProperty withValueDeserializer(JsonDeserializer<Object> deser) {
            return new MethodProperty(this, deser);
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty, com.flurry.org.codehaus.jackson.map.BeanProperty
        public <A extends Annotation> A getAnnotation(Class<A> acls) {
            return (A) this._annotated.getAnnotation(acls);
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty, com.flurry.org.codehaus.jackson.map.BeanProperty
        public AnnotatedMember getMember() {
            return this._annotated;
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public void deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException, JsonProcessingException {
            set(instance, deserialize(jp, ctxt));
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public final void set(Object instance, Object value) throws IOException {
            try {
                this._setter.invoke(instance, value);
            } catch (Exception e) {
                _throwAsIOE(e, value);
            }
        }
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
    public static final class SetterlessProperty extends SettableBeanProperty {
        protected final AnnotatedMethod _annotated;
        protected final Method _getter;

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public /* bridge */ /* synthetic */ SettableBeanProperty withValueDeserializer(JsonDeserializer x0) {
            return withValueDeserializer((JsonDeserializer<Object>) x0);
        }

        public SetterlessProperty(String name, JavaType type, TypeDeserializer typeDeser, Annotations contextAnnotations, AnnotatedMethod method) {
            super(name, type, typeDeser, contextAnnotations);
            this._annotated = method;
            this._getter = method.getAnnotated();
        }

        protected SetterlessProperty(SetterlessProperty src, JsonDeserializer<Object> deser) {
            super(src, deser);
            this._annotated = src._annotated;
            this._getter = src._getter;
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public SetterlessProperty withValueDeserializer(JsonDeserializer<Object> deser) {
            return new SetterlessProperty(this, deser);
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty, com.flurry.org.codehaus.jackson.map.BeanProperty
        public <A extends Annotation> A getAnnotation(Class<A> acls) {
            return (A) this._annotated.getAnnotation(acls);
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty, com.flurry.org.codehaus.jackson.map.BeanProperty
        public AnnotatedMember getMember() {
            return this._annotated;
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public final void deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException, JsonProcessingException {
            JsonToken t = jp.getCurrentToken();
            if (t != JsonToken.VALUE_NULL) {
                try {
                    Object toModify = this._getter.invoke(instance, new Object[0]);
                    if (toModify == null) {
                        throw new JsonMappingException("Problem deserializing 'setterless' property '" + getName() + "': get method returned null");
                    }
                    this._valueDeserializer.deserialize(jp, ctxt, toModify);
                } catch (Exception e) {
                    _throwAsIOE(e);
                }
            }
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public final void set(Object instance, Object value) throws IOException {
            throw new UnsupportedOperationException("Should never call 'set' on setterless property");
        }
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
    public static final class FieldProperty extends SettableBeanProperty {
        protected final AnnotatedField _annotated;
        protected final Field _field;

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public /* bridge */ /* synthetic */ SettableBeanProperty withValueDeserializer(JsonDeserializer x0) {
            return withValueDeserializer((JsonDeserializer<Object>) x0);
        }

        public FieldProperty(String name, JavaType type, TypeDeserializer typeDeser, Annotations contextAnnotations, AnnotatedField field) {
            super(name, type, typeDeser, contextAnnotations);
            this._annotated = field;
            this._field = field.getAnnotated();
        }

        protected FieldProperty(FieldProperty src, JsonDeserializer<Object> deser) {
            super(src, deser);
            this._annotated = src._annotated;
            this._field = src._field;
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public FieldProperty withValueDeserializer(JsonDeserializer<Object> deser) {
            return new FieldProperty(this, deser);
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty, com.flurry.org.codehaus.jackson.map.BeanProperty
        public <A extends Annotation> A getAnnotation(Class<A> acls) {
            return (A) this._annotated.getAnnotation(acls);
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty, com.flurry.org.codehaus.jackson.map.BeanProperty
        public AnnotatedMember getMember() {
            return this._annotated;
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public void deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException, JsonProcessingException {
            set(instance, deserialize(jp, ctxt));
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public final void set(Object instance, Object value) throws IOException {
            try {
                this._field.set(instance, value);
            } catch (Exception e) {
                _throwAsIOE(e, value);
            }
        }
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
    public static final class ManagedReferenceProperty extends SettableBeanProperty {
        protected final SettableBeanProperty _backProperty;
        protected final boolean _isContainer;
        protected final SettableBeanProperty _managedProperty;
        protected final String _referenceName;

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public /* bridge */ /* synthetic */ SettableBeanProperty withValueDeserializer(JsonDeserializer x0) {
            return withValueDeserializer((JsonDeserializer<Object>) x0);
        }

        public ManagedReferenceProperty(String refName, SettableBeanProperty forward, SettableBeanProperty backward, Annotations contextAnnotations, boolean isContainer) {
            super(forward.getName(), forward.getType(), forward._valueTypeDeserializer, contextAnnotations);
            this._referenceName = refName;
            this._managedProperty = forward;
            this._backProperty = backward;
            this._isContainer = isContainer;
        }

        protected ManagedReferenceProperty(ManagedReferenceProperty src, JsonDeserializer<Object> deser) {
            super(src, deser);
            this._referenceName = src._referenceName;
            this._isContainer = src._isContainer;
            this._managedProperty = src._managedProperty;
            this._backProperty = src._backProperty;
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public ManagedReferenceProperty withValueDeserializer(JsonDeserializer<Object> deser) {
            return new ManagedReferenceProperty(this, deser);
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty, com.flurry.org.codehaus.jackson.map.BeanProperty
        public <A extends Annotation> A getAnnotation(Class<A> acls) {
            return (A) this._managedProperty.getAnnotation(acls);
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty, com.flurry.org.codehaus.jackson.map.BeanProperty
        public AnnotatedMember getMember() {
            return this._managedProperty.getMember();
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public void deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object instance) throws IOException, JsonProcessingException {
            set(instance, this._managedProperty.deserialize(jp, ctxt));
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public final void set(Object instance, Object value) throws IOException {
            this._managedProperty.set(instance, value);
            if (value != null) {
                if (this._isContainer) {
                    if (value instanceof Object[]) {
                        Object[] arr$ = (Object[]) value;
                        for (Object ob : arr$) {
                            if (ob != null) {
                                this._backProperty.set(ob, instance);
                            }
                        }
                        return;
                    } else if (value instanceof Collection) {
                        for (Object ob2 : (Collection) value) {
                            if (ob2 != null) {
                                this._backProperty.set(ob2, instance);
                            }
                        }
                        return;
                    } else if (value instanceof Map) {
                        for (Object ob3 : ((Map) value).values()) {
                            if (ob3 != null) {
                                this._backProperty.set(ob3, instance);
                            }
                        }
                        return;
                    } else {
                        throw new IllegalStateException("Unsupported container type (" + value.getClass().getName() + ") when resolving reference '" + this._referenceName + "'");
                    }
                }
                this._backProperty.set(value, instance);
            }
        }
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
    public static final class InnerClassProperty extends SettableBeanProperty {
        protected final Constructor<?> _creator;
        protected final SettableBeanProperty _delegate;

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public /* bridge */ /* synthetic */ SettableBeanProperty withValueDeserializer(JsonDeserializer x0) {
            return withValueDeserializer((JsonDeserializer<Object>) x0);
        }

        public InnerClassProperty(SettableBeanProperty delegate, Constructor<?> ctor) {
            super(delegate);
            this._delegate = delegate;
            this._creator = ctor;
        }

        protected InnerClassProperty(InnerClassProperty src, JsonDeserializer<Object> deser) {
            super(src, deser);
            this._delegate = src._delegate.withValueDeserializer(deser);
            this._creator = src._creator;
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public InnerClassProperty withValueDeserializer(JsonDeserializer<Object> deser) {
            return new InnerClassProperty(this, deser);
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty, com.flurry.org.codehaus.jackson.map.BeanProperty
        public <A extends Annotation> A getAnnotation(Class<A> acls) {
            return (A) this._delegate.getAnnotation(acls);
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty, com.flurry.org.codehaus.jackson.map.BeanProperty
        public AnnotatedMember getMember() {
            return this._delegate.getMember();
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public void deserializeAndSet(JsonParser jp, DeserializationContext ctxt, Object bean) throws IOException, JsonProcessingException {
            Object obj;
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.VALUE_NULL) {
                obj = this._nullProvider == null ? null : this._nullProvider.nullValue(ctxt);
            } else if (this._valueTypeDeserializer != null) {
                obj = this._valueDeserializer.deserializeWithType(jp, ctxt, this._valueTypeDeserializer);
            } else {
                try {
                    obj = this._creator.newInstance(bean);
                } catch (Exception e) {
                    ClassUtil.unwrapAndThrowAsIAE(e, "Failed to instantiate class " + this._creator.getDeclaringClass().getName() + ", problem: " + e.getMessage());
                    obj = null;
                }
                this._valueDeserializer.deserialize(jp, ctxt, obj);
            }
            set(bean, obj);
        }

        @Override // com.flurry.org.codehaus.jackson.map.deser.SettableBeanProperty
        public final void set(Object instance, Object value) throws IOException {
            this._delegate.set(instance, value);
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
    public static final class NullProvider {
        private final boolean _isPrimitive;
        private final Object _nullValue;
        private final Class<?> _rawType;

        protected NullProvider(JavaType type, Object nullValue) {
            this._nullValue = nullValue;
            this._isPrimitive = type.isPrimitive();
            this._rawType = type.getRawClass();
        }

        public Object nullValue(DeserializationContext ctxt) throws JsonProcessingException {
            if (this._isPrimitive && ctxt.isEnabled(DeserializationConfig.Feature.FAIL_ON_NULL_FOR_PRIMITIVES)) {
                throw ctxt.mappingException("Can not map JSON null into type " + this._rawType.getName() + " (set DeserializationConfig.Feature.FAIL_ON_NULL_FOR_PRIMITIVES to 'false' to allow)");
            }
            return this._nullValue;
        }
    }
}
