package com.flurry.org.codehaus.jackson.map.deser;

import com.flurry.org.codehaus.jackson.JsonNode;
import com.flurry.org.codehaus.jackson.map.AnnotationIntrospector;
import com.flurry.org.codehaus.jackson.map.BeanProperty;
import com.flurry.org.codehaus.jackson.map.ContextualDeserializer;
import com.flurry.org.codehaus.jackson.map.DeserializationConfig;
import com.flurry.org.codehaus.jackson.map.DeserializerFactory;
import com.flurry.org.codehaus.jackson.map.DeserializerProvider;
import com.flurry.org.codehaus.jackson.map.JsonDeserializer;
import com.flurry.org.codehaus.jackson.map.JsonMappingException;
import com.flurry.org.codehaus.jackson.map.KeyDeserializer;
import com.flurry.org.codehaus.jackson.map.TypeDeserializer;
import com.flurry.org.codehaus.jackson.map.deser.std.AtomicReferenceDeserializer;
import com.flurry.org.codehaus.jackson.map.deser.std.EnumMapDeserializer;
import com.flurry.org.codehaus.jackson.map.deser.std.EnumSetDeserializer;
import com.flurry.org.codehaus.jackson.map.deser.std.ObjectArrayDeserializer;
import com.flurry.org.codehaus.jackson.map.deser.std.PrimitiveArrayDeserializers;
import com.flurry.org.codehaus.jackson.map.deser.std.StringCollectionDeserializer;
import com.flurry.org.codehaus.jackson.map.ext.OptionalHandlerFactory;
import com.flurry.org.codehaus.jackson.map.introspect.Annotated;
import com.flurry.org.codehaus.jackson.map.introspect.AnnotatedClass;
import com.flurry.org.codehaus.jackson.map.introspect.AnnotatedMember;
import com.flurry.org.codehaus.jackson.map.introspect.AnnotatedMethod;
import com.flurry.org.codehaus.jackson.map.introspect.BasicBeanDescription;
import com.flurry.org.codehaus.jackson.map.jsontype.NamedType;
import com.flurry.org.codehaus.jackson.map.jsontype.TypeResolverBuilder;
import com.flurry.org.codehaus.jackson.map.type.ArrayType;
import com.flurry.org.codehaus.jackson.map.type.ClassKey;
import com.flurry.org.codehaus.jackson.map.type.CollectionLikeType;
import com.flurry.org.codehaus.jackson.map.type.CollectionType;
import com.flurry.org.codehaus.jackson.map.type.MapLikeType;
import com.flurry.org.codehaus.jackson.map.type.MapType;
import com.flurry.org.codehaus.jackson.map.type.TypeFactory;
import com.flurry.org.codehaus.jackson.type.JavaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/1.dex */
public abstract class BasicDeserializerFactory extends DeserializerFactory {
    protected static final HashMap<JavaType, JsonDeserializer<Object>> _arrayDeserializers;
    static final HashMap<String, Class<? extends Collection>> _collectionFallbacks;
    protected OptionalHandlerFactory optionalHandlers = OptionalHandlerFactory.instance;
    static final HashMap<ClassKey, JsonDeserializer<Object>> _simpleDeserializers = StdDeserializers.constructAll();
    static final HashMap<JavaType, KeyDeserializer> _keyDeserializers = com.flurry.org.codehaus.jackson.map.deser.std.StdKeyDeserializers.constructAll();
    static final HashMap<String, Class<? extends Map>> _mapFallbacks = new HashMap<>();

    protected abstract JsonDeserializer<?> _findCustomArrayDeserializer(ArrayType arrayType, DeserializationConfig deserializationConfig, DeserializerProvider deserializerProvider, BeanProperty beanProperty, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException;

    protected abstract JsonDeserializer<?> _findCustomCollectionDeserializer(CollectionType collectionType, DeserializationConfig deserializationConfig, DeserializerProvider deserializerProvider, BasicBeanDescription basicBeanDescription, BeanProperty beanProperty, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException;

    protected abstract JsonDeserializer<?> _findCustomCollectionLikeDeserializer(CollectionLikeType collectionLikeType, DeserializationConfig deserializationConfig, DeserializerProvider deserializerProvider, BasicBeanDescription basicBeanDescription, BeanProperty beanProperty, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException;

    protected abstract JsonDeserializer<?> _findCustomEnumDeserializer(Class<?> cls, DeserializationConfig deserializationConfig, BasicBeanDescription basicBeanDescription, BeanProperty beanProperty) throws JsonMappingException;

    protected abstract JsonDeserializer<?> _findCustomMapDeserializer(MapType mapType, DeserializationConfig deserializationConfig, DeserializerProvider deserializerProvider, BasicBeanDescription basicBeanDescription, BeanProperty beanProperty, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException;

    protected abstract JsonDeserializer<?> _findCustomMapLikeDeserializer(MapLikeType mapLikeType, DeserializationConfig deserializationConfig, DeserializerProvider deserializerProvider, BasicBeanDescription basicBeanDescription, BeanProperty beanProperty, KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) throws JsonMappingException;

    protected abstract JsonDeserializer<?> _findCustomTreeNodeDeserializer(Class<? extends JsonNode> cls, DeserializationConfig deserializationConfig, BeanProperty beanProperty) throws JsonMappingException;

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerFactory
    public abstract ValueInstantiator findValueInstantiator(DeserializationConfig deserializationConfig, BasicBeanDescription basicBeanDescription) throws JsonMappingException;

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerFactory
    public abstract JavaType mapAbstractType(DeserializationConfig deserializationConfig, JavaType javaType) throws JsonMappingException;

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerFactory
    public abstract DeserializerFactory withConfig(DeserializerFactory.Config config);

    /* JADX WARN: Multi-variable type inference failed */
    static {
        _mapFallbacks.put(Map.class.getName(), LinkedHashMap.class);
        _mapFallbacks.put(ConcurrentMap.class.getName(), ConcurrentHashMap.class);
        _mapFallbacks.put(SortedMap.class.getName(), TreeMap.class);
        _mapFallbacks.put("java.util.NavigableMap", TreeMap.class);
        try {
            Class<?> key = Class.forName("java.util.ConcurrentNavigableMap");
            Class<?> value = Class.forName("java.util.ConcurrentSkipListMap");
            _mapFallbacks.put(key.getName(), value);
        } catch (ClassNotFoundException e) {
        }
        _collectionFallbacks = new HashMap<>();
        _collectionFallbacks.put(Collection.class.getName(), ArrayList.class);
        _collectionFallbacks.put(List.class.getName(), ArrayList.class);
        _collectionFallbacks.put(Set.class.getName(), HashSet.class);
        _collectionFallbacks.put(SortedSet.class.getName(), TreeSet.class);
        _collectionFallbacks.put(Queue.class.getName(), LinkedList.class);
        _collectionFallbacks.put("java.util.Deque", LinkedList.class);
        _collectionFallbacks.put("java.util.NavigableSet", TreeSet.class);
        _arrayDeserializers = PrimitiveArrayDeserializers.getAll();
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerFactory
    public JsonDeserializer<?> createArrayDeserializer(DeserializationConfig config, DeserializerProvider p, ArrayType type, BeanProperty property) throws JsonMappingException {
        JavaType elemType = type.getContentType();
        JsonDeserializer<Object> contentDeser = (JsonDeserializer) elemType.getValueHandler();
        if (contentDeser == null) {
            JsonDeserializer<?> deser = _arrayDeserializers.get(elemType);
            if (deser != null) {
                JsonDeserializer<?> custom = _findCustomArrayDeserializer(type, config, p, property, null, null);
                return custom != null ? custom : deser;
            } else if (elemType.isPrimitive()) {
                throw new IllegalArgumentException("Internal error: primitive type (" + type + ") passed, no array deserializer found");
            }
        }
        TypeDeserializer elemTypeDeser = (TypeDeserializer) elemType.getTypeHandler();
        if (elemTypeDeser == null) {
            elemTypeDeser = findTypeDeserializer(config, elemType, property);
        }
        JsonDeserializer<?> custom2 = _findCustomArrayDeserializer(type, config, p, property, elemTypeDeser, contentDeser);
        if (custom2 != null) {
            return custom2;
        }
        if (contentDeser == null) {
            contentDeser = p.findValueDeserializer(config, elemType, property);
        }
        return new ObjectArrayDeserializer(type, contentDeser, elemTypeDeser);
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerFactory
    public JsonDeserializer<?> createCollectionDeserializer(DeserializationConfig config, DeserializerProvider p, CollectionType type, BeanProperty property) throws JsonMappingException {
        CollectionType type2 = (CollectionType) mapAbstractType(config, type);
        Class<?> collectionClass = type2.getRawClass();
        BasicBeanDescription beanDesc = (BasicBeanDescription) config.introspectForCreation(type2);
        JsonDeserializer<Object> deser = findDeserializerFromAnnotation(config, beanDesc.getClassInfo(), property);
        if (deser == null) {
            CollectionType type3 = (CollectionType) modifyTypeByAnnotation(config, beanDesc.getClassInfo(), type2, null);
            JavaType contentType = type3.getContentType();
            JsonDeserializer<Object> contentDeser = (JsonDeserializer) contentType.getValueHandler();
            TypeDeserializer contentTypeDeser = (TypeDeserializer) contentType.getTypeHandler();
            if (contentTypeDeser == null) {
                contentTypeDeser = findTypeDeserializer(config, contentType, property);
            }
            JsonDeserializer<?> custom = _findCustomCollectionDeserializer(type3, config, p, beanDesc, property, contentTypeDeser, contentDeser);
            if (custom != null) {
                return custom;
            }
            if (contentDeser == null) {
                if (EnumSet.class.isAssignableFrom(collectionClass)) {
                    return new EnumSetDeserializer(contentType.getRawClass(), createEnumDeserializer(config, p, contentType, property));
                }
                contentDeser = p.findValueDeserializer(config, contentType, property);
            }
            if (type3.isInterface() || type3.isAbstract()) {
                Class<? extends Collection> fallback = _collectionFallbacks.get(collectionClass.getName());
                if (fallback == null) {
                    throw new IllegalArgumentException("Can not find a deserializer for non-concrete Collection type " + type3);
                }
                type3 = (CollectionType) config.constructSpecializedType(type3, fallback);
                beanDesc = (BasicBeanDescription) config.introspectForCreation(type3);
            }
            ValueInstantiator inst = findValueInstantiator(config, beanDesc);
            if (contentType.getRawClass() == String.class) {
                return new StringCollectionDeserializer(type3, contentDeser, inst);
            }
            return new com.flurry.org.codehaus.jackson.map.deser.std.CollectionDeserializer(type3, contentDeser, contentTypeDeser, inst);
        }
        return deser;
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerFactory
    public JsonDeserializer<?> createCollectionLikeDeserializer(DeserializationConfig config, DeserializerProvider p, CollectionLikeType type, BeanProperty property) throws JsonMappingException {
        CollectionLikeType type2 = (CollectionLikeType) mapAbstractType(config, type);
        Class<?> collectionClass = type2.getRawClass();
        BasicBeanDescription beanDesc = (BasicBeanDescription) config.introspectClassAnnotations(collectionClass);
        JsonDeserializer<Object> deser = findDeserializerFromAnnotation(config, beanDesc.getClassInfo(), property);
        if (deser == null) {
            CollectionLikeType type3 = (CollectionLikeType) modifyTypeByAnnotation(config, beanDesc.getClassInfo(), type2, null);
            JavaType contentType = type3.getContentType();
            JsonDeserializer<Object> contentDeser = (JsonDeserializer) contentType.getValueHandler();
            TypeDeserializer contentTypeDeser = (TypeDeserializer) contentType.getTypeHandler();
            if (contentTypeDeser == null) {
                contentTypeDeser = findTypeDeserializer(config, contentType, property);
            }
            return _findCustomCollectionLikeDeserializer(type3, config, p, beanDesc, property, contentTypeDeser, contentDeser);
        }
        return deser;
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerFactory
    public JsonDeserializer<?> createMapDeserializer(DeserializationConfig config, DeserializerProvider p, MapType type, BeanProperty property) throws JsonMappingException {
        MapType type2 = (MapType) mapAbstractType(config, type);
        BasicBeanDescription beanDesc = (BasicBeanDescription) config.introspectForCreation(type2);
        JsonDeserializer<Object> deser = findDeserializerFromAnnotation(config, beanDesc.getClassInfo(), property);
        if (deser == null) {
            MapType type3 = (MapType) modifyTypeByAnnotation(config, beanDesc.getClassInfo(), type2, null);
            JavaType keyType = type3.getKeyType();
            JavaType contentType = type3.getContentType();
            JsonDeserializer<Object> contentDeser = (JsonDeserializer) contentType.getValueHandler();
            KeyDeserializer keyDes = (KeyDeserializer) keyType.getValueHandler();
            if (keyDes == null) {
                keyDes = p.findKeyDeserializer(config, keyType, property);
            }
            TypeDeserializer contentTypeDeser = (TypeDeserializer) contentType.getTypeHandler();
            if (contentTypeDeser == null) {
                contentTypeDeser = findTypeDeserializer(config, contentType, property);
            }
            JsonDeserializer<?> custom = _findCustomMapDeserializer(type3, config, p, beanDesc, property, keyDes, contentTypeDeser, contentDeser);
            if (custom != null) {
                return custom;
            }
            if (contentDeser == null) {
                contentDeser = p.findValueDeserializer(config, contentType, property);
            }
            Class<?> mapClass = type3.getRawClass();
            if (EnumMap.class.isAssignableFrom(mapClass)) {
                Class<?> kt = keyType.getRawClass();
                if (kt == null || !kt.isEnum()) {
                    throw new IllegalArgumentException("Can not construct EnumMap; generic (key) type not available");
                }
                return new EnumMapDeserializer(keyType.getRawClass(), createEnumDeserializer(config, p, keyType, property), contentDeser);
            }
            if (type3.isInterface() || type3.isAbstract()) {
                Class<? extends Map> fallback = _mapFallbacks.get(mapClass.getName());
                if (fallback == null) {
                    throw new IllegalArgumentException("Can not find a deserializer for non-concrete Map type " + type3);
                }
                type3 = (MapType) config.constructSpecializedType(type3, fallback);
                beanDesc = (BasicBeanDescription) config.introspectForCreation(type3);
            }
            ValueInstantiator inst = findValueInstantiator(config, beanDesc);
            com.flurry.org.codehaus.jackson.map.deser.std.MapDeserializer md = new com.flurry.org.codehaus.jackson.map.deser.std.MapDeserializer(type3, inst, keyDes, contentDeser, contentTypeDeser);
            md.setIgnorableProperties(config.getAnnotationIntrospector().findPropertiesToIgnore(beanDesc.getClassInfo()));
            return md;
        }
        return deser;
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerFactory
    public JsonDeserializer<?> createMapLikeDeserializer(DeserializationConfig config, DeserializerProvider p, MapLikeType type, BeanProperty property) throws JsonMappingException {
        MapLikeType type2 = (MapLikeType) mapAbstractType(config, type);
        BasicBeanDescription beanDesc = (BasicBeanDescription) config.introspectForCreation(type2);
        JsonDeserializer<Object> deser = findDeserializerFromAnnotation(config, beanDesc.getClassInfo(), property);
        if (deser == null) {
            MapLikeType type3 = (MapLikeType) modifyTypeByAnnotation(config, beanDesc.getClassInfo(), type2, null);
            JavaType keyType = type3.getKeyType();
            JavaType contentType = type3.getContentType();
            JsonDeserializer<Object> contentDeser = (JsonDeserializer) contentType.getValueHandler();
            KeyDeserializer keyDes = (KeyDeserializer) keyType.getValueHandler();
            if (keyDes == null) {
                keyDes = p.findKeyDeserializer(config, keyType, property);
            }
            TypeDeserializer contentTypeDeser = (TypeDeserializer) contentType.getTypeHandler();
            if (contentTypeDeser == null) {
                contentTypeDeser = findTypeDeserializer(config, contentType, property);
            }
            return _findCustomMapLikeDeserializer(type3, config, p, beanDesc, property, keyDes, contentTypeDeser, contentDeser);
        }
        return deser;
    }

    @Override // com.flurry.org.codehaus.jackson.map.DeserializerFactory
    public JsonDeserializer<?> createEnumDeserializer(DeserializationConfig config, DeserializerProvider p, JavaType type, BeanProperty property) throws JsonMappingException {
        BasicBeanDescription beanDesc = (BasicBeanDescription) config.introspectForCreation(type);
        JsonDeserializer<?> des = findDeserializerFromAnnotation(config, beanDesc.getClassInfo(), property);
        if (des == null) {
            Class<?> enumClass = type.getRawClass();
            JsonDeserializer<?> custom = _findCustomEnumDeserializer(enumClass, config, beanDesc, property);
            if (custom != null) {
                return custom;
            }
            for (AnnotatedMethod factory : beanDesc.getFactoryMethods()) {
                if (config.getAnnotationIntrospector().hasCreatorAnnotation(factory)) {
                    int argCount = factory.getParameterCount();
                    if (argCount == 1) {
                        Class<?> returnType = factory.getRawType();
                        if (returnType.isAssignableFrom(enumClass)) {
                            return com.flurry.org.codehaus.jackson.map.deser.std.EnumDeserializer.deserializerForCreator(config, enumClass, factory);
                        }
                    }
                    throw new IllegalArgumentException("Unsuitable method (" + factory + ") decorated with @JsonCreator (for Enum type " + enumClass.getName() + ")");
                }
            }
            return new com.flurry.org.codehaus.jackson.map.deser.std.EnumDeserializer(constructEnumResolver(enumClass, config));
        }
        return des;
    }

    /* JADX WARN: Multi-variable type inference failed */
    @Override // com.flurry.org.codehaus.jackson.map.DeserializerFactory
    public JsonDeserializer<?> createTreeDeserializer(DeserializationConfig config, DeserializerProvider p, JavaType nodeType, BeanProperty property) throws JsonMappingException {
        Class<?> rawClass = nodeType.getRawClass();
        JsonDeserializer<?> custom = _findCustomTreeNodeDeserializer(rawClass, config, property);
        return custom != null ? custom : com.flurry.org.codehaus.jackson.map.deser.std.JsonNodeDeserializer.getDeserializer(rawClass);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public JsonDeserializer<Object> findStdBeanDeserializer(DeserializationConfig config, DeserializerProvider p, JavaType type, BeanProperty property) throws JsonMappingException {
        JavaType referencedType;
        Class<?> cls = type.getRawClass();
        JsonDeserializer<Object> deser = _simpleDeserializers.get(new ClassKey(cls));
        if (deser == null) {
            if (AtomicReference.class.isAssignableFrom(cls)) {
                TypeFactory tf = config.getTypeFactory();
                JavaType[] params = tf.findTypeParameters(type, AtomicReference.class);
                if (params == null || params.length < 1) {
                    referencedType = TypeFactory.unknownType();
                } else {
                    referencedType = params[0];
                }
                JsonDeserializer<?> d2 = new AtomicReferenceDeserializer(referencedType, property);
                return d2;
            }
            JsonDeserializer<?> d = this.optionalHandlers.findDeserializer(type, config, p);
            if (d != null) {
                return d;
            }
            return null;
        }
        return deser;
    }

    /* JADX WARN: Multi-variable type inference failed */
    @Override // com.flurry.org.codehaus.jackson.map.DeserializerFactory
    public TypeDeserializer findTypeDeserializer(DeserializationConfig config, JavaType baseType, BeanProperty property) throws JsonMappingException {
        Class<?> cls = baseType.getRawClass();
        BasicBeanDescription bean = (BasicBeanDescription) config.introspectClassAnnotations(cls);
        AnnotatedClass ac = bean.getClassInfo();
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findTypeResolver(config, ac, baseType);
        Collection<NamedType> subtypes = null;
        if (b == null) {
            b = config.getDefaultTyper(baseType);
            if (b == null) {
                return null;
            }
        } else {
            subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(ac, config, ai);
        }
        Class<?> defaultImpl = b.getDefaultImpl();
        TypeResolverBuilder<?> b2 = b;
        if (defaultImpl == null) {
            b2 = b;
            if (baseType.isAbstract()) {
                JavaType defaultType = mapAbstractType(config, baseType);
                b2 = b;
                if (defaultType != null) {
                    b2 = b;
                    if (defaultType.getRawClass() != baseType.getRawClass()) {
                        b2 = b.defaultImpl(defaultType.getRawClass());
                    }
                }
            }
        }
        return b2.buildTypeDeserializer(config, baseType, subtypes, property);
    }

    public TypeDeserializer findPropertyTypeDeserializer(DeserializationConfig config, JavaType baseType, AnnotatedMember annotated, BeanProperty property) throws JsonMappingException {
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findPropertyTypeResolver(config, annotated, baseType);
        if (b == null) {
            return findTypeDeserializer(config, baseType, property);
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(annotated, config, ai);
        return b.buildTypeDeserializer(config, baseType, subtypes, property);
    }

    public TypeDeserializer findPropertyContentTypeDeserializer(DeserializationConfig config, JavaType containerType, AnnotatedMember propertyEntity, BeanProperty property) throws JsonMappingException {
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        TypeResolverBuilder<?> b = ai.findPropertyContentTypeResolver(config, propertyEntity, containerType);
        JavaType contentType = containerType.getContentType();
        if (b == null) {
            return findTypeDeserializer(config, contentType, property);
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypes(propertyEntity, config, ai);
        return b.buildTypeDeserializer(config, contentType, subtypes, property);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public JsonDeserializer<Object> findDeserializerFromAnnotation(DeserializationConfig config, Annotated ann, BeanProperty property) throws JsonMappingException {
        Object deserDef = config.getAnnotationIntrospector().findDeserializer(ann);
        if (deserDef != null) {
            return _constructDeserializer(config, ann, property, deserDef);
        }
        return null;
    }

    JsonDeserializer<Object> _constructDeserializer(DeserializationConfig config, Annotated ann, BeanProperty property, Object deserDef) throws JsonMappingException {
        if (deserDef instanceof JsonDeserializer) {
            JsonDeserializer<Object> deser = (JsonDeserializer) deserDef;
            if (deser instanceof ContextualDeserializer) {
                return ((ContextualDeserializer) deser).createContextual(config, property);
            }
            return deser;
        } else if (!(deserDef instanceof Class)) {
            throw new IllegalStateException("AnnotationIntrospector returned deserializer definition of type " + deserDef.getClass().getName() + "; expected type JsonDeserializer or Class<JsonDeserializer> instead");
        } else {
            Class<? extends JsonDeserializer<?>> deserClass = (Class) deserDef;
            if (!JsonDeserializer.class.isAssignableFrom(deserClass)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + deserClass.getName() + "; expected Class<JsonDeserializer>");
            }
            JsonDeserializer<Object> deser2 = config.deserializerInstance(ann, deserClass);
            if (deser2 instanceof ContextualDeserializer) {
                return ((ContextualDeserializer) deser2).createContextual(config, property);
            }
            return deser2;
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Type inference failed for: r20v15 */
    public <T extends JavaType> T modifyTypeByAnnotation(DeserializationConfig config, Annotated a, T type, String propName) throws JsonMappingException {
        Class<? extends KeyDeserializer> kdClass;
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        Class<?> subclass = intr.findDeserializationType(a, type, propName);
        if (subclass != null) {
            try {
                type = (T) type.narrowBy(subclass);
            } catch (IllegalArgumentException iae) {
                throw new JsonMappingException("Failed to narrow type " + type + " with concrete-type annotation (value " + subclass.getName() + "), method '" + a.getName() + "': " + iae.getMessage(), null, iae);
            }
        }
        boolean isContainerType = type.isContainerType();
        T type2 = type;
        if (isContainerType) {
            Class<?> keyClass = intr.findDeserializationKeyType(a, type.getKeyType(), propName);
            T type3 = type;
            if (keyClass != null) {
                if (!(type instanceof MapLikeType)) {
                    throw new JsonMappingException("Illegal key-type annotation: type " + type + " is not a Map(-like) type");
                }
                try {
                    type3 = (T) type.narrowKey(keyClass);
                } catch (IllegalArgumentException iae2) {
                    throw new JsonMappingException("Failed to narrow key type " + type + " with key-type annotation (" + keyClass.getName() + "): " + iae2.getMessage(), null, iae2);
                }
            }
            JavaType keyType = type3.getKeyType();
            if (keyType != null && keyType.getValueHandler() == null && (kdClass = intr.findKeyDeserializer(a)) != null && kdClass != KeyDeserializer.None.class) {
                KeyDeserializer kd = config.keyDeserializerInstance(a, kdClass);
                keyType.setValueHandler(kd);
            }
            Class<?> cc = intr.findDeserializationContentType(a, type3.getContentType(), propName);
            JavaType type4 = type3;
            if (cc != null) {
                try {
                    type4 = type3.narrowContentsBy(cc);
                } catch (IllegalArgumentException iae3) {
                    throw new JsonMappingException("Failed to narrow content type " + type3 + " with content-type annotation (" + cc.getName() + "): " + iae3.getMessage(), null, iae3);
                }
            }
            JavaType contentType = type4.getContentType();
            type2 = type4;
            if (contentType.getValueHandler() == null) {
                Class<? extends JsonDeserializer<?>> cdClass = intr.findContentDeserializer(a);
                type2 = type4;
                if (cdClass != null) {
                    type2 = type4;
                    if (cdClass != JsonDeserializer.None.class) {
                        JsonDeserializer<Object> cd = config.deserializerInstance(a, cdClass);
                        type4.getContentType().setValueHandler(cd);
                        type2 = type4;
                    }
                }
            }
        }
        return type2;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public JavaType resolveType(DeserializationConfig config, BasicBeanDescription beanDesc, JavaType type, AnnotatedMember member, BeanProperty property) throws JsonMappingException {
        TypeDeserializer valueTypeDeser;
        TypeDeserializer contentTypeDeser;
        Class<? extends KeyDeserializer> kdClass;
        if (type.isContainerType()) {
            AnnotationIntrospector intr = config.getAnnotationIntrospector();
            JavaType keyType = type.getKeyType();
            if (keyType != null && (kdClass = intr.findKeyDeserializer(member)) != null && kdClass != KeyDeserializer.None.class) {
                KeyDeserializer kd = config.keyDeserializerInstance(member, kdClass);
                keyType.setValueHandler(kd);
            }
            Class<? extends JsonDeserializer<?>> cdClass = intr.findContentDeserializer(member);
            if (cdClass != null && cdClass != JsonDeserializer.None.class) {
                JsonDeserializer<Object> cd = config.deserializerInstance(member, cdClass);
                type.getContentType().setValueHandler(cd);
            }
            if ((member instanceof AnnotatedMember) && (contentTypeDeser = findPropertyContentTypeDeserializer(config, type, member, property)) != null) {
                type = type.withContentTypeHandler(contentTypeDeser);
            }
        }
        if (member instanceof AnnotatedMember) {
            valueTypeDeser = findPropertyTypeDeserializer(config, type, member, property);
        } else {
            valueTypeDeser = findTypeDeserializer(config, type, null);
        }
        if (valueTypeDeser != null) {
            return type.withTypeHandler(valueTypeDeser);
        }
        return type;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public com.flurry.org.codehaus.jackson.map.util.EnumResolver<?> constructEnumResolver(Class<?> enumClass, DeserializationConfig config) {
        return config.isEnabled(DeserializationConfig.Feature.READ_ENUMS_USING_TO_STRING) ? com.flurry.org.codehaus.jackson.map.util.EnumResolver.constructUnsafeUsingToString(enumClass) : com.flurry.org.codehaus.jackson.map.util.EnumResolver.constructUnsafe(enumClass, config.getAnnotationIntrospector());
    }
}
