package com.flurry.org.codehaus.jackson.map;

import com.flurry.org.codehaus.jackson.map.BeanDescription;
import com.flurry.org.codehaus.jackson.type.JavaType;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public abstract class ClassIntrospector<T extends BeanDescription> {

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public interface MixInResolver {
        Class<?> findMixInClassFor(Class<?> cls);
    }

    public abstract T forClassAnnotations(MapperConfig<?> mapperConfig, JavaType javaType, MixInResolver mixInResolver);

    public abstract T forCreation(DeserializationConfig deserializationConfig, JavaType javaType, MixInResolver mixInResolver);

    public abstract T forDeserialization(DeserializationConfig deserializationConfig, JavaType javaType, MixInResolver mixInResolver);

    public abstract T forDirectClassAnnotations(MapperConfig<?> mapperConfig, JavaType javaType, MixInResolver mixInResolver);

    public abstract T forSerialization(SerializationConfig serializationConfig, JavaType javaType, MixInResolver mixInResolver);

    @Deprecated
    public T forClassAnnotations(MapperConfig<?> cfg, Class<?> cls, MixInResolver r) {
        return forClassAnnotations(cfg, cfg.constructType(cls), r);
    }

    @Deprecated
    public T forDirectClassAnnotations(MapperConfig<?> cfg, Class<?> cls, MixInResolver r) {
        return forDirectClassAnnotations(cfg, cfg.constructType(cls), r);
    }
}
