package com.flurry.org.codehaus.jackson.map;

import com.flurry.org.codehaus.jackson.map.introspect.AnnotatedMember;
import com.flurry.org.codehaus.jackson.map.util.Annotations;
import com.flurry.org.codehaus.jackson.map.util.Named;
import com.flurry.org.codehaus.jackson.type.JavaType;
import java.lang.annotation.Annotation;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public interface BeanProperty extends Named {
    <A extends Annotation> A getAnnotation(Class<A> cls);

    <A extends Annotation> A getContextAnnotation(Class<A> cls);

    AnnotatedMember getMember();

    @Override // com.flurry.org.codehaus.jackson.map.util.Named
    String getName();

    JavaType getType();

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public static class Std implements BeanProperty {
        protected final Annotations _contextAnnotations;
        protected final AnnotatedMember _member;
        protected final String _name;
        protected final JavaType _type;

        public Std(String name, JavaType type, Annotations contextAnnotations, AnnotatedMember member) {
            this._name = name;
            this._type = type;
            this._member = member;
            this._contextAnnotations = contextAnnotations;
        }

        public Std withType(JavaType type) {
            return new Std(this._name, type, this._contextAnnotations, this._member);
        }

        @Override // com.flurry.org.codehaus.jackson.map.BeanProperty
        public <A extends Annotation> A getAnnotation(Class<A> acls) {
            return (A) this._member.getAnnotation(acls);
        }

        @Override // com.flurry.org.codehaus.jackson.map.BeanProperty
        public <A extends Annotation> A getContextAnnotation(Class<A> acls) {
            if (this._contextAnnotations == null) {
                return null;
            }
            return (A) this._contextAnnotations.get(acls);
        }

        @Override // com.flurry.org.codehaus.jackson.map.BeanProperty, com.flurry.org.codehaus.jackson.map.util.Named
        public String getName() {
            return this._name;
        }

        @Override // com.flurry.org.codehaus.jackson.map.BeanProperty
        public JavaType getType() {
            return this._type;
        }

        @Override // com.flurry.org.codehaus.jackson.map.BeanProperty
        public AnnotatedMember getMember() {
            return this._member;
        }
    }
}
