package com.flurry.org.codehaus.jackson.io;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public final class NumberInput {
    static final long L_BILLION = 1000000000;
    public static final String NASTY_SMALL_DOUBLE = "2.2250738585072012e-308";
    static final String MIN_LONG_STR_NO_SIGN = String.valueOf(Long.MIN_VALUE).substring(1);
    static final String MAX_LONG_STR = String.valueOf(Long.MAX_VALUE);

    public static final int parseInt(char[] digitChars, int offset, int len) {
        int offset2;
        int num = digitChars[offset] - '0';
        int len2 = len + offset;
        int offset3 = offset + 1;
        if (offset3 < len2) {
            int num2 = (num * 10) + (digitChars[offset3] - '0');
            int offset4 = offset3 + 1;
            if (offset4 < len2) {
                int num3 = (num2 * 10) + (digitChars[offset4] - '0');
                int offset5 = offset4 + 1;
                if (offset5 < len2) {
                    int num4 = (num3 * 10) + (digitChars[offset5] - '0');
                    int offset6 = offset5 + 1;
                    if (offset6 < len2) {
                        int num5 = (num4 * 10) + (digitChars[offset6] - '0');
                        int offset7 = offset6 + 1;
                        if (offset7 < len2) {
                            int num6 = (num5 * 10) + (digitChars[offset7] - '0');
                            int offset8 = offset7 + 1;
                            if (offset8 < len2) {
                                int num7 = (num6 * 10) + (digitChars[offset8] - '0');
                                int offset9 = offset8 + 1;
                                if (offset9 < len2) {
                                    int num8 = (num7 * 10) + (digitChars[offset9] - '0');
                                    if (offset9 + 1 < len2) {
                                        return (num8 * 10) + (digitChars[offset2] - '0');
                                    }
                                    return num8;
                                }
                                return num7;
                            }
                            return num6;
                        }
                        return num5;
                    }
                    return num4;
                }
                return num3;
            }
            return num2;
        }
        return num;
    }

    /* JADX WARN: Removed duplicated region for block: B:41:0x0089  */
    /* JADX WARN: Removed duplicated region for block: B:51:? A[RETURN, SYNTHETIC] */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public static final int parseInt(java.lang.String r10) {
        /*
            r6 = 1
            r2 = 0
            r9 = 57
            r8 = 48
            char r0 = r10.charAt(r2)
            int r1 = r10.length()
            r7 = 45
            if (r0 != r7) goto L13
            r2 = r6
        L13:
            r4 = 1
            if (r2 == 0) goto L31
            if (r1 == r6) goto L1c
            r6 = 10
            if (r1 <= r6) goto L21
        L1c:
            int r3 = java.lang.Integer.parseInt(r10)
        L20:
            return r3
        L21:
            int r5 = r4 + 1
            char r0 = r10.charAt(r4)
        L27:
            if (r0 > r9) goto L2b
            if (r0 >= r8) goto L3a
        L2b:
            int r3 = java.lang.Integer.parseInt(r10)
            r4 = r5
            goto L20
        L31:
            r6 = 9
            if (r1 <= r6) goto L8b
            int r3 = java.lang.Integer.parseInt(r10)
            goto L20
        L3a:
            int r3 = r0 + (-48)
            if (r5 >= r1) goto L86
            int r4 = r5 + 1
            char r0 = r10.charAt(r5)
            if (r0 > r9) goto L48
            if (r0 >= r8) goto L4d
        L48:
            int r3 = java.lang.Integer.parseInt(r10)
            goto L20
        L4d:
            int r6 = r3 * 10
            int r7 = r0 + (-48)
            int r3 = r6 + r7
            if (r4 >= r1) goto L87
            int r5 = r4 + 1
            char r0 = r10.charAt(r4)
            if (r0 > r9) goto L5f
            if (r0 >= r8) goto L65
        L5f:
            int r3 = java.lang.Integer.parseInt(r10)
            r4 = r5
            goto L20
        L65:
            int r6 = r3 * 10
            int r7 = r0 + (-48)
            int r3 = r6 + r7
            if (r5 >= r1) goto L86
        L6d:
            r4 = r5
            int r5 = r4 + 1
            char r0 = r10.charAt(r4)
            if (r0 > r9) goto L78
            if (r0 >= r8) goto L7e
        L78:
            int r3 = java.lang.Integer.parseInt(r10)
            r4 = r5
            goto L20
        L7e:
            int r6 = r3 * 10
            int r7 = r0 + (-48)
            int r3 = r6 + r7
            if (r5 < r1) goto L6d
        L86:
            r4 = r5
        L87:
            if (r2 == 0) goto L20
            int r3 = -r3
            goto L20
        L8b:
            r5 = r4
            goto L27
        */
        throw new UnsupportedOperationException("Method not decompiled: com.flurry.org.codehaus.jackson.io.NumberInput.parseInt(java.lang.String):int");
    }

    public static final long parseLong(char[] digitChars, int offset, int len) {
        int len1 = len - 9;
        long val = parseInt(digitChars, offset, len1) * L_BILLION;
        return parseInt(digitChars, offset + len1, 9) + val;
    }

    public static final long parseLong(String str) {
        int length = str.length();
        return length <= 9 ? parseInt(str) : Long.parseLong(str);
    }

    public static final boolean inLongRange(char[] digitChars, int offset, int len, boolean negative) {
        String cmpStr = negative ? MIN_LONG_STR_NO_SIGN : MAX_LONG_STR;
        int cmpLen = cmpStr.length();
        if (len < cmpLen) {
            return true;
        }
        if (len > cmpLen) {
            return false;
        }
        for (int i = 0; i < cmpLen; i++) {
            int diff = digitChars[offset + i] - cmpStr.charAt(i);
            if (diff != 0) {
                return diff < 0;
            }
        }
        return true;
    }

    public static final boolean inLongRange(String numberStr, boolean negative) {
        String cmpStr = negative ? MIN_LONG_STR_NO_SIGN : MAX_LONG_STR;
        int cmpLen = cmpStr.length();
        int actualLen = numberStr.length();
        if (actualLen < cmpLen) {
            return true;
        }
        if (actualLen > cmpLen) {
            return false;
        }
        for (int i = 0; i < cmpLen; i++) {
            int diff = numberStr.charAt(i) - cmpStr.charAt(i);
            if (diff != 0) {
                return diff < 0;
            }
        }
        return true;
    }

    public static int parseAsInt(String input, int defaultValue) {
        String input2;
        int len;
        if (input != null && (len = (input2 = input.trim()).length()) != 0) {
            int i = 0;
            if (0 < len) {
                char c = input2.charAt(0);
                if (c == '+') {
                    input2 = input2.substring(1);
                    len = input2.length();
                } else if (c == '-') {
                    i = 0 + 1;
                }
            }
            while (i < len) {
                char c2 = input2.charAt(i);
                if (c2 <= '9' && c2 >= '0') {
                    i++;
                } else {
                    try {
                        return (int) parseDouble(input2);
                    } catch (NumberFormatException e) {
                        return defaultValue;
                    }
                }
            }
            try {
                return Integer.parseInt(input2);
            } catch (NumberFormatException e2) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static long parseAsLong(String input, long defaultValue) {
        String input2;
        int len;
        if (input != null && (len = (input2 = input.trim()).length()) != 0) {
            int i = 0;
            if (0 < len) {
                char c = input2.charAt(0);
                if (c == '+') {
                    input2 = input2.substring(1);
                    len = input2.length();
                } else if (c == '-') {
                    i = 0 + 1;
                }
            }
            while (i < len) {
                char c2 = input2.charAt(i);
                if (c2 <= '9' && c2 >= '0') {
                    i++;
                } else {
                    try {
                        return (long) parseDouble(input2);
                    } catch (NumberFormatException e) {
                        return defaultValue;
                    }
                }
            }
            try {
                return Long.parseLong(input2);
            } catch (NumberFormatException e2) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public static double parseAsDouble(String input, double defaultValue) {
        if (input != null) {
            String input2 = input.trim();
            int len = input2.length();
            if (len != 0) {
                try {
                    return parseDouble(input2);
                } catch (NumberFormatException e) {
                    return defaultValue;
                }
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public static final double parseDouble(String numStr) throws NumberFormatException {
        if (NASTY_SMALL_DOUBLE.equals(numStr)) {
            return Double.MIN_NORMAL;
        }
        return Double.parseDouble(numStr);
    }
}
