package com.flurry.org.codehaus.jackson.impl;

import com.flurry.org.codehaus.jackson.JsonStreamContext;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class JsonWriteContext extends JsonStreamContext {
    public static final int STATUS_EXPECT_NAME = 5;
    public static final int STATUS_EXPECT_VALUE = 4;
    public static final int STATUS_OK_AFTER_COLON = 2;
    public static final int STATUS_OK_AFTER_COMMA = 1;
    public static final int STATUS_OK_AFTER_SPACE = 3;
    public static final int STATUS_OK_AS_IS = 0;
    protected JsonWriteContext _child = null;
    protected String _currentName;
    protected final JsonWriteContext _parent;

    protected JsonWriteContext(int type, JsonWriteContext parent) {
        this._type = type;
        this._parent = parent;
        this._index = -1;
    }

    public static JsonWriteContext createRootContext() {
        return new JsonWriteContext(0, null);
    }

    private final JsonWriteContext reset(int type) {
        this._type = type;
        this._index = -1;
        this._currentName = null;
        return this;
    }

    public final JsonWriteContext createChildArrayContext() {
        JsonWriteContext ctxt = this._child;
        if (ctxt == null) {
            JsonWriteContext ctxt2 = new JsonWriteContext(1, this);
            this._child = ctxt2;
            return ctxt2;
        }
        return ctxt.reset(1);
    }

    public final JsonWriteContext createChildObjectContext() {
        JsonWriteContext ctxt = this._child;
        if (ctxt == null) {
            JsonWriteContext ctxt2 = new JsonWriteContext(2, this);
            this._child = ctxt2;
            return ctxt2;
        }
        return ctxt.reset(2);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonStreamContext
    public final JsonWriteContext getParent() {
        return this._parent;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonStreamContext
    public final String getCurrentName() {
        return this._currentName;
    }

    public final int writeFieldName(String name) {
        if (this._type == 2 && this._currentName == null) {
            this._currentName = name;
            return this._index < 0 ? 0 : 1;
        }
        return 4;
    }

    public final int writeValue() {
        if (this._type == 2) {
            if (this._currentName == null) {
                return 5;
            }
            this._currentName = null;
            this._index++;
            return 2;
        } else if (this._type == 1) {
            int ix = this._index;
            this._index++;
            return ix >= 0 ? 1 : 0;
        } else {
            this._index++;
            return this._index != 0 ? 3 : 0;
        }
    }

    protected final void appendDesc(StringBuilder sb) {
        if (this._type == 2) {
            sb.append('{');
            if (this._currentName != null) {
                sb.append('\"');
                sb.append(this._currentName);
                sb.append('\"');
            } else {
                sb.append('?');
            }
            sb.append('}');
        } else if (this._type == 1) {
            sb.append('[');
            sb.append(getCurrentIndex());
            sb.append(']');
        } else {
            sb.append("/");
        }
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(64);
        appendDesc(sb);
        return sb.toString();
    }
}
