package com.flurry.org.codehaus.jackson.impl;

import com.flurry.org.codehaus.jackson.Base64Variant;
import com.flurry.org.codehaus.jackson.JsonParseException;
import com.flurry.org.codehaus.jackson.JsonParser;
import com.flurry.org.codehaus.jackson.JsonProcessingException;
import com.flurry.org.codehaus.jackson.JsonStreamContext;
import com.flurry.org.codehaus.jackson.JsonToken;
import com.flurry.org.codehaus.jackson.io.NumberInput;
import com.prime31.util.IabHelper;
import java.io.IOException;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public abstract class JsonParserMinimalBase extends JsonParser {
    protected static final int INT_APOSTROPHE = 39;
    protected static final int INT_ASTERISK = 42;
    protected static final int INT_BACKSLASH = 92;
    protected static final int INT_COLON = 58;
    protected static final int INT_COMMA = 44;
    protected static final int INT_CR = 13;
    protected static final int INT_LBRACKET = 91;
    protected static final int INT_LCURLY = 123;
    protected static final int INT_LF = 10;
    protected static final int INT_QUOTE = 34;
    protected static final int INT_RBRACKET = 93;
    protected static final int INT_RCURLY = 125;
    protected static final int INT_SLASH = 47;
    protected static final int INT_SPACE = 32;
    protected static final int INT_TAB = 9;
    protected static final int INT_b = 98;
    protected static final int INT_f = 102;
    protected static final int INT_n = 110;
    protected static final int INT_r = 114;
    protected static final int INT_t = 116;
    protected static final int INT_u = 117;

    protected abstract void _handleEOF() throws JsonParseException;

    @Override // com.flurry.org.codehaus.jackson.JsonParser, java.io.Closeable, java.lang.AutoCloseable
    public abstract void close() throws IOException;

    @Override // com.flurry.org.codehaus.jackson.JsonParser
    public abstract byte[] getBinaryValue(Base64Variant base64Variant) throws IOException, JsonParseException;

    @Override // com.flurry.org.codehaus.jackson.JsonParser
    public abstract String getCurrentName() throws IOException, JsonParseException;

    @Override // com.flurry.org.codehaus.jackson.JsonParser
    public abstract JsonStreamContext getParsingContext();

    @Override // com.flurry.org.codehaus.jackson.JsonParser
    public abstract String getText() throws IOException, JsonParseException;

    @Override // com.flurry.org.codehaus.jackson.JsonParser
    public abstract char[] getTextCharacters() throws IOException, JsonParseException;

    @Override // com.flurry.org.codehaus.jackson.JsonParser
    public abstract int getTextLength() throws IOException, JsonParseException;

    @Override // com.flurry.org.codehaus.jackson.JsonParser
    public abstract int getTextOffset() throws IOException, JsonParseException;

    @Override // com.flurry.org.codehaus.jackson.JsonParser
    public abstract boolean hasTextCharacters();

    @Override // com.flurry.org.codehaus.jackson.JsonParser
    public abstract boolean isClosed();

    @Override // com.flurry.org.codehaus.jackson.JsonParser
    public abstract JsonToken nextToken() throws IOException, JsonParseException;

    /* JADX INFO: Access modifiers changed from: protected */
    public JsonParserMinimalBase() {
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public JsonParserMinimalBase(int features) {
        super(features);
    }

    @Override // com.flurry.org.codehaus.jackson.JsonParser
    public JsonParser skipChildren() throws IOException, JsonParseException {
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            int open = 1;
            while (true) {
                JsonToken t = nextToken();
                if (t == null) {
                    _handleEOF();
                } else {
                    switch (t) {
                        case START_OBJECT:
                        case START_ARRAY:
                            open++;
                            break;
                        case END_OBJECT:
                        case END_ARRAY:
                            open--;
                            if (open != 0) {
                                break;
                            } else {
                                break;
                            }
                    }
                }
            }
        }
        return this;
    }

    /* JADX WARN: Removed duplicated region for block: B:23:? A[RETURN, SYNTHETIC] */
    @Override // com.flurry.org.codehaus.jackson.JsonParser
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public boolean getValueAsBoolean(boolean r7) throws java.io.IOException, com.flurry.org.codehaus.jackson.JsonParseException {
        /*
            r6 = this;
            r3 = 0
            r2 = 1
            com.flurry.org.codehaus.jackson.JsonToken r4 = r6._currToken
            if (r4 == 0) goto L13
            int[] r4 = com.flurry.org.codehaus.jackson.impl.JsonParserMinimalBase.AnonymousClass1.$SwitchMap$org$codehaus$jackson$JsonToken
            com.flurry.org.codehaus.jackson.JsonToken r5 = r6._currToken
            int r5 = r5.ordinal()
            r4 = r4[r5]
            switch(r4) {
                case 5: goto L15;
                case 6: goto L14;
                case 7: goto L1d;
                case 8: goto L1d;
                case 9: goto L1f;
                case 10: goto L2e;
                default: goto L13;
            }
        L13:
            r2 = r7
        L14:
            return r2
        L15:
            int r4 = r6.getIntValue()
            if (r4 != 0) goto L14
            r2 = r3
            goto L14
        L1d:
            r2 = r3
            goto L14
        L1f:
            java.lang.Object r1 = r6.getEmbeddedObject()
            boolean r3 = r1 instanceof java.lang.Boolean
            if (r3 == 0) goto L2e
            java.lang.Boolean r1 = (java.lang.Boolean) r1
            boolean r2 = r1.booleanValue()
            goto L14
        L2e:
            java.lang.String r3 = r6.getText()
            java.lang.String r0 = r3.trim()
            java.lang.String r3 = "true"
            boolean r3 = r3.equals(r0)
            if (r3 == 0) goto L13
            goto L14
        */
        throw new UnsupportedOperationException("Method not decompiled: com.flurry.org.codehaus.jackson.impl.JsonParserMinimalBase.getValueAsBoolean(boolean):boolean");
    }

    @Override // com.flurry.org.codehaus.jackson.JsonParser
    public int getValueAsInt(int defaultValue) throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (AnonymousClass1.$SwitchMap$org$codehaus$jackson$JsonToken[this._currToken.ordinal()]) {
                case 5:
                case 11:
                    return getIntValue();
                case 6:
                    return 1;
                case IabHelper.BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED /* 7 */:
                case 8:
                    return 0;
                case INT_TAB /* 9 */:
                    Object value = getEmbeddedObject();
                    if (value instanceof Number) {
                        return ((Number) value).intValue();
                    }
                    return defaultValue;
                case 10:
                    return NumberInput.parseAsInt(getText(), defaultValue);
                default:
                    return defaultValue;
            }
        }
        return defaultValue;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonParser
    public long getValueAsLong(long defaultValue) throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (AnonymousClass1.$SwitchMap$org$codehaus$jackson$JsonToken[this._currToken.ordinal()]) {
                case 5:
                case 11:
                    return getLongValue();
                case 6:
                    return 1L;
                case IabHelper.BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED /* 7 */:
                case 8:
                    return 0L;
                case INT_TAB /* 9 */:
                    Object value = getEmbeddedObject();
                    if (value instanceof Number) {
                        return ((Number) value).longValue();
                    }
                    return defaultValue;
                case 10:
                    return NumberInput.parseAsLong(getText(), defaultValue);
                default:
                    return defaultValue;
            }
        }
        return defaultValue;
    }

    @Override // com.flurry.org.codehaus.jackson.JsonParser
    public double getValueAsDouble(double defaultValue) throws IOException, JsonParseException {
        if (this._currToken != null) {
            switch (AnonymousClass1.$SwitchMap$org$codehaus$jackson$JsonToken[this._currToken.ordinal()]) {
                case 5:
                case 11:
                    return getDoubleValue();
                case 6:
                    return 1.0d;
                case IabHelper.BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED /* 7 */:
                case 8:
                    return 0.0d;
                case INT_TAB /* 9 */:
                    Object value = getEmbeddedObject();
                    if (value instanceof Number) {
                        return ((Number) value).doubleValue();
                    }
                    return defaultValue;
                case 10:
                    return NumberInput.parseAsDouble(getText(), defaultValue);
                default:
                    return defaultValue;
            }
        }
        return defaultValue;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    /* JADX WARN: Code restructure failed: missing block: B:10:0x0018, code lost:
        r0 = r14.decodeBase64Char(r1);
     */
    /* JADX WARN: Code restructure failed: missing block: B:11:0x001c, code lost:
        if (r0 >= 0) goto L12;
     */
    /* JADX WARN: Code restructure failed: missing block: B:12:0x001e, code lost:
        _reportInvalidBase64(r14, r1, 0, null);
     */
    /* JADX WARN: Code restructure failed: missing block: B:14:0x0023, code lost:
        if (r5 < r3) goto L15;
     */
    /* JADX WARN: Code restructure failed: missing block: B:15:0x0025, code lost:
        _reportBase64EOF();
     */
    /* JADX WARN: Code restructure failed: missing block: B:16:0x0028, code lost:
        r4 = r5 + 1;
        r1 = r12.charAt(r5);
        r0 = r14.decodeBase64Char(r1);
     */
    /* JADX WARN: Code restructure failed: missing block: B:17:0x0032, code lost:
        if (r0 >= 0) goto L18;
     */
    /* JADX WARN: Code restructure failed: missing block: B:18:0x0034, code lost:
        _reportInvalidBase64(r14, r1, 1, null);
     */
    /* JADX WARN: Code restructure failed: missing block: B:19:0x0038, code lost:
        r2 = (r0 << 6) | r0;
     */
    /* JADX WARN: Code restructure failed: missing block: B:20:0x003c, code lost:
        if (r4 < r3) goto L27;
     */
    /* JADX WARN: Code restructure failed: missing block: B:22:0x0042, code lost:
        if (r14.usesPadding() != false) goto L22;
     */
    /* JADX WARN: Code restructure failed: missing block: B:23:0x0044, code lost:
        r13.append(r2 >> 4);
     */
    /* JADX WARN: Code restructure failed: missing block: B:24:0x004a, code lost:
        _reportBase64EOF();
     */
    /* JADX WARN: Code restructure failed: missing block: B:25:0x004d, code lost:
        r5 = r4 + 1;
        r1 = r12.charAt(r4);
        r0 = r14.decodeBase64Char(r1);
     */
    /* JADX WARN: Code restructure failed: missing block: B:26:0x0057, code lost:
        if (r0 >= 0) goto L29;
     */
    /* JADX WARN: Code restructure failed: missing block: B:27:0x0059, code lost:
        if (r0 == (-2)) goto L52;
     */
    /* JADX WARN: Code restructure failed: missing block: B:28:0x005b, code lost:
        _reportInvalidBase64(r14, r1, 2, null);
     */
    /* JADX WARN: Code restructure failed: missing block: B:29:0x005f, code lost:
        if (r5 < r3) goto L54;
     */
    /* JADX WARN: Code restructure failed: missing block: B:30:0x0061, code lost:
        _reportBase64EOF();
     */
    /* JADX WARN: Code restructure failed: missing block: B:31:0x0064, code lost:
        r4 = r5 + 1;
        r1 = r12.charAt(r5);
     */
    /* JADX WARN: Code restructure failed: missing block: B:32:0x006e, code lost:
        if (r14.usesPaddingChar(r1) != false) goto L57;
     */
    /* JADX WARN: Code restructure failed: missing block: B:33:0x0070, code lost:
        _reportInvalidBase64(r14, r1, 3, "expected padding character '" + r14.getPaddingChar() + "'");
     */
    /* JADX WARN: Code restructure failed: missing block: B:34:0x0090, code lost:
        r13.append(r2 >> 4);
     */
    /* JADX WARN: Code restructure failed: missing block: B:35:0x0097, code lost:
        r2 = (r2 << 6) | r0;
     */
    /* JADX WARN: Code restructure failed: missing block: B:36:0x009b, code lost:
        if (r5 < r3) goto L38;
     */
    /* JADX WARN: Code restructure failed: missing block: B:38:0x00a1, code lost:
        if (r14.usesPadding() != false) goto L34;
     */
    /* JADX WARN: Code restructure failed: missing block: B:39:0x00a3, code lost:
        r13.appendTwoBytes(r2 >> 2);
     */
    /* JADX WARN: Code restructure failed: missing block: B:40:0x00ab, code lost:
        _reportBase64EOF();
     */
    /* JADX WARN: Code restructure failed: missing block: B:41:0x00ae, code lost:
        r4 = r5 + 1;
        r1 = r12.charAt(r5);
        r0 = r14.decodeBase64Char(r1);
     */
    /* JADX WARN: Code restructure failed: missing block: B:42:0x00b8, code lost:
        if (r0 >= 0) goto L40;
     */
    /* JADX WARN: Code restructure failed: missing block: B:43:0x00ba, code lost:
        if (r0 == (-2)) goto L47;
     */
    /* JADX WARN: Code restructure failed: missing block: B:44:0x00bc, code lost:
        _reportInvalidBase64(r14, r1, 3, null);
     */
    /* JADX WARN: Code restructure failed: missing block: B:45:0x00bf, code lost:
        r13.appendTwoBytes(r2 >> 2);
     */
    /* JADX WARN: Code restructure failed: missing block: B:46:0x00c6, code lost:
        r13.appendThreeBytes((r2 << 6) | r0);
     */
    /* JADX WARN: Code restructure failed: missing block: B:61:?, code lost:
        return;
     */
    /* JADX WARN: Code restructure failed: missing block: B:62:?, code lost:
        return;
     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public void _decodeBase64(java.lang.String r12, com.flurry.org.codehaus.jackson.util.ByteArrayBuilder r13, com.flurry.org.codehaus.jackson.Base64Variant r14) throws java.io.IOException, com.flurry.org.codehaus.jackson.JsonParseException {
        /*
            r11 = this;
            r10 = 3
            r9 = -2
            r8 = 0
            r4 = 0
            int r3 = r12.length()
        L8:
            if (r4 >= r3) goto L13
        La:
            int r5 = r4 + 1
            char r1 = r12.charAt(r4)
            if (r5 < r3) goto L14
            r4 = r5
        L13:
            return
        L14:
            r6 = 32
            if (r1 <= r6) goto Lcf
            int r0 = r14.decodeBase64Char(r1)
            if (r0 >= 0) goto L22
            r6 = 0
            r11._reportInvalidBase64(r14, r1, r6, r8)
        L22:
            r2 = r0
            if (r5 < r3) goto L28
            r11._reportBase64EOF()
        L28:
            int r4 = r5 + 1
            char r1 = r12.charAt(r5)
            int r0 = r14.decodeBase64Char(r1)
            if (r0 >= 0) goto L38
            r6 = 1
            r11._reportInvalidBase64(r14, r1, r6, r8)
        L38:
            int r6 = r2 << 6
            r2 = r6 | r0
            if (r4 < r3) goto L4d
            boolean r6 = r14.usesPadding()
            if (r6 != 0) goto L4a
            int r2 = r2 >> 4
            r13.append(r2)
            goto L13
        L4a:
            r11._reportBase64EOF()
        L4d:
            int r5 = r4 + 1
            char r1 = r12.charAt(r4)
            int r0 = r14.decodeBase64Char(r1)
            if (r0 >= 0) goto L97
            if (r0 == r9) goto L5f
            r6 = 2
            r11._reportInvalidBase64(r14, r1, r6, r8)
        L5f:
            if (r5 < r3) goto L64
            r11._reportBase64EOF()
        L64:
            int r4 = r5 + 1
            char r1 = r12.charAt(r5)
            boolean r6 = r14.usesPaddingChar(r1)
            if (r6 != 0) goto L90
            java.lang.StringBuilder r6 = new java.lang.StringBuilder
            r6.<init>()
            java.lang.String r7 = "expected padding character '"
            java.lang.StringBuilder r6 = r6.append(r7)
            char r7 = r14.getPaddingChar()
            java.lang.StringBuilder r6 = r6.append(r7)
            java.lang.String r7 = "'"
            java.lang.StringBuilder r6 = r6.append(r7)
            java.lang.String r6 = r6.toString()
            r11._reportInvalidBase64(r14, r1, r10, r6)
        L90:
            int r2 = r2 >> 4
            r13.append(r2)
            goto L8
        L97:
            int r6 = r2 << 6
            r2 = r6 | r0
            if (r5 < r3) goto Lae
            boolean r6 = r14.usesPadding()
            if (r6 != 0) goto Lab
            int r2 = r2 >> 2
            r13.appendTwoBytes(r2)
            r4 = r5
            goto L13
        Lab:
            r11._reportBase64EOF()
        Lae:
            int r4 = r5 + 1
            char r1 = r12.charAt(r5)
            int r0 = r14.decodeBase64Char(r1)
            if (r0 >= 0) goto Lc6
            if (r0 == r9) goto Lbf
            r11._reportInvalidBase64(r14, r1, r10, r8)
        Lbf:
            int r2 = r2 >> 2
            r13.appendTwoBytes(r2)
            goto L8
        Lc6:
            int r6 = r2 << 6
            r2 = r6 | r0
            r13.appendThreeBytes(r2)
            goto L8
        Lcf:
            r4 = r5
            goto La
        */
        throw new UnsupportedOperationException("Method not decompiled: com.flurry.org.codehaus.jackson.impl.JsonParserMinimalBase._decodeBase64(java.lang.String, com.flurry.org.codehaus.jackson.util.ByteArrayBuilder, com.flurry.org.codehaus.jackson.Base64Variant):void");
    }

    protected void _reportInvalidBase64(Base64Variant b64variant, char ch, int bindex, String msg) throws JsonParseException {
        String base;
        if (ch <= ' ') {
            base = "Illegal white space character (code 0x" + Integer.toHexString(ch) + ") as character #" + (bindex + 1) + " of 4-char base64 unit: can only used between units";
        } else if (b64variant.usesPaddingChar(ch)) {
            base = "Unexpected padding character ('" + b64variant.getPaddingChar() + "') as character #" + (bindex + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character";
        } else if (!Character.isDefined(ch) || Character.isISOControl(ch)) {
            base = "Illegal character (code 0x" + Integer.toHexString(ch) + ") in base64 content";
        } else {
            base = "Illegal character '" + ch + "' (code 0x" + Integer.toHexString(ch) + ") in base64 content";
        }
        if (msg != null) {
            base = base + ": " + msg;
        }
        throw _constructError(base);
    }

    protected void _reportBase64EOF() throws JsonParseException {
        throw _constructError("Unexpected end-of-String in base64 content");
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void _reportUnexpectedChar(int ch, String comment) throws JsonParseException {
        String msg = "Unexpected character (" + _getCharDesc(ch) + ")";
        if (comment != null) {
            msg = msg + ": " + comment;
        }
        _reportError(msg);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void _reportInvalidEOF() throws JsonParseException {
        _reportInvalidEOF(" in " + this._currToken);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void _reportInvalidEOF(String msg) throws JsonParseException {
        _reportError("Unexpected end-of-input" + msg);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void _reportInvalidEOFInValue() throws JsonParseException {
        _reportInvalidEOF(" in a value");
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void _throwInvalidSpace(int i) throws JsonParseException {
        char c = (char) i;
        String msg = "Illegal character (" + _getCharDesc(c) + "): only regular white space (\\r, \\n, \\t) is allowed between tokens";
        _reportError(msg);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void _throwUnquotedSpace(int i, String ctxtDesc) throws JsonParseException {
        if (!isEnabled(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS) || i >= 32) {
            char c = (char) i;
            String msg = "Illegal unquoted character (" + _getCharDesc(c) + "): has to be escaped using backslash to be included in " + ctxtDesc;
            _reportError(msg);
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public char _handleUnrecognizedCharacterEscape(char ch) throws JsonProcessingException {
        if (!isEnabled(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER) && (ch != INT_APOSTROPHE || !isEnabled(JsonParser.Feature.ALLOW_SINGLE_QUOTES))) {
            _reportError("Unrecognized character escape " + _getCharDesc(ch));
        }
        return ch;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public static final String _getCharDesc(int ch) {
        char c = (char) ch;
        if (Character.isISOControl(c)) {
            return "(CTRL-CHAR, code " + ch + ")";
        }
        if (ch > 255) {
            return "'" + c + "' (code " + ch + " / 0x" + Integer.toHexString(ch) + ")";
        }
        return "'" + c + "' (code " + ch + ")";
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public final void _reportError(String msg) throws JsonParseException {
        throw _constructError(msg);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public final void _wrapError(String msg, Throwable t) throws JsonParseException {
        throw _constructError(msg, t);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public final void _throwInternal() {
        throw new RuntimeException("Internal error: this code path should never get executed");
    }

    protected final JsonParseException _constructError(String msg, Throwable t) {
        return new JsonParseException(msg, getCurrentLocation(), t);
    }
}
