package com.flurry.org.codehaus.jackson;

import java.io.IOException;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class JsonProcessingException extends IOException {
    static final long serialVersionUID = 123;
    protected JsonLocation mLocation;

    /* JADX INFO: Access modifiers changed from: protected */
    public JsonProcessingException(String msg, JsonLocation loc, Throwable rootCause) {
        super(msg);
        if (rootCause != null) {
            initCause(rootCause);
        }
        this.mLocation = loc;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public JsonProcessingException(String msg) {
        super(msg);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public JsonProcessingException(String msg, JsonLocation loc) {
        this(msg, loc, null);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public JsonProcessingException(String msg, Throwable rootCause) {
        this(msg, null, rootCause);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public JsonProcessingException(Throwable rootCause) {
        this(null, null, rootCause);
    }

    public JsonLocation getLocation() {
        return this.mLocation;
    }

    @Override // java.lang.Throwable
    public String getMessage() {
        String msg = super.getMessage();
        if (msg == null) {
            msg = "N/A";
        }
        JsonLocation loc = getLocation();
        if (loc != null) {
            return msg + "\n at " + loc.toString();
        }
        return msg;
    }

    @Override // java.lang.Throwable
    public String toString() {
        return getClass().getName() + ": " + getMessage();
    }
}
