package com.flurry.org.apache.avro.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class WeakIdentityHashMap<K, V> implements Map<K, V> {
    private final ReferenceQueue<K> queue = new ReferenceQueue<>();
    private Map<WeakIdentityHashMap<K, V>.IdentityWeakReference, V> backingStore = new HashMap();

    @Override // java.util.Map
    public void clear() {
        this.backingStore.clear();
        reap();
    }

    @Override // java.util.Map
    public boolean containsKey(Object key) {
        reap();
        return this.backingStore.containsKey(new IdentityWeakReference(key));
    }

    @Override // java.util.Map
    public boolean containsValue(Object value) {
        reap();
        return this.backingStore.containsValue(value);
    }

    @Override // java.util.Map
    public Set<Map.Entry<K, V>> entrySet() {
        reap();
        Set<Map.Entry<K, V>> ret = new HashSet<>();
        for (Map.Entry<WeakIdentityHashMap<K, V>.IdentityWeakReference, V> ref : this.backingStore.entrySet()) {
            final Object obj = ref.getKey().get();
            final V value = ref.getValue();
            Map.Entry<K, V> entry = new Map.Entry<K, V>() { // from class: com.flurry.org.apache.avro.util.WeakIdentityHashMap.1
                @Override // java.util.Map.Entry
                public K getKey() {
                    return (K) obj;
                }

                @Override // java.util.Map.Entry
                public V getValue() {
                    return (V) value;
                }

                @Override // java.util.Map.Entry
                public V setValue(V value2) {
                    throw new UnsupportedOperationException();
                }
            };
            ret.add(entry);
        }
        return Collections.unmodifiableSet(ret);
    }

    @Override // java.util.Map
    public Set<K> keySet() {
        reap();
        HashSet hashSet = new HashSet();
        for (WeakIdentityHashMap<K, V>.IdentityWeakReference ref : this.backingStore.keySet()) {
            hashSet.add(ref.get());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override // java.util.Map
    public boolean equals(Object o) {
        return this.backingStore.equals(((WeakIdentityHashMap) o).backingStore);
    }

    @Override // java.util.Map
    public V get(Object key) {
        reap();
        return this.backingStore.get(new IdentityWeakReference(key));
    }

    @Override // java.util.Map
    public V put(K key, V value) {
        reap();
        return this.backingStore.put(new IdentityWeakReference(key), value);
    }

    @Override // java.util.Map
    public int hashCode() {
        reap();
        return this.backingStore.hashCode();
    }

    @Override // java.util.Map
    public boolean isEmpty() {
        reap();
        return this.backingStore.isEmpty();
    }

    @Override // java.util.Map
    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    @Override // java.util.Map
    public V remove(Object key) {
        reap();
        return this.backingStore.remove(new IdentityWeakReference(key));
    }

    @Override // java.util.Map
    public int size() {
        reap();
        return this.backingStore.size();
    }

    @Override // java.util.Map
    public Collection<V> values() {
        reap();
        return this.backingStore.values();
    }

    private synchronized void reap() {
        Reference zombie = this.queue.poll();
        while (zombie != null) {
            WeakIdentityHashMap<K, V>.IdentityWeakReference victim = (IdentityWeakReference) zombie;
            this.backingStore.remove(victim);
            zombie = this.queue.poll();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public class IdentityWeakReference extends WeakReference<K> {
        int hash;

        IdentityWeakReference(Object obj) {
            super(obj, WeakIdentityHashMap.this.queue);
            this.hash = System.identityHashCode(obj);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            WeakIdentityHashMap<K, V>.IdentityWeakReference ref = (IdentityWeakReference) o;
            return get() == ref.get();
        }
    }
}
