package com.flurry.org.apache.avro.util;

import com.flurry.org.apache.avro.io.BinaryData;
import java.io.UnsupportedEncodingException;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class Utf8 implements Comparable<Utf8>, CharSequence {
    private static final byte[] EMPTY = new byte[0];
    private byte[] bytes;
    private int length;
    private String string;

    public Utf8() {
        this.bytes = EMPTY;
    }

    public Utf8(String string) {
        this.bytes = EMPTY;
        this.bytes = getBytesFor(string);
        this.length = this.bytes.length;
        this.string = string;
    }

    public Utf8(Utf8 other) {
        this.bytes = EMPTY;
        this.length = other.length;
        this.bytes = new byte[other.length];
        System.arraycopy(other.bytes, 0, this.bytes, 0, this.length);
        this.string = other.string;
    }

    public Utf8(byte[] bytes) {
        this.bytes = EMPTY;
        this.bytes = bytes;
        this.length = bytes.length;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getLength() {
        return this.length;
    }

    public int getByteLength() {
        return this.length;
    }

    public Utf8 setLength(int newLength) {
        return setByteLength(newLength);
    }

    public Utf8 setByteLength(int newLength) {
        if (this.length < newLength) {
            byte[] newBytes = new byte[newLength];
            System.arraycopy(this.bytes, 0, newBytes, 0, this.length);
            this.bytes = newBytes;
        }
        this.length = newLength;
        this.string = null;
        return this;
    }

    @Override // java.lang.CharSequence
    public String toString() {
        if (this.string == null) {
            try {
                this.string = new String(this.bytes, 0, this.length, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return this.string;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Utf8) {
            Utf8 that = (Utf8) o;
            if (this.length != that.length) {
                return false;
            }
            byte[] thatBytes = that.bytes;
            for (int i = 0; i < this.length; i++) {
                if (this.bytes[i] != thatBytes[i]) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.length; i++) {
            hash = (hash * 31) + this.bytes[i];
        }
        return hash;
    }

    @Override // java.lang.Comparable
    public int compareTo(Utf8 that) {
        return BinaryData.compareBytes(this.bytes, 0, this.length, that.bytes, 0, that.length);
    }

    @Override // java.lang.CharSequence
    public char charAt(int index) {
        return toString().charAt(index);
    }

    @Override // java.lang.CharSequence
    public int length() {
        return toString().length();
    }

    @Override // java.lang.CharSequence
    public CharSequence subSequence(int start, int end) {
        return toString().subSequence(start, end);
    }

    public static final byte[] getBytesFor(String str) {
        try {
            return str.getBytes("UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }
}
