package com.flurry.org.apache.avro.util;

import com.flurry.android.Constants;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class ByteBufferInputStream extends InputStream {
    private List<ByteBuffer> buffers;
    private int current;

    public ByteBufferInputStream(List<ByteBuffer> buffers) {
        this.buffers = buffers;
    }

    @Override // java.io.InputStream
    public int read() throws IOException {
        return getBuffer().get() & Constants.UNKNOWN;
    }

    @Override // java.io.InputStream
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        ByteBuffer buffer = getBuffer();
        int remaining = buffer.remaining();
        if (len > remaining) {
            buffer.get(b, off, remaining);
            return remaining;
        }
        buffer.get(b, off, len);
        return len;
    }

    public ByteBuffer readBuffer(int length) throws IOException {
        if (length == 0) {
            return ByteBuffer.allocate(0);
        }
        ByteBuffer buffer = getBuffer();
        if (buffer.remaining() == length) {
            this.current++;
            return buffer;
        }
        ByteBuffer result = ByteBuffer.allocate(length);
        int start = 0;
        while (start < length) {
            start += read(result.array(), start, length - start);
        }
        return result;
    }

    private ByteBuffer getBuffer() throws IOException {
        while (this.current < this.buffers.size()) {
            ByteBuffer buffer = this.buffers.get(this.current);
            if (buffer.hasRemaining()) {
                return buffer;
            }
            this.current++;
        }
        throw new EOFException();
    }
}
