package com.flurry.org.apache.avro.specific;

import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.data.ErrorBuilder;
import com.flurry.org.apache.avro.data.RecordBuilderBase;
import com.flurry.org.apache.avro.specific.SpecificExceptionBase;
import java.lang.reflect.Constructor;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public abstract class SpecificErrorBuilderBase<T extends SpecificExceptionBase> extends RecordBuilderBase<T> implements ErrorBuilder<T> {
    private Throwable cause;
    private Constructor<T> errorConstructor;
    private boolean hasCause;
    private boolean hasValue;
    private Object value;

    protected SpecificErrorBuilderBase(Schema schema) {
        super(schema, SpecificData.get());
    }

    protected SpecificErrorBuilderBase(SpecificErrorBuilderBase<T> other) {
        super(other, SpecificData.get());
        this.errorConstructor = other.errorConstructor;
        this.value = other.value;
        this.hasValue = other.hasValue;
        this.cause = other.cause;
        this.hasCause = other.hasCause;
    }

    protected SpecificErrorBuilderBase(T other) {
        super(other.getSchema(), SpecificData.get());
        Object otherValue = other.getValue();
        if (otherValue != null) {
            setValue(otherValue);
        }
        Throwable otherCause = other.getCause();
        if (otherCause != null) {
            setCause(otherCause);
        }
    }

    @Override // com.flurry.org.apache.avro.data.ErrorBuilder
    public Object getValue() {
        return this.value;
    }

    @Override // com.flurry.org.apache.avro.data.ErrorBuilder
    public SpecificErrorBuilderBase<T> setValue(Object value) {
        this.value = value;
        this.hasValue = true;
        return this;
    }

    @Override // com.flurry.org.apache.avro.data.ErrorBuilder
    public boolean hasValue() {
        return this.hasValue;
    }

    @Override // com.flurry.org.apache.avro.data.ErrorBuilder
    public SpecificErrorBuilderBase<T> clearValue() {
        this.value = null;
        this.hasValue = false;
        return this;
    }

    @Override // com.flurry.org.apache.avro.data.ErrorBuilder
    public Throwable getCause() {
        return this.cause;
    }

    @Override // com.flurry.org.apache.avro.data.ErrorBuilder
    public SpecificErrorBuilderBase<T> setCause(Throwable cause) {
        this.cause = cause;
        this.hasCause = true;
        return this;
    }

    @Override // com.flurry.org.apache.avro.data.ErrorBuilder
    public boolean hasCause() {
        return this.hasCause;
    }

    @Override // com.flurry.org.apache.avro.data.ErrorBuilder
    public SpecificErrorBuilderBase<T> clearCause() {
        this.cause = null;
        this.hasCause = false;
        return this;
    }
}
