package com.flurry.org.apache.avro.specific;

import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.generic.GenericDatumWriter;
import com.flurry.org.apache.avro.io.Encoder;
import java.io.IOException;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class SpecificDatumWriter<T> extends GenericDatumWriter<T> {
    public SpecificDatumWriter() {
        super(SpecificData.get());
    }

    public SpecificDatumWriter(Class<T> c) {
        super(SpecificData.get().getSchema(c), SpecificData.get());
    }

    public SpecificDatumWriter(Schema schema) {
        super(schema, SpecificData.get());
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public SpecificDatumWriter(Schema root, SpecificData specificData) {
        super(root, specificData);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public SpecificDatumWriter(SpecificData specificData) {
        super(specificData);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // com.flurry.org.apache.avro.generic.GenericDatumWriter
    public void writeEnum(Schema schema, Object datum, Encoder out) throws IOException {
        if (!(datum instanceof Enum)) {
            super.writeEnum(schema, datum, out);
        } else {
            out.writeEnum(((Enum) datum).ordinal());
        }
    }
}
