package com.flurry.org.apache.avro.specific;

import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.generic.GenericDatumReader;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class SpecificDatumReader<T> extends GenericDatumReader<T> {
    public SpecificDatumReader() {
        this(null, null, SpecificData.get());
    }

    public SpecificDatumReader(Class<T> c) {
        this(SpecificData.get().getSchema(c));
    }

    public SpecificDatumReader(Schema schema) {
        this(schema, schema, SpecificData.get());
    }

    public SpecificDatumReader(Schema writer, Schema reader) {
        this(writer, reader, SpecificData.get());
    }

    public SpecificDatumReader(Schema writer, Schema reader, SpecificData data) {
        super(writer, reader, data);
    }

    public SpecificData getSpecificData() {
        return (SpecificData) getData();
    }

    @Override // com.flurry.org.apache.avro.generic.GenericDatumReader, com.flurry.org.apache.avro.io.DatumReader
    public void setSchema(Schema actual) {
        SpecificData data;
        Class c;
        if (getExpected() == null && actual != null && actual.getType() == Schema.Type.RECORD && (c = (data = getSpecificData()).getClass(actual)) != null && SpecificRecord.class.isAssignableFrom(c)) {
            setExpected(data.getSchema(c));
        }
        super.setSchema(actual);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // com.flurry.org.apache.avro.generic.GenericDatumReader
    public Object createEnum(String symbol, Schema schema) {
        Class c = getSpecificData().getClass(schema);
        return c == null ? super.createEnum(symbol, schema) : Enum.valueOf(c, symbol);
    }
}
