package com.flurry.org.apache.avro.reflect;

import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.io.Encoder;
import com.flurry.org.apache.avro.specific.SpecificDatumWriter;
import com.flurry.org.codehaus.jackson.util.MinimalPrettyPrinter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class ReflectDatumWriter<T> extends SpecificDatumWriter<T> {
    public ReflectDatumWriter() {
        this(ReflectData.get());
    }

    public ReflectDatumWriter(Class<T> c) {
        this(c, ReflectData.get());
    }

    public ReflectDatumWriter(Class<T> c, ReflectData data) {
        this(data.getSchema(c), data);
    }

    public ReflectDatumWriter(Schema root) {
        this(root, ReflectData.get());
    }

    protected ReflectDatumWriter(Schema root, ReflectData reflectData) {
        super(root, reflectData);
    }

    protected ReflectDatumWriter(ReflectData reflectData) {
        super(reflectData);
    }

    @Override // com.flurry.org.apache.avro.generic.GenericDatumWriter
    protected long getArraySize(Object array) {
        return array instanceof Collection ? ((Collection) array).size() : Array.getLength(array);
    }

    @Override // com.flurry.org.apache.avro.generic.GenericDatumWriter
    protected Iterator<Object> getArrayElements(final Object array) {
        return array instanceof Collection ? ((Collection) array).iterator() : new Iterator<Object>() { // from class: com.flurry.org.apache.avro.reflect.ReflectDatumWriter.1
            private int i = 0;
            private final int length;

            {
                this.length = Array.getLength(array);
            }

            @Override // java.util.Iterator
            public boolean hasNext() {
                return this.i < this.length;
            }

            @Override // java.util.Iterator
            public Object next() {
                Object obj = array;
                int i = this.i;
                this.i = i + 1;
                return Array.get(obj, i);
            }

            @Override // java.util.Iterator
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override // com.flurry.org.apache.avro.generic.GenericDatumWriter
    protected void writeString(Schema schema, Object datum, Encoder out) throws IOException {
        if (schema.getProp("java-class") != null) {
            datum = datum.toString();
        }
        writeString(datum, out);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // com.flurry.org.apache.avro.generic.GenericDatumWriter
    public void writeBytes(Object datum, Encoder out) throws IOException {
        if (datum instanceof byte[]) {
            out.writeBytes((byte[]) datum);
        } else {
            super.writeBytes(datum, out);
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // com.flurry.org.apache.avro.generic.GenericDatumWriter
    public void write(Schema schema, Object datum, Encoder out) throws IOException {
        if (datum instanceof Byte) {
            datum = Integer.valueOf(((Byte) datum).intValue());
        } else if (datum instanceof Short) {
            datum = Integer.valueOf(((Short) datum).intValue());
        }
        try {
            super.write(schema, datum, out);
        } catch (NullPointerException e) {
            NullPointerException result = new NullPointerException("in " + schema.getFullName() + MinimalPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR + e.getMessage());
            Throwable cause = e.getCause();
            Throwable th = e;
            if (cause != null) {
                th = e.getCause();
            }
            result.initCause(th);
            throw result;
        }
    }
}
