package com.flurry.org.apache.avro.reflect;

import com.flurry.org.apache.avro.AvroRuntimeException;
import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.io.Decoder;
import com.flurry.org.apache.avro.specific.SpecificDatumReader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class ReflectDatumReader<T> extends SpecificDatumReader<T> {
    public ReflectDatumReader() {
        this(null, null, ReflectData.get());
    }

    public ReflectDatumReader(Class<T> c) {
        this(ReflectData.get().getSchema(c));
    }

    public ReflectDatumReader(Schema root) {
        this(root, root, ReflectData.get());
    }

    public ReflectDatumReader(Schema writer, Schema reader) {
        this(writer, reader, ReflectData.get());
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public ReflectDatumReader(Schema writer, Schema reader, ReflectData data) {
        super(writer, reader, data);
    }

    @Override // com.flurry.org.apache.avro.generic.GenericDatumReader
    protected Object newArray(Object old, int size, Schema schema) {
        ReflectData data = ReflectData.get();
        Class collectionClass = ReflectData.getClassProp(schema, "java-class");
        if (collectionClass != null) {
            if (old instanceof Collection) {
                ((Collection) old).clear();
                return old;
            } else if (collectionClass.isAssignableFrom(ArrayList.class)) {
                return new ArrayList();
            } else {
                return ReflectData.newInstance(collectionClass, schema);
            }
        }
        Class elementClass = ReflectData.getClassProp(schema, "java-element-class");
        if (elementClass == null) {
            elementClass = data.getClass(schema.getElementType());
        }
        return Array.newInstance(elementClass, size);
    }

    @Override // com.flurry.org.apache.avro.generic.GenericDatumReader
    protected Object peekArray(Object array) {
        return null;
    }

    @Override // com.flurry.org.apache.avro.generic.GenericDatumReader
    protected void addToArray(Object array, long pos, Object e) {
        if (array instanceof Collection) {
            ((Collection) array).add(e);
        } else {
            Array.set(array, (int) pos, e);
        }
    }

    @Override // com.flurry.org.apache.avro.generic.GenericDatumReader
    protected Object readString(Object old, Schema s, Decoder in) throws IOException {
        String value = (String) readString(null, in);
        Class c = ReflectData.getClassProp(s, "java-class");
        if (c != null) {
            try {
                return c.getConstructor(String.class).newInstance(value);
            } catch (IllegalAccessException e) {
                throw new AvroRuntimeException(e);
            } catch (InstantiationException e2) {
                throw new AvroRuntimeException(e2);
            } catch (NoSuchMethodException e3) {
                throw new AvroRuntimeException(e3);
            } catch (InvocationTargetException e4) {
                throw new AvroRuntimeException(e4);
            }
        }
        return value;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    @Override // com.flurry.org.apache.avro.generic.GenericDatumReader
    public Object readString(Object old, Decoder in) throws IOException {
        return super.readString(null, in).toString();
    }

    @Override // com.flurry.org.apache.avro.generic.GenericDatumReader
    protected Object createString(String value) {
        return value;
    }

    @Override // com.flurry.org.apache.avro.generic.GenericDatumReader
    protected Object readBytes(Object old, Decoder in) throws IOException {
        ByteBuffer bytes = in.readBytes(null);
        byte[] result = new byte[bytes.remaining()];
        bytes.get(result);
        return result;
    }

    @Override // com.flurry.org.apache.avro.generic.GenericDatumReader
    protected Object readInt(Object old, Schema expected, Decoder in) throws IOException {
        Integer value = Integer.valueOf(in.readInt());
        String intClass = expected.getProp("java-class");
        if (Byte.class.getName().equals(intClass)) {
            return Byte.valueOf(value.byteValue());
        }
        if (Short.class.getName().equals(intClass)) {
            return Short.valueOf(value.shortValue());
        }
        return value;
    }
}
