package com.flurry.org.apache.avro.io.parsing;

import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.io.parsing.Symbol;
import com.prime31.util.IabHelper;
import com.tapjoy.TapjoyVideoObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class ValidatingGrammarGenerator {
    public Symbol generate(Schema schema) {
        return Symbol.root(generate(schema, new HashMap()));
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* renamed from: com.flurry.org.apache.avro.io.parsing.ValidatingGrammarGenerator$1  reason: invalid class name */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public static /* synthetic */ class AnonymousClass1 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$avro$Schema$Type = new int[Schema.Type.values().length];

        static {
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.NULL.ordinal()] = 1;
            } catch (NoSuchFieldError e) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.BOOLEAN.ordinal()] = 2;
            } catch (NoSuchFieldError e2) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.INT.ordinal()] = 3;
            } catch (NoSuchFieldError e3) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.LONG.ordinal()] = 4;
            } catch (NoSuchFieldError e4) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.FLOAT.ordinal()] = 5;
            } catch (NoSuchFieldError e5) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.DOUBLE.ordinal()] = 6;
            } catch (NoSuchFieldError e6) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.STRING.ordinal()] = 7;
            } catch (NoSuchFieldError e7) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.BYTES.ordinal()] = 8;
            } catch (NoSuchFieldError e8) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.FIXED.ordinal()] = 9;
            } catch (NoSuchFieldError e9) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.ENUM.ordinal()] = 10;
            } catch (NoSuchFieldError e10) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.ARRAY.ordinal()] = 11;
            } catch (NoSuchFieldError e11) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.MAP.ordinal()] = 12;
            } catch (NoSuchFieldError e12) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.RECORD.ordinal()] = 13;
            } catch (NoSuchFieldError e13) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.UNION.ordinal()] = 14;
            } catch (NoSuchFieldError e14) {
            }
        }
    }

    public Symbol generate(Schema sc, Map<LitS, Symbol> seen) {
        switch (AnonymousClass1.$SwitchMap$org$apache$avro$Schema$Type[sc.getType().ordinal()]) {
            case 1:
                return Symbol.NULL;
            case 2:
                return Symbol.BOOLEAN;
            case 3:
                return Symbol.INT;
            case 4:
                return Symbol.LONG;
            case 5:
                return Symbol.FLOAT;
            case 6:
                return Symbol.DOUBLE;
            case IabHelper.BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED /* 7 */:
                return Symbol.STRING;
            case 8:
                return Symbol.BYTES;
            case 9:
                return Symbol.seq(new Symbol.IntCheckAction(sc.getFixedSize()), Symbol.FIXED);
            case TapjoyVideoObject.BUTTON_MAX /* 10 */:
                return Symbol.seq(new Symbol.IntCheckAction(sc.getEnumSymbols().size()), Symbol.ENUM);
            case 11:
                return Symbol.seq(Symbol.repeat(Symbol.ARRAY_END, generate(sc.getElementType(), seen)), Symbol.ARRAY_START);
            case 12:
                return Symbol.seq(Symbol.repeat(Symbol.MAP_END, generate(sc.getValueType(), seen), Symbol.STRING), Symbol.MAP_START);
            case 13:
                LitS wsc = new LitS(sc);
                Symbol rresult = seen.get(wsc);
                if (rresult == null) {
                    Symbol[] production = new Symbol[sc.getFields().size()];
                    Symbol rresult2 = Symbol.seq(production);
                    seen.put(wsc, rresult2);
                    int i = production.length;
                    for (Schema.Field f : sc.getFields()) {
                        i--;
                        production[i] = generate(f.schema(), seen);
                    }
                    return rresult2;
                }
                return rresult;
            case 14:
                List<Schema> subs = sc.getTypes();
                Symbol[] symbols = new Symbol[subs.size()];
                String[] labels = new String[subs.size()];
                int i2 = 0;
                for (Schema b : sc.getTypes()) {
                    symbols[i2] = generate(b, seen);
                    labels[i2] = b.getFullName();
                    i2++;
                }
                return Symbol.seq(Symbol.alt(symbols, labels), Symbol.UNION);
            default:
                throw new RuntimeException("Unexpected schema type");
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public static class LitS {
        public final Schema actual;

        public LitS(Schema actual) {
            this.actual = actual;
        }

        public boolean equals(Object o) {
            return (o instanceof LitS) && this.actual == ((LitS) o).actual;
        }

        public int hashCode() {
            return this.actual.hashCode();
        }
    }
}
