package com.flurry.org.apache.avro.io.parsing;

import com.flurry.org.apache.avro.io.parsing.Parser;
import com.flurry.org.apache.avro.io.parsing.Symbol;
import java.io.IOException;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class SkipParser extends Parser {
    static final /* synthetic */ boolean $assertionsDisabled;
    private final SkipHandler skipHandler;

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public interface SkipHandler {
        void skipAction() throws IOException;

        void skipTopSymbol() throws IOException;
    }

    static {
        $assertionsDisabled = !SkipParser.class.desiredAssertionStatus();
    }

    public SkipParser(Symbol root, Parser.ActionHandler symbolHandler, SkipHandler skipHandler) throws IOException {
        super(root, symbolHandler);
        this.skipHandler = skipHandler;
    }

    public final void skipTo(int target) throws IOException {
        while (target < this.pos) {
            Symbol top = this.stack[this.pos - 1];
            if (top.kind != Symbol.Kind.TERMINAL) {
                if (top.kind == Symbol.Kind.IMPLICIT_ACTION || top.kind == Symbol.Kind.EXPLICIT_ACTION) {
                    this.skipHandler.skipAction();
                } else {
                    this.pos--;
                    pushProduction(top);
                }
            } else {
                this.skipHandler.skipTopSymbol();
            }
        }
    }

    public final void skipRepeater() throws IOException {
        int target = this.pos;
        Symbol[] symbolArr = this.stack;
        int i = this.pos - 1;
        this.pos = i;
        Symbol repeater = symbolArr[i];
        if (!$assertionsDisabled && repeater.kind != Symbol.Kind.REPEATER) {
            throw new AssertionError();
        }
        pushProduction(repeater);
        skipTo(target);
    }

    public final void skipSymbol(Symbol symToSkip) throws IOException {
        int target = this.pos;
        pushSymbol(symToSkip);
        skipTo(target);
    }
}
