package com.flurry.org.apache.avro.io.parsing;

import com.flurry.org.apache.avro.AvroTypeException;
import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.io.Encoder;
import com.flurry.org.apache.avro.io.EncoderFactory;
import com.flurry.org.apache.avro.io.parsing.Symbol;
import com.flurry.org.apache.avro.io.parsing.ValidatingGrammarGenerator;
import com.flurry.org.codehaus.jackson.JsonNode;
import com.prime31.util.IabHelper;
import com.tapjoy.TapjoyVideoObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class ResolvingGrammarGenerator extends ValidatingGrammarGenerator {
    private static /* synthetic */ int[] $SWITCH_TABLE$org$apache$avro$Schema$Type;
    private static EncoderFactory factory = new EncoderFactory().configureBufferSize(32);

    static /* synthetic */ int[] $SWITCH_TABLE$org$apache$avro$Schema$Type() {
        int[] iArr = $SWITCH_TABLE$org$apache$avro$Schema$Type;
        if (iArr == null) {
            iArr = new int[Schema.Type.values().length];
            try {
                iArr[Schema.Type.ARRAY.ordinal()] = 3;
            } catch (NoSuchFieldError e) {
            }
            try {
                iArr[Schema.Type.BOOLEAN.ordinal()] = 13;
            } catch (NoSuchFieldError e2) {
            }
            try {
                iArr[Schema.Type.BYTES.ordinal()] = 8;
            } catch (NoSuchFieldError e3) {
            }
            try {
                iArr[Schema.Type.DOUBLE.ordinal()] = 12;
            } catch (NoSuchFieldError e4) {
            }
            try {
                iArr[Schema.Type.ENUM.ordinal()] = 2;
            } catch (NoSuchFieldError e5) {
            }
            try {
                iArr[Schema.Type.FIXED.ordinal()] = 6;
            } catch (NoSuchFieldError e6) {
            }
            try {
                iArr[Schema.Type.FLOAT.ordinal()] = 11;
            } catch (NoSuchFieldError e7) {
            }
            try {
                iArr[Schema.Type.INT.ordinal()] = 9;
            } catch (NoSuchFieldError e8) {
            }
            try {
                iArr[Schema.Type.LONG.ordinal()] = 10;
            } catch (NoSuchFieldError e9) {
            }
            try {
                iArr[Schema.Type.MAP.ordinal()] = 4;
            } catch (NoSuchFieldError e10) {
            }
            try {
                iArr[Schema.Type.NULL.ordinal()] = 14;
            } catch (NoSuchFieldError e11) {
            }
            try {
                iArr[Schema.Type.RECORD.ordinal()] = 1;
            } catch (NoSuchFieldError e12) {
            }
            try {
                iArr[Schema.Type.STRING.ordinal()] = 7;
            } catch (NoSuchFieldError e13) {
            }
            try {
                iArr[Schema.Type.UNION.ordinal()] = 5;
            } catch (NoSuchFieldError e14) {
            }
            $SWITCH_TABLE$org$apache$avro$Schema$Type = iArr;
        }
        return iArr;
    }

    public final Symbol generate(Schema writer, Schema reader) throws IOException {
        return Symbol.root(generate(writer, reader, new HashMap()));
    }

    public Symbol generate(Schema writer, Schema reader, Map<ValidatingGrammarGenerator.LitS, Symbol> seen) throws IOException {
        Schema.Type writerType = writer.getType();
        Schema.Type readerType = reader.getType();
        if (writerType == readerType) {
            switch ($SWITCH_TABLE$org$apache$avro$Schema$Type()[writerType.ordinal()]) {
                case 1:
                    return resolveRecords(writer, reader, seen);
                case 2:
                    if (writer.getFullName() == null || writer.getFullName().equals(reader.getFullName())) {
                        return Symbol.seq(mkEnumAdjust(writer.getEnumSymbols(), reader.getEnumSymbols()), Symbol.ENUM);
                    }
                    break;
                case 3:
                    return Symbol.seq(Symbol.repeat(Symbol.ARRAY_END, generate(writer.getElementType(), reader.getElementType(), seen)), Symbol.ARRAY_START);
                case 4:
                    return Symbol.seq(Symbol.repeat(Symbol.MAP_END, generate(writer.getValueType(), reader.getValueType(), seen), Symbol.STRING), Symbol.MAP_START);
                case 5:
                    return resolveUnion(writer, reader, seen);
                case 6:
                    if (writer.getFullName().equals(reader.getFullName()) && writer.getFixedSize() == reader.getFixedSize()) {
                        return Symbol.seq(new Symbol.IntCheckAction(writer.getFixedSize()), Symbol.FIXED);
                    }
                    break;
                case IabHelper.BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED /* 7 */:
                    return Symbol.STRING;
                case 8:
                    return Symbol.BYTES;
                case 9:
                    return Symbol.INT;
                case TapjoyVideoObject.BUTTON_MAX /* 10 */:
                    return Symbol.LONG;
                case 11:
                    return Symbol.FLOAT;
                case 12:
                    return Symbol.DOUBLE;
                case 13:
                    return Symbol.BOOLEAN;
                case 14:
                    return Symbol.NULL;
                default:
                    throw new AvroTypeException("Unkown type for schema: " + writerType);
            }
        } else if (writerType == Schema.Type.UNION) {
            return resolveUnion(writer, reader, seen);
        } else {
            switch ($SWITCH_TABLE$org$apache$avro$Schema$Type()[readerType.ordinal()]) {
                case 1:
                case 2:
                case 3:
                case 4:
                case IabHelper.BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED /* 7 */:
                case 8:
                case 9:
                case 13:
                case 14:
                    break;
                case 5:
                    int j = bestBranch(reader, writer);
                    if (j >= 0) {
                        Symbol s = generate(writer, reader.getTypes().get(j), seen);
                        return Symbol.seq(new Symbol.UnionAdjustAction(j, s), Symbol.UNION);
                    }
                    break;
                case 6:
                default:
                    throw new RuntimeException("Unexpected schema type: " + readerType);
                case TapjoyVideoObject.BUTTON_MAX /* 10 */:
                    switch ($SWITCH_TABLE$org$apache$avro$Schema$Type()[writerType.ordinal()]) {
                        case 9:
                            return Symbol.resolve(super.generate(writer, seen), Symbol.LONG);
                    }
                case 11:
                    switch ($SWITCH_TABLE$org$apache$avro$Schema$Type()[writerType.ordinal()]) {
                        case 9:
                        case TapjoyVideoObject.BUTTON_MAX /* 10 */:
                            return Symbol.resolve(super.generate(writer, seen), Symbol.FLOAT);
                    }
                case 12:
                    switch ($SWITCH_TABLE$org$apache$avro$Schema$Type()[writerType.ordinal()]) {
                        case 9:
                        case TapjoyVideoObject.BUTTON_MAX /* 10 */:
                        case 11:
                            return Symbol.resolve(super.generate(writer, seen), Symbol.DOUBLE);
                    }
            }
        }
        return Symbol.error("Found " + writer.toString(true) + ", expecting " + reader.toString(true));
    }

    /* renamed from: com.flurry.org.apache.avro.io.parsing.ResolvingGrammarGenerator$1  reason: invalid class name */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    static /* synthetic */ class AnonymousClass1 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$avro$Schema$Type = new int[Schema.Type.values().length];

        static {
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.NULL.ordinal()] = 1;
            } catch (NoSuchFieldError e) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.BOOLEAN.ordinal()] = 2;
            } catch (NoSuchFieldError e2) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.INT.ordinal()] = 3;
            } catch (NoSuchFieldError e3) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.LONG.ordinal()] = 4;
            } catch (NoSuchFieldError e4) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.FLOAT.ordinal()] = 5;
            } catch (NoSuchFieldError e5) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.DOUBLE.ordinal()] = 6;
            } catch (NoSuchFieldError e6) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.STRING.ordinal()] = 7;
            } catch (NoSuchFieldError e7) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.BYTES.ordinal()] = 8;
            } catch (NoSuchFieldError e8) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.FIXED.ordinal()] = 9;
            } catch (NoSuchFieldError e9) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.ENUM.ordinal()] = 10;
            } catch (NoSuchFieldError e10) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.ARRAY.ordinal()] = 11;
            } catch (NoSuchFieldError e11) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.MAP.ordinal()] = 12;
            } catch (NoSuchFieldError e12) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.RECORD.ordinal()] = 13;
            } catch (NoSuchFieldError e13) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.UNION.ordinal()] = 14;
            } catch (NoSuchFieldError e14) {
            }
        }
    }

    private Symbol resolveUnion(Schema writer, Schema reader, Map<ValidatingGrammarGenerator.LitS, Symbol> seen) throws IOException {
        List<Schema> alts = writer.getTypes();
        int size = alts.size();
        Symbol[] symbols = new Symbol[size];
        String[] labels = new String[size];
        int i = 0;
        for (Schema w : alts) {
            symbols[i] = generate(w, reader, seen);
            labels[i] = w.getFullName();
            i++;
        }
        return Symbol.seq(Symbol.alt(symbols, labels), new Symbol.WriterUnionAction());
    }

    private Symbol resolveRecords(Schema writer, Schema reader, Map<ValidatingGrammarGenerator.LitS, Symbol> seen) throws IOException {
        ValidatingGrammarGenerator.LitS wsc = new LitS2(writer, reader);
        Symbol result = seen.get(wsc);
        if (result == null) {
            List<Schema.Field> wfields = writer.getFields();
            List<Schema.Field> rfields = reader.getFields();
            Schema.Field[] reordered = new Schema.Field[rfields.size()];
            int ridx = 0;
            int count = wfields.size() + 1;
            for (Schema.Field f : wfields) {
                Schema.Field rdrField = reader.getField(f.name());
                if (rdrField != null) {
                    reordered[ridx] = rdrField;
                    ridx++;
                }
            }
            for (Schema.Field rf : rfields) {
                String fname = rf.name();
                if (writer.getField(fname) == null) {
                    if (rf.defaultValue() == null) {
                        Symbol result2 = Symbol.error("Found " + writer.toString(true) + ", expecting " + reader.toString(true));
                        seen.put(wsc, result2);
                        return result2;
                    }
                    reordered[ridx] = rf;
                    count += 3;
                    ridx++;
                }
            }
            Symbol[] production = new Symbol[count];
            int count2 = count - 1;
            production[count2] = new Symbol.FieldOrderAction(reordered);
            result = Symbol.seq(production);
            seen.put(wsc, result);
            for (Schema.Field wf : wfields) {
                String fname2 = wf.name();
                Schema.Field rf2 = reader.getField(fname2);
                if (rf2 == null) {
                    count2--;
                    production[count2] = new Symbol.SkipAction(generate(wf.schema(), wf.schema(), seen));
                } else {
                    count2--;
                    production[count2] = generate(wf.schema(), rf2.schema(), seen);
                }
            }
            for (Schema.Field rf3 : rfields) {
                String fname3 = rf3.name();
                if (writer.getField(fname3) == null) {
                    byte[] bb = getBinary(rf3.schema(), rf3.defaultValue());
                    int count3 = count2 - 1;
                    production[count3] = new Symbol.DefaultStartAction(bb);
                    int count4 = count3 - 1;
                    production[count4] = generate(rf3.schema(), rf3.schema(), seen);
                    count2 = count4 - 1;
                    production[count2] = Symbol.DEFAULT_END_ACTION;
                }
            }
        }
        return result;
    }

    private static byte[] getBinary(Schema s, JsonNode n) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Encoder e = factory.binaryEncoder(out, null);
        encode(e, s, n);
        e.flush();
        return out.toByteArray();
    }

    public static void encode(Encoder e, Schema s, JsonNode n) throws IOException {
        switch ($SWITCH_TABLE$org$apache$avro$Schema$Type()[s.getType().ordinal()]) {
            case 1:
                for (Schema.Field f : s.getFields()) {
                    String name = f.name();
                    JsonNode v = n.get(name);
                    if (v == null) {
                        v = f.defaultValue();
                    }
                    if (v == null) {
                        throw new AvroTypeException("No default value for: " + name);
                    }
                    encode(e, f.schema(), v);
                }
                return;
            case 2:
                e.writeEnum(s.getEnumOrdinal(n.getTextValue()));
                return;
            case 3:
                e.writeArrayStart();
                e.setItemCount(n.size());
                Schema i = s.getElementType();
                Iterator<JsonNode> it = n.iterator();
                while (it.hasNext()) {
                    JsonNode node = it.next();
                    e.startItem();
                    encode(e, i, node);
                }
                e.writeArrayEnd();
                return;
            case 4:
                e.writeMapStart();
                e.setItemCount(n.size());
                Schema v2 = s.getValueType();
                Iterator<String> it2 = n.getFieldNames();
                while (it2.hasNext()) {
                    e.startItem();
                    String key = it2.next();
                    e.writeString(key);
                    encode(e, v2, n.get(key));
                }
                e.writeMapEnd();
                return;
            case 5:
                e.writeIndex(0);
                encode(e, s.getTypes().get(0), n);
                return;
            case 6:
                if (!n.isTextual()) {
                    throw new AvroTypeException("Non-string default value for fixed: " + n);
                }
                byte[] bb = n.getTextValue().getBytes("ISO-8859-1");
                if (bb.length != s.getFixedSize()) {
                    byte[] newBb = new byte[s.getFixedSize()];
                    System.arraycopy(bb, 0, newBb, 0, s.getFixedSize() > bb.length ? bb.length : s.getFixedSize());
                    bb = newBb;
                }
                e.writeFixed(bb);
                return;
            case IabHelper.BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED /* 7 */:
                if (!n.isTextual()) {
                    throw new AvroTypeException("Non-string default value for string: " + n);
                }
                e.writeString(n.getTextValue());
                return;
            case 8:
                if (!n.isTextual()) {
                    throw new AvroTypeException("Non-string default value for bytes: " + n);
                }
                e.writeBytes(n.getTextValue().getBytes("ISO-8859-1"));
                return;
            case 9:
                if (!n.isNumber()) {
                    throw new AvroTypeException("Non-numeric default value for int: " + n);
                }
                e.writeInt(n.getIntValue());
                return;
            case TapjoyVideoObject.BUTTON_MAX /* 10 */:
                if (!n.isNumber()) {
                    throw new AvroTypeException("Non-numeric default value for long: " + n);
                }
                e.writeLong(n.getLongValue());
                return;
            case 11:
                if (!n.isNumber()) {
                    throw new AvroTypeException("Non-numeric default value for float: " + n);
                }
                e.writeFloat((float) n.getDoubleValue());
                return;
            case 12:
                if (!n.isNumber()) {
                    throw new AvroTypeException("Non-numeric default value for double: " + n);
                }
                e.writeDouble(n.getDoubleValue());
                return;
            case 13:
                if (!n.isBoolean()) {
                    throw new AvroTypeException("Non-boolean default for boolean: " + n);
                }
                e.writeBoolean(n.getBooleanValue());
                return;
            case 14:
                if (!n.isNull()) {
                    throw new AvroTypeException("Non-null default value for null type: " + n);
                }
                e.writeNull();
                return;
            default:
                return;
        }
    }

    private static Symbol mkEnumAdjust(List<String> wsymbols, List<String> rsymbols) {
        Object[] adjustments = new Object[wsymbols.size()];
        for (int i = 0; i < adjustments.length; i++) {
            int j = rsymbols.indexOf(wsymbols.get(i));
            adjustments[i] = j == -1 ? "No match for " + wsymbols.get(i) : new Integer(j);
        }
        return new Symbol.EnumAdjustAction(rsymbols.size(), adjustments);
    }

    private static int bestBranch(Schema r, Schema w) {
        Schema.Type vt = w.getType();
        int j = 0;
        for (Schema b : r.getTypes()) {
            if (vt == b.getType()) {
                if (vt != Schema.Type.RECORD && vt != Schema.Type.ENUM && vt != Schema.Type.FIXED) {
                    return j;
                }
                String vname = w.getFullName();
                String bname = b.getFullName();
                if ((vname != null && vname.equals(bname)) || (vname == bname && vt == Schema.Type.RECORD)) {
                    return j;
                }
            }
            j++;
        }
        int j2 = 0;
        for (Schema b2 : r.getTypes()) {
            switch ($SWITCH_TABLE$org$apache$avro$Schema$Type()[vt.ordinal()]) {
                case 9:
                    switch ($SWITCH_TABLE$org$apache$avro$Schema$Type()[b2.getType().ordinal()]) {
                        case TapjoyVideoObject.BUTTON_MAX /* 10 */:
                        case 12:
                            return j2;
                    }
                case TapjoyVideoObject.BUTTON_MAX /* 10 */:
                case 11:
                    switch ($SWITCH_TABLE$org$apache$avro$Schema$Type()[b2.getType().ordinal()]) {
                        case 12:
                            return j2;
                    }
            }
            j2++;
        }
        return -1;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public static class LitS2 extends ValidatingGrammarGenerator.LitS {
        public Schema expected;

        public LitS2(Schema actual, Schema expected) {
            super(actual);
            this.expected = expected;
        }

        @Override // com.flurry.org.apache.avro.io.parsing.ValidatingGrammarGenerator.LitS
        public boolean equals(Object o) {
            if (o instanceof LitS2) {
                LitS2 other = (LitS2) o;
                return this.actual == other.actual && this.expected == other.expected;
            }
            return false;
        }

        @Override // com.flurry.org.apache.avro.io.parsing.ValidatingGrammarGenerator.LitS
        public int hashCode() {
            return super.hashCode() + this.expected.hashCode();
        }
    }
}
