package com.flurry.org.apache.avro.io.parsing;

import com.flurry.org.apache.avro.AvroTypeException;
import com.flurry.org.apache.avro.io.parsing.Symbol;
import java.io.IOException;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class Parser {
    protected int pos;
    protected Symbol[] stack = new Symbol[5];
    protected final ActionHandler symbolHandler;

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public interface ActionHandler {
        Symbol doAction(Symbol symbol, Symbol symbol2) throws IOException;
    }

    public Parser(Symbol root, ActionHandler symbolHandler) throws IOException {
        this.symbolHandler = symbolHandler;
        this.stack[0] = root;
        this.pos = 1;
    }

    private void expandStack() {
        Symbol[] newStack = new Symbol[this.stack.length + Math.max(this.stack.length, 1024)];
        System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
        this.stack = newStack;
    }

    public final Symbol advance(Symbol input) throws IOException {
        while (true) {
            Symbol[] symbolArr = this.stack;
            int i = this.pos - 1;
            this.pos = i;
            Symbol top = symbolArr[i];
            if (top != input) {
                Symbol.Kind k = top.kind;
                if (k == Symbol.Kind.IMPLICIT_ACTION) {
                    Symbol result = this.symbolHandler.doAction(input, top);
                    if (result != null) {
                        return result;
                    }
                } else if (k == Symbol.Kind.TERMINAL) {
                    throw new AvroTypeException("Attempt to process a " + input + " when a " + top + " was expected.");
                } else {
                    if (k == Symbol.Kind.REPEATER && input == ((Symbol.Repeater) top).end) {
                        return input;
                    }
                    pushProduction(top);
                }
            } else {
                return top;
            }
        }
    }

    public final void processImplicitActions() throws IOException {
        while (this.pos > 1) {
            Symbol top = this.stack[this.pos - 1];
            if (top.kind == Symbol.Kind.IMPLICIT_ACTION) {
                this.pos--;
                this.symbolHandler.doAction(null, top);
            } else if (top.kind != Symbol.Kind.TERMINAL) {
                this.pos--;
                pushProduction(top);
            } else {
                return;
            }
        }
    }

    public final void processTrailingImplicitActions() throws IOException {
        while (this.pos >= 1) {
            Symbol top = this.stack[this.pos - 1];
            if (top.kind == Symbol.Kind.IMPLICIT_ACTION && ((Symbol.ImplicitAction) top).isTrailing) {
                this.pos--;
                this.symbolHandler.doAction(null, top);
            } else {
                return;
            }
        }
    }

    public final void pushProduction(Symbol sym) {
        Symbol[] p = sym.production;
        while (this.pos + p.length > this.stack.length) {
            expandStack();
        }
        System.arraycopy(p, 0, this.stack, this.pos, p.length);
        this.pos += p.length;
    }

    public Symbol popSymbol() {
        Symbol[] symbolArr = this.stack;
        int i = this.pos - 1;
        this.pos = i;
        return symbolArr[i];
    }

    public Symbol topSymbol() {
        return this.stack[this.pos - 1];
    }

    public void pushSymbol(Symbol sym) {
        if (this.pos == this.stack.length) {
            expandStack();
        }
        Symbol[] symbolArr = this.stack;
        int i = this.pos;
        this.pos = i + 1;
        symbolArr[i] = sym;
    }

    public int depth() {
        return this.pos;
    }

    public void reset() {
        this.pos = 1;
    }
}
