package com.flurry.org.apache.avro.io.parsing;

import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.io.parsing.Symbol;
import com.flurry.org.apache.avro.io.parsing.ValidatingGrammarGenerator;
import com.prime31.util.IabHelper;
import com.tapjoy.TapjoyVideoObject;
import java.util.HashMap;
import java.util.Map;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class JsonGrammarGenerator extends ValidatingGrammarGenerator {
    @Override // com.flurry.org.apache.avro.io.parsing.ValidatingGrammarGenerator
    public Symbol generate(Schema schema) {
        return Symbol.root(generate(schema, new HashMap()));
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* renamed from: com.flurry.org.apache.avro.io.parsing.JsonGrammarGenerator$1  reason: invalid class name */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public static /* synthetic */ class AnonymousClass1 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$avro$Schema$Type = new int[Schema.Type.values().length];

        static {
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.NULL.ordinal()] = 1;
            } catch (NoSuchFieldError e) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.BOOLEAN.ordinal()] = 2;
            } catch (NoSuchFieldError e2) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.INT.ordinal()] = 3;
            } catch (NoSuchFieldError e3) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.LONG.ordinal()] = 4;
            } catch (NoSuchFieldError e4) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.FLOAT.ordinal()] = 5;
            } catch (NoSuchFieldError e5) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.DOUBLE.ordinal()] = 6;
            } catch (NoSuchFieldError e6) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.STRING.ordinal()] = 7;
            } catch (NoSuchFieldError e7) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.BYTES.ordinal()] = 8;
            } catch (NoSuchFieldError e8) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.FIXED.ordinal()] = 9;
            } catch (NoSuchFieldError e9) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.UNION.ordinal()] = 10;
            } catch (NoSuchFieldError e10) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.ENUM.ordinal()] = 11;
            } catch (NoSuchFieldError e11) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.ARRAY.ordinal()] = 12;
            } catch (NoSuchFieldError e12) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.MAP.ordinal()] = 13;
            } catch (NoSuchFieldError e13) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.RECORD.ordinal()] = 14;
            } catch (NoSuchFieldError e14) {
            }
        }
    }

    @Override // com.flurry.org.apache.avro.io.parsing.ValidatingGrammarGenerator
    public Symbol generate(Schema sc, Map<ValidatingGrammarGenerator.LitS, Symbol> seen) {
        switch (AnonymousClass1.$SwitchMap$org$apache$avro$Schema$Type[sc.getType().ordinal()]) {
            case 1:
            case 2:
            case 3:
            case 4:
            case 5:
            case 6:
            case IabHelper.BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED /* 7 */:
            case 8:
            case 9:
            case TapjoyVideoObject.BUTTON_MAX /* 10 */:
                return super.generate(sc, seen);
            case 11:
                return Symbol.seq(new Symbol.EnumLabelsAction(sc.getEnumSymbols()), Symbol.ENUM);
            case 12:
                return Symbol.seq(Symbol.repeat(Symbol.ARRAY_END, Symbol.ITEM_END, generate(sc.getElementType(), seen)), Symbol.ARRAY_START);
            case 13:
                return Symbol.seq(Symbol.repeat(Symbol.MAP_END, Symbol.ITEM_END, generate(sc.getValueType(), seen), Symbol.MAP_KEY_MARKER, Symbol.STRING), Symbol.MAP_START);
            case 14:
                ValidatingGrammarGenerator.LitS wsc = new ValidatingGrammarGenerator.LitS(sc);
                Symbol rresult = seen.get(wsc);
                if (rresult == null) {
                    Symbol[] production = new Symbol[(sc.getFields().size() * 3) + 2];
                    Symbol rresult2 = Symbol.seq(production);
                    seen.put(wsc, rresult2);
                    int n = 0;
                    int i = production.length - 1;
                    production[i] = Symbol.RECORD_START;
                    for (Schema.Field f : sc.getFields()) {
                        int i2 = i - 1;
                        production[i2] = new Symbol.FieldAdjustAction(n, f.name());
                        int i3 = i2 - 1;
                        production[i3] = generate(f.schema(), seen);
                        i = i3 - 1;
                        production[i] = Symbol.FIELD_END;
                        n++;
                    }
                    production[i - 1] = Symbol.RECORD_END;
                    return rresult2;
                }
                return rresult;
            default:
                throw new RuntimeException("Unexpected schema type");
        }
    }
}
