package com.flurry.org.apache.avro.io;

import com.flurry.org.apache.avro.AvroTypeException;
import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.io.parsing.ResolvingGrammarGenerator;
import com.flurry.org.apache.avro.io.parsing.Symbol;
import java.io.IOException;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class ResolvingDecoder extends ValidatingDecoder {
    static final /* synthetic */ boolean $assertionsDisabled;
    private Decoder backup;

    static {
        $assertionsDisabled = !ResolvingDecoder.class.desiredAssertionStatus();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public ResolvingDecoder(Schema writer, Schema reader, Decoder in) throws IOException {
        this(resolve(writer, reader), in);
    }

    private ResolvingDecoder(Object resolver, Decoder in) throws IOException {
        super((Symbol) resolver, in);
    }

    public static Object resolve(Schema writer, Schema reader) throws IOException {
        if (writer == null) {
            throw new NullPointerException("writer cannot be null!");
        }
        if (reader == null) {
            throw new NullPointerException("reader cannot be null!");
        }
        return new ResolvingGrammarGenerator().generate(writer, reader);
    }

    public final Schema.Field[] readFieldOrder() throws IOException {
        return ((Symbol.FieldOrderAction) this.parser.advance(Symbol.FIELD_ACTION)).fields;
    }

    public final void drain() throws IOException {
        this.parser.processImplicitActions();
    }

    @Override // com.flurry.org.apache.avro.io.ValidatingDecoder, com.flurry.org.apache.avro.io.Decoder
    public long readLong() throws IOException {
        Symbol actual = this.parser.advance(Symbol.LONG);
        if (actual == Symbol.INT) {
            return this.in.readInt();
        }
        if (actual == Symbol.DOUBLE) {
            return (long) this.in.readDouble();
        }
        if ($assertionsDisabled || actual == Symbol.LONG) {
            return this.in.readLong();
        }
        throw new AssertionError();
    }

    @Override // com.flurry.org.apache.avro.io.ValidatingDecoder, com.flurry.org.apache.avro.io.Decoder
    public float readFloat() throws IOException {
        Symbol actual = this.parser.advance(Symbol.FLOAT);
        if (actual == Symbol.INT) {
            return this.in.readInt();
        }
        if (actual == Symbol.LONG) {
            return (float) this.in.readLong();
        }
        if ($assertionsDisabled || actual == Symbol.FLOAT) {
            return this.in.readFloat();
        }
        throw new AssertionError();
    }

    @Override // com.flurry.org.apache.avro.io.ValidatingDecoder, com.flurry.org.apache.avro.io.Decoder
    public double readDouble() throws IOException {
        Symbol actual = this.parser.advance(Symbol.DOUBLE);
        if (actual == Symbol.INT) {
            return this.in.readInt();
        }
        if (actual == Symbol.LONG) {
            return this.in.readLong();
        }
        if (actual == Symbol.FLOAT) {
            return this.in.readFloat();
        }
        if ($assertionsDisabled || actual == Symbol.DOUBLE) {
            return this.in.readDouble();
        }
        throw new AssertionError();
    }

    @Override // com.flurry.org.apache.avro.io.ValidatingDecoder, com.flurry.org.apache.avro.io.Decoder
    public int readEnum() throws IOException {
        this.parser.advance(Symbol.ENUM);
        Symbol.EnumAdjustAction top = (Symbol.EnumAdjustAction) this.parser.popSymbol();
        int n = this.in.readEnum();
        Object o = top.adjustments[n];
        if (o instanceof Integer) {
            return ((Integer) o).intValue();
        }
        throw new AvroTypeException((String) o);
    }

    @Override // com.flurry.org.apache.avro.io.ValidatingDecoder, com.flurry.org.apache.avro.io.Decoder
    public int readIndex() throws IOException {
        this.parser.advance(Symbol.UNION);
        Symbol.UnionAdjustAction top = (Symbol.UnionAdjustAction) this.parser.popSymbol();
        this.parser.pushSymbol(top.symToParse);
        return top.rindex;
    }

    @Override // com.flurry.org.apache.avro.io.ValidatingDecoder, com.flurry.org.apache.avro.io.parsing.Parser.ActionHandler
    public Symbol doAction(Symbol input, Symbol top) throws IOException {
        if (top instanceof Symbol.FieldOrderAction) {
            if (input == Symbol.FIELD_ACTION) {
                return top;
            }
            return null;
        } else if (top instanceof Symbol.ResolvingAction) {
            Symbol.ResolvingAction t = (Symbol.ResolvingAction) top;
            if (t.reader != input) {
                throw new AvroTypeException("Found " + t.reader + " while looking for " + input);
            }
            return t.writer;
        } else {
            if (top instanceof Symbol.SkipAction) {
                Symbol symToSkip = ((Symbol.SkipAction) top).symToSkip;
                this.parser.skipSymbol(symToSkip);
            } else if (top instanceof Symbol.WriterUnionAction) {
                Symbol.Alternative branches = (Symbol.Alternative) this.parser.popSymbol();
                this.parser.pushSymbol(branches.getSymbol(this.in.readIndex()));
            } else if (top instanceof Symbol.ErrorAction) {
                throw new AvroTypeException(((Symbol.ErrorAction) top).msg);
            } else {
                if (top instanceof Symbol.DefaultStartAction) {
                    Symbol.DefaultStartAction dsa = (Symbol.DefaultStartAction) top;
                    this.backup = this.in;
                    this.in = DecoderFactory.get().binaryDecoder(dsa.contents, (BinaryDecoder) null);
                } else if (top == Symbol.DEFAULT_END_ACTION) {
                    this.in = this.backup;
                } else {
                    throw new AvroTypeException("Unknown action: " + top);
                }
            }
            return null;
        }
    }

    @Override // com.flurry.org.apache.avro.io.ParsingDecoder, com.flurry.org.apache.avro.io.parsing.SkipParser.SkipHandler
    public void skipAction() throws IOException {
        Symbol top = this.parser.popSymbol();
        if (top instanceof Symbol.ResolvingAction) {
            this.parser.pushSymbol(((Symbol.ResolvingAction) top).writer);
        } else if (top instanceof Symbol.SkipAction) {
            this.parser.pushSymbol(((Symbol.SkipAction) top).symToSkip);
        } else if (top instanceof Symbol.WriterUnionAction) {
            Symbol.Alternative branches = (Symbol.Alternative) this.parser.popSymbol();
            this.parser.pushSymbol(branches.getSymbol(this.in.readIndex()));
        } else if (top instanceof Symbol.ErrorAction) {
            throw new AvroTypeException(((Symbol.ErrorAction) top).msg);
        } else {
            if (top instanceof Symbol.DefaultStartAction) {
                Symbol.DefaultStartAction dsa = (Symbol.DefaultStartAction) top;
                this.backup = this.in;
                this.in = DecoderFactory.get().binaryDecoder(dsa.contents, (BinaryDecoder) null);
            } else if (top == Symbol.DEFAULT_END_ACTION) {
                this.in = this.backup;
            }
        }
    }
}
