package com.flurry.org.apache.avro.io;

import com.flurry.org.apache.avro.AvroTypeException;
import java.io.IOException;
import java.util.Arrays;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public abstract class ParsingEncoder extends Encoder {
    private long[] counts = new long[10];
    protected int pos = -1;

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void setItemCount(long itemCount) throws IOException {
        if (this.counts[this.pos] != 0) {
            throw new AvroTypeException("Incorrect number of items written. " + this.counts[this.pos] + " more required.");
        }
        this.counts[this.pos] = itemCount;
    }

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void startItem() throws IOException {
        long[] jArr = this.counts;
        int i = this.pos;
        jArr[i] = jArr[i] - 1;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public final void push() {
        if (this.pos == this.counts.length) {
            this.counts = Arrays.copyOf(this.counts, this.pos + 10);
        }
        long[] jArr = this.counts;
        int i = this.pos + 1;
        this.pos = i;
        jArr[i] = 0;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public final void pop() {
        if (this.counts[this.pos] != 0) {
            throw new AvroTypeException("Incorrect number of items written. " + this.counts[this.pos] + " more required.");
        }
        this.pos--;
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public final int depth() {
        return this.pos;
    }
}
