package com.flurry.org.apache.avro.io;

import com.flurry.org.apache.avro.io.parsing.Parser;
import com.flurry.org.apache.avro.io.parsing.SkipParser;
import com.flurry.org.apache.avro.io.parsing.Symbol;
import java.io.IOException;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public abstract class ParsingDecoder extends Decoder implements Parser.ActionHandler, SkipParser.SkipHandler {
    protected final SkipParser parser;

    protected abstract void skipFixed() throws IOException;

    /* JADX INFO: Access modifiers changed from: protected */
    public ParsingDecoder(Symbol root) throws IOException {
        this.parser = new SkipParser(root, this, this);
    }

    @Override // com.flurry.org.apache.avro.io.parsing.SkipParser.SkipHandler
    public void skipAction() throws IOException {
        this.parser.popSymbol();
    }

    @Override // com.flurry.org.apache.avro.io.parsing.SkipParser.SkipHandler
    public void skipTopSymbol() throws IOException {
        Symbol top = this.parser.topSymbol();
        if (top == Symbol.NULL) {
            readNull();
        }
        if (top == Symbol.BOOLEAN) {
            readBoolean();
        } else if (top == Symbol.INT) {
            readInt();
        } else if (top == Symbol.LONG) {
            readLong();
        } else if (top == Symbol.FLOAT) {
            readFloat();
        } else if (top == Symbol.DOUBLE) {
            readDouble();
        } else if (top == Symbol.STRING) {
            skipString();
        } else if (top == Symbol.BYTES) {
            skipBytes();
        } else if (top == Symbol.ENUM) {
            readEnum();
        } else if (top == Symbol.FIXED) {
            skipFixed();
        } else if (top == Symbol.UNION) {
            readIndex();
        } else if (top == Symbol.ARRAY_START) {
            skipArray();
        } else if (top == Symbol.MAP_START) {
            skipMap();
        }
    }
}
