package com.flurry.org.apache.avro.io;

import com.flurry.org.apache.avro.AvroRuntimeException;
import com.flurry.org.apache.avro.Schema;
import com.flurry.org.codehaus.jackson.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class EncoderFactory {
    private static final int DEFAULT_BLOCK_BUFFER_SIZE = 65536;
    private static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final EncoderFactory DEFAULT_FACTORY = new DefaultEncoderFactory();
    private static final int MAX_BLOCK_BUFFER_SIZE = 1073741824;
    private static final int MIN_BLOCK_BUFFER_SIZE = 64;
    protected int binaryBufferSize = DEFAULT_BUFFER_SIZE;
    protected int binaryBlockSize = DEFAULT_BLOCK_BUFFER_SIZE;

    public static EncoderFactory get() {
        return DEFAULT_FACTORY;
    }

    public EncoderFactory configureBufferSize(int size) {
        if (size < 32) {
            size = 32;
        }
        if (size > 16777216) {
            size = 16777216;
        }
        this.binaryBufferSize = size;
        return this;
    }

    public int getBufferSize() {
        return this.binaryBufferSize;
    }

    public EncoderFactory configureBlockSize(int size) {
        if (size < 64) {
            size = 64;
        }
        if (size > MAX_BLOCK_BUFFER_SIZE) {
            size = MAX_BLOCK_BUFFER_SIZE;
        }
        this.binaryBufferSize = size;
        return this;
    }

    public int getBlockSize() {
        return this.binaryBlockSize;
    }

    public BinaryEncoder binaryEncoder(OutputStream out, BinaryEncoder reuse) {
        return (reuse == null || !reuse.getClass().equals(BufferedBinaryEncoder.class)) ? new BufferedBinaryEncoder(out, this.binaryBufferSize) : ((BufferedBinaryEncoder) reuse).configure(out, this.binaryBufferSize);
    }

    public BinaryEncoder directBinaryEncoder(OutputStream out, BinaryEncoder reuse) {
        return (reuse == null || !reuse.getClass().equals(DirectBinaryEncoder.class)) ? new DirectBinaryEncoder(out) : ((DirectBinaryEncoder) reuse).configure(out);
    }

    public BinaryEncoder blockingBinaryEncoder(OutputStream out, BinaryEncoder reuse) {
        return (reuse == null || !reuse.getClass().equals(BlockingBinaryEncoder.class)) ? new BlockingBinaryEncoder(out, this.binaryBlockSize, 32) : ((BlockingBinaryEncoder) reuse).configure(out, this.binaryBlockSize, 32);
    }

    public JsonEncoder jsonEncoder(Schema schema, OutputStream out) throws IOException {
        return new JsonEncoder(schema, out);
    }

    public JsonEncoder jsonEncoder(Schema schema, JsonGenerator gen) throws IOException {
        return new JsonEncoder(schema, gen);
    }

    public ValidatingEncoder validatingEncoder(Schema schema, Encoder encoder) throws IOException {
        return new ValidatingEncoder(schema, encoder);
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    private static class DefaultEncoderFactory extends EncoderFactory {
        private DefaultEncoderFactory() {
        }

        @Override // com.flurry.org.apache.avro.io.EncoderFactory
        public EncoderFactory configureBlockSize(int size) {
            throw new AvroRuntimeException("Default EncoderFactory cannot be configured");
        }

        @Override // com.flurry.org.apache.avro.io.EncoderFactory
        public EncoderFactory configureBufferSize(int size) {
            throw new AvroRuntimeException("Default EncoderFactory cannot be configured");
        }
    }
}
