package com.flurry.org.apache.avro.io;

import com.flurry.org.apache.avro.util.Utf8;
import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public abstract class Encoder implements Flushable {
    public abstract void setItemCount(long j) throws IOException;

    public abstract void startItem() throws IOException;

    public abstract void writeArrayEnd() throws IOException;

    public abstract void writeArrayStart() throws IOException;

    public abstract void writeBoolean(boolean z) throws IOException;

    public abstract void writeBytes(ByteBuffer byteBuffer) throws IOException;

    public abstract void writeBytes(byte[] bArr, int i, int i2) throws IOException;

    public abstract void writeDouble(double d) throws IOException;

    public abstract void writeEnum(int i) throws IOException;

    public abstract void writeFixed(byte[] bArr, int i, int i2) throws IOException;

    public abstract void writeFloat(float f) throws IOException;

    public abstract void writeIndex(int i) throws IOException;

    public abstract void writeInt(int i) throws IOException;

    public abstract void writeLong(long j) throws IOException;

    public abstract void writeMapEnd() throws IOException;

    public abstract void writeMapStart() throws IOException;

    public abstract void writeNull() throws IOException;

    public abstract void writeString(Utf8 utf8) throws IOException;

    public void writeString(String str) throws IOException {
        writeString(new Utf8(str));
    }

    public void writeString(CharSequence charSequence) throws IOException {
        if (charSequence instanceof Utf8) {
            writeString((Utf8) charSequence);
        } else {
            writeString(charSequence.toString());
        }
    }

    public void writeBytes(byte[] bytes) throws IOException {
        writeBytes(bytes, 0, bytes.length);
    }

    public void writeFixed(byte[] bytes) throws IOException {
        writeFixed(bytes, 0, bytes.length);
    }
}
