package com.flurry.org.apache.avro.io;

import java.io.IOException;
import java.io.OutputStream;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class DirectBinaryEncoder extends BinaryEncoder {
    private final byte[] buf = new byte[12];
    private OutputStream out;

    /* JADX INFO: Access modifiers changed from: package-private */
    public DirectBinaryEncoder(OutputStream out) {
        configure(out);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public DirectBinaryEncoder configure(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("OutputStream cannot be null!");
        }
        this.out = out;
        return this;
    }

    @Override // java.io.Flushable
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void writeBoolean(boolean b) throws IOException {
        this.out.write(b ? 1 : 0);
    }

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void writeInt(int n) throws IOException {
        int val = (n << 1) ^ (n >> 31);
        if ((val & (-128)) == 0) {
            this.out.write(val);
        } else if ((val & (-16384)) == 0) {
            this.out.write(val | 128);
            this.out.write(val >>> 7);
        } else {
            int len = BinaryData.encodeInt(n, this.buf, 0);
            this.out.write(this.buf, 0, len);
        }
    }

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void writeLong(long n) throws IOException {
        long val = (n << 1) ^ (n >> 63);
        if (((-2147483648L) & val) == 0) {
            int i = (int) val;
            while ((i & (-128)) != 0) {
                this.out.write((byte) ((i | 128) & 255));
                i >>>= 7;
            }
            this.out.write((byte) i);
            return;
        }
        int len = BinaryData.encodeLong(n, this.buf, 0);
        this.out.write(this.buf, 0, len);
    }

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void writeFloat(float f) throws IOException {
        int len = BinaryData.encodeFloat(f, this.buf, 0);
        this.out.write(this.buf, 0, len);
    }

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void writeDouble(double d) throws IOException {
        byte[] buf = new byte[8];
        int len = BinaryData.encodeDouble(d, buf, 0);
        this.out.write(buf, 0, len);
    }

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void writeFixed(byte[] bytes, int start, int len) throws IOException {
        this.out.write(bytes, start, len);
    }

    @Override // com.flurry.org.apache.avro.io.BinaryEncoder
    protected void writeZero() throws IOException {
        this.out.write(0);
    }

    @Override // com.flurry.org.apache.avro.io.BinaryEncoder
    public int bytesBuffered() {
        return 0;
    }
}
