package com.flurry.org.apache.avro.io;

import com.flurry.org.apache.avro.Schema;
import java.io.IOException;
import java.io.InputStream;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class DecoderFactory {
    static final int DEFAULT_BUFFER_SIZE = 8192;
    private static final DecoderFactory DEFAULT_FACTORY = new DefaultDecoderFactory();
    int binaryDecoderBufferSize = 8192;

    @Deprecated
    public static DecoderFactory defaultFactory() {
        return get();
    }

    public static DecoderFactory get() {
        return DEFAULT_FACTORY;
    }

    public DecoderFactory configureDecoderBufferSize(int size) {
        if (size < 32) {
            size = 32;
        }
        if (size > 16777216) {
            size = 16777216;
        }
        this.binaryDecoderBufferSize = size;
        return this;
    }

    public int getConfiguredBufferSize() {
        return this.binaryDecoderBufferSize;
    }

    @Deprecated
    public BinaryDecoder createBinaryDecoder(InputStream in, BinaryDecoder reuse) {
        return binaryDecoder(in, reuse);
    }

    public BinaryDecoder binaryDecoder(InputStream in, BinaryDecoder reuse) {
        return (reuse == null || !reuse.getClass().equals(BinaryDecoder.class)) ? new BinaryDecoder(in, this.binaryDecoderBufferSize) : reuse.configure(in, this.binaryDecoderBufferSize);
    }

    public BinaryDecoder directBinaryDecoder(InputStream in, BinaryDecoder reuse) {
        return (reuse == null || !reuse.getClass().equals(DirectBinaryDecoder.class)) ? new DirectBinaryDecoder(in) : ((DirectBinaryDecoder) reuse).configure(in);
    }

    @Deprecated
    public BinaryDecoder createBinaryDecoder(byte[] bytes, int offset, int length, BinaryDecoder reuse) {
        return (reuse == null || !reuse.getClass().equals(BinaryDecoder.class)) ? new BinaryDecoder(bytes, offset, length) : reuse.configure(bytes, offset, length);
    }

    public BinaryDecoder binaryDecoder(byte[] bytes, int offset, int length, BinaryDecoder reuse) {
        return (reuse == null || !reuse.getClass().equals(BinaryDecoder.class)) ? new BinaryDecoder(bytes, offset, length) : reuse.configure(bytes, offset, length);
    }

    @Deprecated
    public BinaryDecoder createBinaryDecoder(byte[] bytes, BinaryDecoder reuse) {
        return binaryDecoder(bytes, 0, bytes.length, reuse);
    }

    public BinaryDecoder binaryDecoder(byte[] bytes, BinaryDecoder reuse) {
        return binaryDecoder(bytes, 0, bytes.length, reuse);
    }

    public JsonDecoder jsonDecoder(Schema schema, InputStream input) throws IOException {
        return new JsonDecoder(schema, input);
    }

    public JsonDecoder jsonDecoder(Schema schema, String input) throws IOException {
        return new JsonDecoder(schema, input);
    }

    public ValidatingDecoder validatingDecoder(Schema schema, Decoder wrapped) throws IOException {
        return new ValidatingDecoder(schema, wrapped);
    }

    public ResolvingDecoder resolvingDecoder(Schema writer, Schema reader, Decoder wrapped) throws IOException {
        return new ResolvingDecoder(writer, reader, wrapped);
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    private static class DefaultDecoderFactory extends DecoderFactory {
        private DefaultDecoderFactory() {
        }

        @Override // com.flurry.org.apache.avro.io.DecoderFactory
        public DecoderFactory configureDecoderBufferSize(int bufferSize) {
            throw new IllegalArgumentException("This Factory instance is Immutable");
        }
    }
}
