package com.flurry.org.apache.avro.io;

import com.flurry.org.apache.avro.util.Utf8;
import java.io.IOException;
import java.nio.ByteBuffer;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public abstract class Decoder {
    public abstract long arrayNext() throws IOException;

    public abstract long mapNext() throws IOException;

    public abstract long readArrayStart() throws IOException;

    public abstract boolean readBoolean() throws IOException;

    public abstract ByteBuffer readBytes(ByteBuffer byteBuffer) throws IOException;

    public abstract double readDouble() throws IOException;

    public abstract int readEnum() throws IOException;

    public abstract void readFixed(byte[] bArr, int i, int i2) throws IOException;

    public abstract float readFloat() throws IOException;

    public abstract int readIndex() throws IOException;

    public abstract int readInt() throws IOException;

    public abstract long readLong() throws IOException;

    public abstract long readMapStart() throws IOException;

    public abstract void readNull() throws IOException;

    public abstract Utf8 readString(Utf8 utf8) throws IOException;

    public abstract String readString() throws IOException;

    public abstract long skipArray() throws IOException;

    public abstract void skipBytes() throws IOException;

    public abstract void skipFixed(int i) throws IOException;

    public abstract long skipMap() throws IOException;

    public abstract void skipString() throws IOException;

    public void readFixed(byte[] bytes) throws IOException {
        readFixed(bytes, 0, bytes.length);
    }
}
