package com.flurry.org.apache.avro.io;

import com.flurry.org.apache.avro.AvroTypeException;
import com.flurry.org.apache.avro.Schema;
import com.flurry.org.codehaus.jackson.util.MinimalPrettyPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class BlockingBinaryEncoder extends BufferedBinaryEncoder {
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final int STACK_STEP = 10;
    private BlockedValue[] blockStack;
    private byte[] buf;
    private byte[] headerBuffer;
    private int pos;
    private int stackTop;

    static {
        $assertionsDisabled = !BlockingBinaryEncoder.class.desiredAssertionStatus();
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public static class BlockedValue {
        static final /* synthetic */ boolean $assertionsDisabled;
        public long itemsLeftToWrite;
        public Schema.Type type = null;
        public State state = State.ROOT;
        public int lastFullItem = 0;
        public int start = 0;
        public int items = 1;

        /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
        public enum State {
            ROOT,
            REGULAR,
            OVERFLOW
        }

        static {
            $assertionsDisabled = !BlockingBinaryEncoder.class.desiredAssertionStatus();
        }

        public boolean check(BlockedValue prev, int pos) {
            if ($assertionsDisabled || this.state != State.ROOT || this.type == null) {
                if ($assertionsDisabled || this.state == State.ROOT || this.type == Schema.Type.ARRAY || this.type == Schema.Type.MAP) {
                    if ($assertionsDisabled || this.items >= 0) {
                        if ($assertionsDisabled || this.items != 0 || this.start == pos) {
                            if ($assertionsDisabled || 1 < this.items || this.start == this.lastFullItem) {
                                if ($assertionsDisabled || this.items <= 1 || this.start <= this.lastFullItem) {
                                    if ($assertionsDisabled || this.lastFullItem <= pos) {
                                        switch (this.state) {
                                            case ROOT:
                                                if ($assertionsDisabled || this.start == 0) {
                                                    if ($assertionsDisabled || prev == null) {
                                                        return false;
                                                    }
                                                    throw new AssertionError();
                                                }
                                                throw new AssertionError();
                                            case REGULAR:
                                                if ($assertionsDisabled || this.start >= 0) {
                                                    if ($assertionsDisabled || prev.lastFullItem <= this.start) {
                                                        if ($assertionsDisabled || 1 <= prev.items) {
                                                            return false;
                                                        }
                                                        throw new AssertionError();
                                                    }
                                                    throw new AssertionError();
                                                }
                                                throw new AssertionError();
                                            case OVERFLOW:
                                                if ($assertionsDisabled || this.start == 0) {
                                                    if ($assertionsDisabled || this.items == 1) {
                                                        if ($assertionsDisabled || prev.state == State.ROOT || prev.state == State.OVERFLOW) {
                                                            return false;
                                                        }
                                                        throw new AssertionError();
                                                    }
                                                    throw new AssertionError();
                                                }
                                                throw new AssertionError();
                                            default:
                                                return false;
                                        }
                                    }
                                    throw new AssertionError();
                                }
                                throw new AssertionError();
                            }
                            throw new AssertionError();
                        }
                        throw new AssertionError();
                    }
                    throw new AssertionError();
                }
                throw new AssertionError();
            }
            throw new AssertionError();
        }
    }

    private boolean check() {
        if ($assertionsDisabled || this.buf != null) {
            if ($assertionsDisabled || this.pos >= 0) {
                if ($assertionsDisabled || this.pos <= this.buf.length) {
                    if ($assertionsDisabled || this.blockStack != null) {
                        BlockedValue prev = null;
                        for (int i = 0; i <= this.stackTop; i++) {
                            BlockedValue v = this.blockStack[i];
                            v.check(prev, this.pos);
                            prev = v;
                        }
                        return true;
                    }
                    throw new AssertionError();
                }
                throw new AssertionError(this.pos + MinimalPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR + this.buf.length);
            }
            throw new AssertionError();
        }
        throw new AssertionError();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public BlockingBinaryEncoder(OutputStream out, int blockBufferSize, int binaryEncoderBufferSize) {
        super(out, binaryEncoderBufferSize);
        this.stackTop = -1;
        this.headerBuffer = new byte[12];
        this.buf = new byte[blockBufferSize];
        this.pos = 0;
        this.blockStack = new BlockedValue[0];
        expandStack();
        BlockedValue[] blockedValueArr = this.blockStack;
        int i = this.stackTop + 1;
        this.stackTop = i;
        BlockedValue bv = blockedValueArr[i];
        bv.type = null;
        bv.state = BlockedValue.State.ROOT;
        bv.lastFullItem = 0;
        bv.start = 0;
        bv.items = 1;
        if (!$assertionsDisabled && !check()) {
            throw new AssertionError();
        }
    }

    private void expandStack() {
        int oldLength = this.blockStack.length;
        this.blockStack = (BlockedValue[]) Arrays.copyOf(this.blockStack, this.blockStack.length + 10);
        for (int i = oldLength; i < this.blockStack.length; i++) {
            this.blockStack[i] = new BlockedValue();
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public BlockingBinaryEncoder configure(OutputStream out, int blockBufferSize, int binaryEncoderBufferSize) {
        super.configure(out, binaryEncoderBufferSize);
        this.pos = 0;
        this.stackTop = 0;
        if (this.buf == null || this.buf.length != blockBufferSize) {
            this.buf = new byte[blockBufferSize];
        }
        if ($assertionsDisabled || check()) {
            return this;
        }
        throw new AssertionError();
    }

    @Override // com.flurry.org.apache.avro.io.BufferedBinaryEncoder, java.io.Flushable
    public void flush() throws IOException {
        BlockedValue bv = this.blockStack[this.stackTop];
        if (bv.state == BlockedValue.State.ROOT) {
            super.writeFixed(this.buf, 0, this.pos);
            this.pos = 0;
        } else {
            while (bv.state != BlockedValue.State.OVERFLOW) {
                compact();
            }
        }
        super.flush();
        if (!$assertionsDisabled && !check()) {
            throw new AssertionError();
        }
    }

    @Override // com.flurry.org.apache.avro.io.BufferedBinaryEncoder, com.flurry.org.apache.avro.io.Encoder
    public void writeBoolean(boolean b) throws IOException {
        ensureBounds(1);
        this.pos += BinaryData.encodeBoolean(b, this.buf, this.pos);
    }

    @Override // com.flurry.org.apache.avro.io.BufferedBinaryEncoder, com.flurry.org.apache.avro.io.Encoder
    public void writeInt(int n) throws IOException {
        ensureBounds(5);
        this.pos += BinaryData.encodeInt(n, this.buf, this.pos);
    }

    @Override // com.flurry.org.apache.avro.io.BufferedBinaryEncoder, com.flurry.org.apache.avro.io.Encoder
    public void writeLong(long n) throws IOException {
        ensureBounds(10);
        this.pos += BinaryData.encodeLong(n, this.buf, this.pos);
    }

    @Override // com.flurry.org.apache.avro.io.BufferedBinaryEncoder, com.flurry.org.apache.avro.io.Encoder
    public void writeFloat(float f) throws IOException {
        ensureBounds(4);
        this.pos += BinaryData.encodeFloat(f, this.buf, this.pos);
    }

    @Override // com.flurry.org.apache.avro.io.BufferedBinaryEncoder, com.flurry.org.apache.avro.io.Encoder
    public void writeDouble(double d) throws IOException {
        ensureBounds(8);
        this.pos += BinaryData.encodeDouble(d, this.buf, this.pos);
    }

    @Override // com.flurry.org.apache.avro.io.BufferedBinaryEncoder, com.flurry.org.apache.avro.io.Encoder
    public void writeFixed(byte[] bytes, int start, int len) throws IOException {
        doWriteBytes(bytes, start, len);
    }

    @Override // com.flurry.org.apache.avro.io.BufferedBinaryEncoder, com.flurry.org.apache.avro.io.BinaryEncoder
    protected void writeZero() throws IOException {
        ensureBounds(1);
        byte[] bArr = this.buf;
        int i = this.pos;
        this.pos = i + 1;
        bArr[i] = 0;
    }

    @Override // com.flurry.org.apache.avro.io.BinaryEncoder, com.flurry.org.apache.avro.io.Encoder
    public void writeArrayStart() throws IOException {
        if (this.stackTop + 1 == this.blockStack.length) {
            expandStack();
        }
        BlockedValue[] blockedValueArr = this.blockStack;
        int i = this.stackTop + 1;
        this.stackTop = i;
        BlockedValue bv = blockedValueArr[i];
        bv.type = Schema.Type.ARRAY;
        bv.state = BlockedValue.State.REGULAR;
        int i2 = this.pos;
        bv.lastFullItem = i2;
        bv.start = i2;
        bv.items = 0;
        if (!$assertionsDisabled && !check()) {
            throw new AssertionError();
        }
    }

    @Override // com.flurry.org.apache.avro.io.BinaryEncoder, com.flurry.org.apache.avro.io.Encoder
    public void setItemCount(long itemCount) throws IOException {
        BlockedValue v = this.blockStack[this.stackTop];
        if (!$assertionsDisabled && v.type != Schema.Type.ARRAY && v.type != Schema.Type.MAP) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && v.itemsLeftToWrite != 0) {
            throw new AssertionError();
        }
        v.itemsLeftToWrite = itemCount;
        if (!$assertionsDisabled && !check()) {
            throw new AssertionError();
        }
    }

    @Override // com.flurry.org.apache.avro.io.BinaryEncoder, com.flurry.org.apache.avro.io.Encoder
    public void startItem() throws IOException {
        if (this.blockStack[this.stackTop].state == BlockedValue.State.OVERFLOW) {
            finishOverflow();
        }
        BlockedValue t = this.blockStack[this.stackTop];
        t.items++;
        t.lastFullItem = this.pos;
        t.itemsLeftToWrite--;
        if (!$assertionsDisabled && !check()) {
            throw new AssertionError();
        }
    }

    @Override // com.flurry.org.apache.avro.io.BinaryEncoder, com.flurry.org.apache.avro.io.Encoder
    public void writeArrayEnd() throws IOException {
        BlockedValue top = this.blockStack[this.stackTop];
        if (top.type != Schema.Type.ARRAY) {
            throw new AvroTypeException("Called writeArrayEnd outside of an array.");
        }
        if (top.itemsLeftToWrite != 0) {
            throw new AvroTypeException("Failed to write expected number of array elements.");
        }
        endBlockedValue();
        if (!$assertionsDisabled && !check()) {
            throw new AssertionError();
        }
    }

    @Override // com.flurry.org.apache.avro.io.BinaryEncoder, com.flurry.org.apache.avro.io.Encoder
    public void writeMapStart() throws IOException {
        if (this.stackTop + 1 == this.blockStack.length) {
            expandStack();
        }
        BlockedValue[] blockedValueArr = this.blockStack;
        int i = this.stackTop + 1;
        this.stackTop = i;
        BlockedValue bv = blockedValueArr[i];
        bv.type = Schema.Type.MAP;
        bv.state = BlockedValue.State.REGULAR;
        int i2 = this.pos;
        bv.lastFullItem = i2;
        bv.start = i2;
        bv.items = 0;
        if (!$assertionsDisabled && !check()) {
            throw new AssertionError();
        }
    }

    @Override // com.flurry.org.apache.avro.io.BinaryEncoder, com.flurry.org.apache.avro.io.Encoder
    public void writeMapEnd() throws IOException {
        BlockedValue top = this.blockStack[this.stackTop];
        if (top.type != Schema.Type.MAP) {
            throw new AvroTypeException("Called writeMapEnd outside of a map.");
        }
        if (top.itemsLeftToWrite != 0) {
            throw new AvroTypeException("Failed to read write expected number of array elements.");
        }
        endBlockedValue();
        if (!$assertionsDisabled && !check()) {
            throw new AssertionError();
        }
    }

    @Override // com.flurry.org.apache.avro.io.BinaryEncoder, com.flurry.org.apache.avro.io.Encoder
    public void writeIndex(int unionIndex) throws IOException {
        ensureBounds(5);
        this.pos += BinaryData.encodeInt(unionIndex, this.buf, this.pos);
    }

    @Override // com.flurry.org.apache.avro.io.BufferedBinaryEncoder, com.flurry.org.apache.avro.io.BinaryEncoder
    public int bytesBuffered() {
        return this.pos + super.bytesBuffered();
    }

    /* JADX WARN: Code restructure failed: missing block: B:31:0x0065, code lost:
        r8.stackTop--;
        ensureBounds(1);
        r4 = r8.buf;
        r5 = r8.pos;
        r8.pos = r5 + 1;
        r4[r5] = 0;
     */
    /* JADX WARN: Code restructure failed: missing block: B:32:0x007b, code lost:
        if (com.flurry.org.apache.avro.io.BlockingBinaryEncoder.$assertionsDisabled != false) goto L41;
     */
    /* JADX WARN: Code restructure failed: missing block: B:34:0x0081, code lost:
        if (check() != false) goto L41;
     */
    /* JADX WARN: Code restructure failed: missing block: B:36:0x0088, code lost:
        throw new java.lang.AssertionError();
     */
    /* JADX WARN: Code restructure failed: missing block: B:42:0x00ca, code lost:
        if (r8.blockStack[r8.stackTop].state != com.flurry.org.apache.avro.io.BlockingBinaryEncoder.BlockedValue.State.ROOT) goto L45;
     */
    /* JADX WARN: Code restructure failed: missing block: B:43:0x00cc, code lost:
        flush();
     */
    /* JADX WARN: Code restructure failed: missing block: B:44:0x00cf, code lost:
        return;
     */
    /* JADX WARN: Code restructure failed: missing block: B:51:?, code lost:
        return;
     */
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    private void endBlockedValue() throws java.io.IOException {
        /*
            Method dump skipped, instructions count: 208
            To view this dump change 'Code comments level' option to 'DEBUG'
        */
        throw new UnsupportedOperationException("Method not decompiled: com.flurry.org.apache.avro.io.BlockingBinaryEncoder.endBlockedValue():void");
    }

    private void finishOverflow() throws IOException {
        BlockedValue s = this.blockStack[this.stackTop];
        if (s.state != BlockedValue.State.OVERFLOW) {
            throw new IllegalStateException("Not an overflow block");
        }
        if (!$assertionsDisabled && !check()) {
            throw new AssertionError();
        }
        super.writeFixed(this.buf, 0, this.pos);
        this.pos = 0;
        s.state = BlockedValue.State.REGULAR;
        s.lastFullItem = 0;
        s.start = 0;
        s.items = 0;
        if (!$assertionsDisabled && !check()) {
            throw new AssertionError();
        }
    }

    private void ensureBounds(int l) throws IOException {
        while (this.buf.length < this.pos + l) {
            if (this.blockStack[this.stackTop].state == BlockedValue.State.REGULAR) {
                compact();
            } else {
                super.writeFixed(this.buf, 0, this.pos);
                this.pos = 0;
            }
        }
    }

    private void doWriteBytes(byte[] bytes, int start, int len) throws IOException {
        if (len < this.buf.length) {
            ensureBounds(len);
            System.arraycopy(bytes, start, this.buf, this.pos, len);
            this.pos += len;
            return;
        }
        ensureBounds(this.buf.length);
        if (!$assertionsDisabled && this.blockStack[this.stackTop].state != BlockedValue.State.ROOT && this.blockStack[this.stackTop].state != BlockedValue.State.OVERFLOW) {
            throw new AssertionError();
        }
        write(bytes, start, len);
    }

    private void write(byte[] b, int off, int len) throws IOException {
        if (this.blockStack[this.stackTop].state == BlockedValue.State.ROOT) {
            super.writeFixed(b, off, len);
        } else if (!$assertionsDisabled && !check()) {
            throw new AssertionError();
        } else {
            while (this.buf.length < this.pos + len) {
                if (this.blockStack[this.stackTop].state == BlockedValue.State.REGULAR) {
                    compact();
                } else {
                    super.writeFixed(this.buf, 0, this.pos);
                    this.pos = 0;
                    if (this.buf.length <= len) {
                        super.writeFixed(b, off, len);
                        len = 0;
                    }
                }
            }
            System.arraycopy(b, off, this.buf, this.pos, len);
            this.pos += len;
        }
        if (!$assertionsDisabled && !check()) {
            throw new AssertionError();
        }
    }

    private void compact() throws IOException {
        if (!$assertionsDisabled && !check()) {
            throw new AssertionError();
        }
        BlockedValue s = null;
        int i = 1;
        while (i <= this.stackTop) {
            s = this.blockStack[i];
            if (s.state == BlockedValue.State.REGULAR) {
                break;
            }
            i++;
        }
        if (!$assertionsDisabled && s == null) {
            throw new AssertionError();
        }
        super.writeFixed(this.buf, 0, s.start);
        if (1 < s.items) {
            super.writeInt(-(s.items - 1));
            super.writeInt(s.lastFullItem - s.start);
            super.writeFixed(this.buf, s.start, s.lastFullItem - s.start);
            s.start = s.lastFullItem;
            s.items = 1;
        }
        super.writeInt(1);
        BlockedValue n = i + 1 <= this.stackTop ? this.blockStack[i + 1] : null;
        int end = n == null ? this.pos : n.start;
        super.writeFixed(this.buf, s.lastFullItem, end - s.lastFullItem);
        System.arraycopy(this.buf, end, this.buf, 0, this.pos - end);
        for (int j = i + 1; j <= this.stackTop; j++) {
            BlockedValue n2 = this.blockStack[j];
            n2.start -= end;
            n2.lastFullItem -= end;
        }
        this.pos -= end;
        if (!$assertionsDisabled && s.items != 1) {
            throw new AssertionError();
        }
        s.lastFullItem = 0;
        s.start = 0;
        s.state = BlockedValue.State.OVERFLOW;
        if (!$assertionsDisabled && !check()) {
            throw new AssertionError();
        }
    }
}
