package com.flurry.org.apache.avro.io;

import com.flurry.org.apache.avro.util.Utf8;
import java.io.IOException;
import java.nio.ByteBuffer;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public abstract class BinaryEncoder extends Encoder {
    public abstract int bytesBuffered();

    protected abstract void writeZero() throws IOException;

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void writeNull() throws IOException {
    }

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void writeString(Utf8 utf8) throws IOException {
        writeBytes(utf8.getBytes(), 0, utf8.getByteLength());
    }

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void writeString(String string) throws IOException {
        if (string.length() == 0) {
            writeZero();
            return;
        }
        byte[] bytes = string.getBytes("UTF-8");
        writeInt(bytes.length);
        writeFixed(bytes, 0, bytes.length);
    }

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void writeBytes(ByteBuffer bytes) throws IOException {
        int pos = bytes.position();
        int start = bytes.arrayOffset() + pos;
        int len = bytes.limit() - pos;
        writeBytes(bytes.array(), start, len);
    }

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void writeBytes(byte[] bytes, int start, int len) throws IOException {
        if (len == 0) {
            writeZero();
            return;
        }
        writeInt(len);
        writeFixed(bytes, start, len);
    }

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void writeEnum(int e) throws IOException {
        writeInt(e);
    }

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void writeArrayStart() throws IOException {
    }

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void setItemCount(long itemCount) throws IOException {
        if (itemCount > 0) {
            writeLong(itemCount);
        }
    }

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void startItem() throws IOException {
    }

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void writeArrayEnd() throws IOException {
        writeZero();
    }

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void writeMapStart() throws IOException {
    }

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void writeMapEnd() throws IOException {
        writeZero();
    }

    @Override // com.flurry.org.apache.avro.io.Encoder
    public void writeIndex(int unionIndex) throws IOException {
        writeInt(unionIndex);
    }
}
