package com.flurry.org.apache.avro.io;

import com.flurry.android.Constants;
import com.flurry.org.apache.avro.AvroRuntimeException;
import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.generic.GenericDatumReader;
import com.flurry.org.apache.avro.io.BinaryDecoder;
import com.prime31.util.IabHelper;
import com.tapjoy.TapjoyVideoObject;
import java.io.IOException;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class BinaryData {
    private static final ThreadLocal<Decoders> DECODERS = new ThreadLocal<Decoders>() { // from class: com.flurry.org.apache.avro.io.BinaryData.1
        /* JADX INFO: Access modifiers changed from: protected */
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // java.lang.ThreadLocal
        public Decoders initialValue() {
            return new Decoders();
        }
    };
    private static final ThreadLocal<HashData> HASH_DATA = new ThreadLocal<HashData>() { // from class: com.flurry.org.apache.avro.io.BinaryData.2
        /* JADX INFO: Access modifiers changed from: protected */
        /* JADX WARN: Can't rename method to resolve collision */
        @Override // java.lang.ThreadLocal
        public HashData initialValue() {
            return new HashData();
        }
    };

    private BinaryData() {
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public static class Decoders {
        private final BinaryDecoder d1 = new BinaryDecoder(new byte[0], 0, 0);
        private final BinaryDecoder d2 = new BinaryDecoder(new byte[0], 0, 0);
        private final BinaryDecoder.BufferAccessor b1 = this.d1.getBufferAccessor();
        private final BinaryDecoder.BufferAccessor b2 = this.d2.getBufferAccessor();

        public void set(byte[] data1, int off1, int len1, byte[] data2, int off2, int len2) {
            this.d1.configure(data1, off1, len1);
            this.d2.configure(data2, off2, len2);
        }
    }

    public static int compare(byte[] b1, int s1, byte[] b2, int s2, Schema schema) {
        return compare(b1, s1, b1.length - s1, b2, s2, b2.length - s2, schema);
    }

    public static int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2, Schema schema) {
        Decoders decoders = DECODERS.get();
        decoders.set(b1, s1, l1, b2, s2, l2);
        try {
            return compare(decoders, schema);
        } catch (IOException e) {
            throw new AvroRuntimeException(e);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* renamed from: com.flurry.org.apache.avro.io.BinaryData$3  reason: invalid class name */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public static /* synthetic */ class AnonymousClass3 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$avro$Schema$Type = new int[Schema.Type.values().length];

        static {
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.RECORD.ordinal()] = 1;
            } catch (NoSuchFieldError e) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.ENUM.ordinal()] = 2;
            } catch (NoSuchFieldError e2) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.INT.ordinal()] = 3;
            } catch (NoSuchFieldError e3) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.LONG.ordinal()] = 4;
            } catch (NoSuchFieldError e4) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.ARRAY.ordinal()] = 5;
            } catch (NoSuchFieldError e5) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.MAP.ordinal()] = 6;
            } catch (NoSuchFieldError e6) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.UNION.ordinal()] = 7;
            } catch (NoSuchFieldError e7) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.FIXED.ordinal()] = 8;
            } catch (NoSuchFieldError e8) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.STRING.ordinal()] = 9;
            } catch (NoSuchFieldError e9) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.BYTES.ordinal()] = 10;
            } catch (NoSuchFieldError e10) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.FLOAT.ordinal()] = 11;
            } catch (NoSuchFieldError e11) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.DOUBLE.ordinal()] = 12;
            } catch (NoSuchFieldError e12) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.BOOLEAN.ordinal()] = 13;
            } catch (NoSuchFieldError e13) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.NULL.ordinal()] = 14;
            } catch (NoSuchFieldError e14) {
            }
        }
    }

    private static int compare(Decoders d, Schema schema) throws IOException {
        Decoder d1 = d.d1;
        Decoder d2 = d.d2;
        switch (AnonymousClass3.$SwitchMap$org$apache$avro$Schema$Type[schema.getType().ordinal()]) {
            case 1:
                for (Schema.Field field : schema.getFields()) {
                    if (field.order() == Schema.Field.Order.IGNORE) {
                        GenericDatumReader.skip(field.schema(), d1);
                        GenericDatumReader.skip(field.schema(), d2);
                    } else {
                        int c = compare(d, field.schema());
                        if (c != 0) {
                            if (field.order() == Schema.Field.Order.DESCENDING) {
                                c = -c;
                            }
                            return c;
                        }
                    }
                }
                return 0;
            case 2:
            case 3:
                int i1 = d1.readInt();
                int i2 = d2.readInt();
                if (i1 == i2) {
                    return 0;
                }
                return i1 > i2 ? 1 : -1;
            case 4:
                long l1 = d1.readLong();
                long l2 = d2.readLong();
                if (l1 == l2) {
                    return 0;
                }
                return l1 > l2 ? 1 : -1;
            case 5:
                long i = 0;
                long r1 = 0;
                long r2 = 0;
                long l12 = 0;
                long l22 = 0;
                while (true) {
                    if (r1 == 0) {
                        r1 = d1.readLong();
                        if (r1 < 0) {
                            r1 = -r1;
                            d1.readLong();
                        }
                        l12 += r1;
                    }
                    if (r2 == 0) {
                        r2 = d2.readLong();
                        if (r2 < 0) {
                            r2 = -r2;
                            d2.readLong();
                        }
                        l22 += r2;
                    }
                    if (r1 != 0 && r2 != 0) {
                        long l = Math.min(l12, l22);
                        while (i < l) {
                            int c2 = compare(d, schema.getElementType());
                            if (c2 != 0) {
                                return c2;
                            }
                            i++;
                            r1--;
                            r2--;
                        }
                    }
                }
                if (l12 == l22) {
                    return 0;
                }
                return l12 > l22 ? 1 : -1;
            case 6:
                throw new AvroRuntimeException("Can't compare maps!");
            case IabHelper.BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED /* 7 */:
                int i12 = d1.readInt();
                int i22 = d2.readInt();
                if (i12 == i22) {
                    return compare(d, schema.getTypes().get(i12));
                }
                return i12 - i22;
            case 8:
                int size = schema.getFixedSize();
                int c3 = compareBytes(d.b1.getBuf(), d.b1.getPos(), size, d.b2.getBuf(), d.b2.getPos(), size);
                d.d1.skipFixed(size);
                d.d2.skipFixed(size);
                return c3;
            case 9:
            case TapjoyVideoObject.BUTTON_MAX /* 10 */:
                int l13 = d1.readInt();
                int l23 = d2.readInt();
                int c4 = compareBytes(d.b1.getBuf(), d.b1.getPos(), l13, d.b2.getBuf(), d.b2.getPos(), l23);
                d.d1.skipFixed(l13);
                d.d2.skipFixed(l23);
                return c4;
            case 11:
                float f1 = d1.readFloat();
                float f2 = d2.readFloat();
                if (f1 == f2) {
                    return 0;
                }
                return f1 > f2 ? 1 : -1;
            case 12:
                double f12 = d1.readDouble();
                double f22 = d2.readDouble();
                if (f12 == f22) {
                    return 0;
                }
                return f12 > f22 ? 1 : -1;
            case 13:
                boolean b1 = d1.readBoolean();
                boolean b2 = d2.readBoolean();
                if (b1 == b2) {
                    return 0;
                }
                return b1 ? 1 : -1;
            case 14:
                return 0;
            default:
                throw new AvroRuntimeException("Unexpected schema to compare!");
        }
    }

    public static int compareBytes(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int end1 = s1 + l1;
        int end2 = s2 + l2;
        int i = s1;
        for (int j = s2; i < end1 && j < end2; j++) {
            int a = b1[i] & Constants.UNKNOWN;
            int b = b2[j] & Constants.UNKNOWN;
            if (a == b) {
                i++;
            } else {
                return a - b;
            }
        }
        return l1 - l2;
    }

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public static class HashData {
        private final BinaryDecoder decoder = new BinaryDecoder(new byte[0], 0, 0);
        private final BinaryDecoder.BufferAccessor bytes = this.decoder.getBufferAccessor();

        public void set(byte[] bytes, int start, int len) {
            this.decoder.configure(bytes, start, len);
        }
    }

    public static int hashCode(byte[] bytes, int start, int length, Schema schema) {
        HashData data = HASH_DATA.get();
        data.set(bytes, start, length);
        try {
            return hashCode(data, schema);
        } catch (IOException e) {
            throw new AvroRuntimeException(e);
        }
    }

    private static int hashCode(HashData data, Schema schema) throws IOException {
        Decoder decoder = data.decoder;
        switch (AnonymousClass3.$SwitchMap$org$apache$avro$Schema$Type[schema.getType().ordinal()]) {
            case 1:
                int hashCode = 1;
                for (Schema.Field field : schema.getFields()) {
                    if (field.order() == Schema.Field.Order.IGNORE) {
                        GenericDatumReader.skip(field.schema(), decoder);
                    } else {
                        hashCode = (hashCode * 31) + hashCode(data, field.schema());
                    }
                }
                return hashCode;
            case 2:
            case 3:
                int hashCode2 = decoder.readInt();
                return hashCode2;
            case 4:
                long l = decoder.readLong();
                return (int) ((l >>> 32) ^ l);
            case 5:
                Schema elementType = schema.getElementType();
                int hashCode3 = 1;
                for (long l2 = decoder.readArrayStart(); l2 != 0; l2 = decoder.arrayNext()) {
                    for (long i = 0; i < l2; i++) {
                        hashCode3 = (hashCode3 * 31) + hashCode(data, elementType);
                    }
                }
                return hashCode3;
            case 6:
                throw new AvroRuntimeException("Can't hashCode maps!");
            case IabHelper.BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED /* 7 */:
                return hashCode(data, schema.getTypes().get(decoder.readInt()));
            case 8:
                return hashBytes(1, data, schema.getFixedSize(), false);
            case 9:
                return hashBytes(0, data, decoder.readInt(), false);
            case TapjoyVideoObject.BUTTON_MAX /* 10 */:
                return hashBytes(1, data, decoder.readInt(), true);
            case 11:
                return Float.floatToIntBits(decoder.readFloat());
            case 12:
                long l3 = Double.doubleToLongBits(decoder.readDouble());
                return (int) ((l3 >>> 32) ^ l3);
            case 13:
                return decoder.readBoolean() ? 1231 : 1237;
            case 14:
                return 0;
            default:
                throw new AvroRuntimeException("Unexpected schema to hashCode!");
        }
    }

    private static int hashBytes(int init, HashData data, int len, boolean rev) throws IOException {
        int hashCode = init;
        byte[] bytes = data.bytes.getBuf();
        int start = data.bytes.getPos();
        int end = start + len;
        if (rev) {
            for (int i = end - 1; i >= start; i--) {
                hashCode = (hashCode * 31) + bytes[i];
            }
        } else {
            for (int i2 = start; i2 < end; i2++) {
                hashCode = (hashCode * 31) + bytes[i2];
            }
        }
        data.decoder.skipFixed(len);
        return hashCode;
    }

    public static int skipLong(byte[] bytes, int start) {
        int i = start + 1;
        int b = bytes[start];
        while ((b & 128) != 0) {
            b = bytes[i];
            i++;
        }
        return i;
    }

    public static int encodeBoolean(boolean b, byte[] buf, int pos) {
        buf[pos] = b ? (byte) 1 : (byte) 0;
        return 1;
    }

    public static int encodeInt(int n, byte[] buf, int pos) {
        int n2 = (n << 1) ^ (n >> 31);
        if ((n2 & (-128)) != 0) {
            int pos2 = pos + 1;
            buf[pos] = (byte) ((n2 | 128) & 255);
            n2 >>>= 7;
            if (n2 > 127) {
                pos = pos2 + 1;
                buf[pos2] = (byte) ((n2 | 128) & 255);
                n2 >>>= 7;
                if (n2 > 127) {
                    pos2 = pos + 1;
                    buf[pos] = (byte) ((n2 | 128) & 255);
                    n2 >>>= 7;
                    if (n2 > 127) {
                        pos = pos2 + 1;
                        buf[pos2] = (byte) ((n2 | 128) & 255);
                        n2 >>>= 7;
                    }
                }
            }
            pos = pos2;
        }
        buf[pos] = (byte) n2;
        return (pos + 1) - pos;
    }

    public static int encodeLong(long n, byte[] buf, int pos) {
        long n2 = (n << 1) ^ (n >> 63);
        if (((-128) & n2) != 0) {
            int pos2 = pos + 1;
            buf[pos] = (byte) ((128 | n2) & 255);
            n2 >>>= 7;
            if (n2 > 127) {
                pos = pos2 + 1;
                buf[pos2] = (byte) ((128 | n2) & 255);
                n2 >>>= 7;
                if (n2 > 127) {
                    pos2 = pos + 1;
                    buf[pos] = (byte) ((128 | n2) & 255);
                    n2 >>>= 7;
                    if (n2 > 127) {
                        pos = pos2 + 1;
                        buf[pos2] = (byte) ((128 | n2) & 255);
                        n2 >>>= 7;
                        if (n2 > 127) {
                            pos2 = pos + 1;
                            buf[pos] = (byte) ((128 | n2) & 255);
                            n2 >>>= 7;
                            if (n2 > 127) {
                                pos = pos2 + 1;
                                buf[pos2] = (byte) ((128 | n2) & 255);
                                n2 >>>= 7;
                                if (n2 > 127) {
                                    pos2 = pos + 1;
                                    buf[pos] = (byte) ((128 | n2) & 255);
                                    n2 >>>= 7;
                                    if (n2 > 127) {
                                        pos = pos2 + 1;
                                        buf[pos2] = (byte) ((128 | n2) & 255);
                                        n2 >>>= 7;
                                        if (n2 > 127) {
                                            buf[pos] = (byte) ((128 | n2) & 255);
                                            n2 >>>= 7;
                                            pos++;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            pos = pos2;
        }
        buf[pos] = (byte) n2;
        return (pos + 1) - pos;
    }

    public static int encodeFloat(float f, byte[] buf, int pos) {
        int bits = Float.floatToRawIntBits(f);
        buf[pos] = (byte) (bits & 255);
        int len = 1 + 1;
        buf[pos + 1] = (byte) ((bits >>> 8) & 255);
        buf[pos + 2] = (byte) ((bits >>> 16) & 255);
        int i = len + 1 + 1;
        buf[pos + 3] = (byte) ((bits >>> 24) & 255);
        return 4;
    }

    public static int encodeDouble(double d, byte[] buf, int pos) {
        long bits = Double.doubleToRawLongBits(d);
        int first = (int) (bits & (-1));
        int second = (int) ((bits >>> 32) & (-1));
        buf[pos] = (byte) (first & 255);
        buf[pos + 4] = (byte) (second & 255);
        buf[pos + 5] = (byte) ((second >>> 8) & 255);
        buf[pos + 1] = (byte) ((first >>> 8) & 255);
        buf[pos + 2] = (byte) ((first >>> 16) & 255);
        buf[pos + 6] = (byte) ((second >>> 16) & 255);
        buf[pos + 7] = (byte) ((second >>> 24) & 255);
        buf[pos + 3] = (byte) ((first >>> 24) & 255);
        return 8;
    }
}
