package com.flurry.org.apache.avro.generic;

import com.flurry.org.apache.avro.AvroRuntimeException;
import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.data.RecordBuilderBase;
import com.flurry.org.apache.avro.generic.GenericData;
import java.io.IOException;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class GenericRecordBuilder extends RecordBuilderBase<GenericData.Record> {
    private final GenericData.Record record;

    public GenericRecordBuilder(Schema schema) {
        super(schema, GenericData.get());
        this.record = new GenericData.Record(schema);
    }

    public GenericRecordBuilder(GenericRecordBuilder other) {
        super(other, GenericData.get());
        this.record = new GenericData.Record(other.record, true);
    }

    public GenericRecordBuilder(GenericData.Record other) {
        super(other.getSchema(), GenericData.get());
        this.record = new GenericData.Record(other, true);
        for (Schema.Field f : schema().getFields()) {
            Object value = other.get(f.pos());
            if (isValidValue(f, value)) {
                set(f, data().deepCopy(f.schema(), value));
            }
        }
    }

    public Object get(String fieldName) {
        return get(schema().getField(fieldName));
    }

    public Object get(Schema.Field field) {
        return get(field.pos());
    }

    protected Object get(int pos) {
        return this.record.get(pos);
    }

    public GenericRecordBuilder set(String fieldName, Object value) {
        return set(schema().getField(fieldName), value);
    }

    public GenericRecordBuilder set(Schema.Field field, Object value) {
        return set(field, field.pos(), value);
    }

    protected GenericRecordBuilder set(int pos, Object value) {
        return set(fields()[pos], pos, value);
    }

    private GenericRecordBuilder set(Schema.Field field, int pos, Object value) {
        validate(field, value);
        this.record.put(pos, value);
        fieldSetFlags()[pos] = true;
        return this;
    }

    public boolean has(String fieldName) {
        return has(schema().getField(fieldName));
    }

    public boolean has(Schema.Field field) {
        return has(field.pos());
    }

    protected boolean has(int pos) {
        return fieldSetFlags()[pos];
    }

    public GenericRecordBuilder clear(String fieldName) {
        return clear(schema().getField(fieldName));
    }

    public GenericRecordBuilder clear(Schema.Field field) {
        return clear(field.pos());
    }

    protected GenericRecordBuilder clear(int pos) {
        this.record.put(pos, (Object) null);
        fieldSetFlags()[pos] = false;
        return this;
    }

    @Override // com.flurry.org.apache.avro.data.RecordBuilder
    public GenericData.Record build() {
        try {
            GenericData.Record record = new GenericData.Record(schema());
            Schema.Field[] arr$ = fields();
            for (Schema.Field field : arr$) {
                try {
                    Object value = getWithDefault(field);
                    if (value != null) {
                        record.put(field.pos(), value);
                    }
                } catch (IOException e) {
                    throw new AvroRuntimeException(e);
                }
            }
            return record;
        } catch (Exception e2) {
            throw new AvroRuntimeException(e2);
        }
    }

    private Object getWithDefault(Schema.Field field) throws IOException {
        return fieldSetFlags()[field.pos()] ? this.record.get(field.pos()) : defaultValue(field);
    }

    @Override // com.flurry.org.apache.avro.data.RecordBuilderBase
    public int hashCode() {
        int result = super.hashCode();
        return (result * 31) + (this.record == null ? 0 : this.record.hashCode());
    }

    @Override // com.flurry.org.apache.avro.data.RecordBuilderBase
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (super.equals(obj) && getClass() == obj.getClass()) {
            GenericRecordBuilder other = (GenericRecordBuilder) obj;
            return this.record == null ? other.record == null : this.record.equals(other.record);
        }
        return false;
    }
}
