package com.flurry.org.apache.avro.generic;

import com.flurry.org.apache.avro.AvroTypeException;
import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.io.DatumWriter;
import com.flurry.org.apache.avro.io.Encoder;
import com.prime31.util.IabHelper;
import com.tapjoy.TapjoyVideoObject;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class GenericDatumWriter<D> implements DatumWriter<D> {
    private final GenericData data;
    private Schema root;

    public GenericDatumWriter() {
        this(GenericData.get());
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public GenericDatumWriter(GenericData data) {
        this.data = data;
    }

    public GenericDatumWriter(Schema root) {
        this();
        setSchema(root);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public GenericDatumWriter(Schema root, GenericData data) {
        this(data);
        setSchema(root);
    }

    public GenericData getData() {
        return this.data;
    }

    @Override // com.flurry.org.apache.avro.io.DatumWriter
    public void setSchema(Schema root) {
        this.root = root;
    }

    @Override // com.flurry.org.apache.avro.io.DatumWriter
    public void write(D datum, Encoder out) throws IOException {
        write(this.root, datum, out);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* renamed from: com.flurry.org.apache.avro.generic.GenericDatumWriter$1  reason: invalid class name */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public static /* synthetic */ class AnonymousClass1 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$avro$Schema$Type = new int[Schema.Type.values().length];

        static {
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.RECORD.ordinal()] = 1;
            } catch (NoSuchFieldError e) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.ENUM.ordinal()] = 2;
            } catch (NoSuchFieldError e2) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.ARRAY.ordinal()] = 3;
            } catch (NoSuchFieldError e3) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.MAP.ordinal()] = 4;
            } catch (NoSuchFieldError e4) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.UNION.ordinal()] = 5;
            } catch (NoSuchFieldError e5) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.FIXED.ordinal()] = 6;
            } catch (NoSuchFieldError e6) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.STRING.ordinal()] = 7;
            } catch (NoSuchFieldError e7) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.BYTES.ordinal()] = 8;
            } catch (NoSuchFieldError e8) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.INT.ordinal()] = 9;
            } catch (NoSuchFieldError e9) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.LONG.ordinal()] = 10;
            } catch (NoSuchFieldError e10) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.FLOAT.ordinal()] = 11;
            } catch (NoSuchFieldError e11) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.DOUBLE.ordinal()] = 12;
            } catch (NoSuchFieldError e12) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.BOOLEAN.ordinal()] = 13;
            } catch (NoSuchFieldError e13) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.NULL.ordinal()] = 14;
            } catch (NoSuchFieldError e14) {
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void write(Schema schema, Object datum, Encoder out) throws IOException {
        try {
            switch (AnonymousClass1.$SwitchMap$org$apache$avro$Schema$Type[schema.getType().ordinal()]) {
                case 1:
                    writeRecord(schema, datum, out);
                    return;
                case 2:
                    writeEnum(schema, datum, out);
                    return;
                case 3:
                    writeArray(schema, datum, out);
                    return;
                case 4:
                    writeMap(schema, datum, out);
                    return;
                case 5:
                    int index = resolveUnion(schema, datum);
                    out.writeIndex(index);
                    write(schema.getTypes().get(index), datum, out);
                    return;
                case 6:
                    writeFixed(schema, datum, out);
                    return;
                case IabHelper.BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED /* 7 */:
                    writeString(schema, datum, out);
                    return;
                case 8:
                    writeBytes(datum, out);
                    return;
                case 9:
                    out.writeInt(((Number) datum).intValue());
                    return;
                case TapjoyVideoObject.BUTTON_MAX /* 10 */:
                    out.writeLong(((Long) datum).longValue());
                    return;
                case 11:
                    out.writeFloat(((Float) datum).floatValue());
                    return;
                case 12:
                    out.writeDouble(((Double) datum).doubleValue());
                    return;
                case 13:
                    out.writeBoolean(((Boolean) datum).booleanValue());
                    return;
                case 14:
                    out.writeNull();
                    return;
                default:
                    error(schema, datum);
                    return;
            }
        } catch (NullPointerException e) {
            throw npe(e, " of " + schema.getFullName());
        }
    }

    protected NullPointerException npe(NullPointerException e, String s) {
        NullPointerException result = new NullPointerException(e.getMessage() + s);
        Throwable cause = e.getCause();
        Throwable th = e;
        if (cause != null) {
            th = e.getCause();
        }
        result.initCause(th);
        return result;
    }

    protected void writeRecord(Schema schema, Object datum, Encoder out) throws IOException {
        Object state = this.data.getRecordState(datum, schema);
        for (Schema.Field f : schema.getFields()) {
            Object value = this.data.getField(datum, f.name(), f.pos(), state);
            try {
                write(f.schema(), value, out);
            } catch (NullPointerException e) {
                throw npe(e, " in field " + f.name());
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void writeEnum(Schema schema, Object datum, Encoder out) throws IOException {
        out.writeEnum(schema.getEnumOrdinal(datum.toString()));
    }

    protected void writeArray(Schema schema, Object datum, Encoder out) throws IOException {
        Schema element = schema.getElementType();
        long size = getArraySize(datum);
        out.writeArrayStart();
        out.setItemCount(size);
        Iterator<? extends Object> it = getArrayElements(datum);
        while (it.hasNext()) {
            out.startItem();
            write(element, it.next(), out);
        }
        out.writeArrayEnd();
    }

    protected int resolveUnion(Schema union, Object datum) {
        return this.data.resolveUnion(union, datum);
    }

    protected long getArraySize(Object array) {
        return ((Collection) array).size();
    }

    protected Iterator<? extends Object> getArrayElements(Object array) {
        return ((Collection) array).iterator();
    }

    protected void writeMap(Schema schema, Object datum, Encoder out) throws IOException {
        Schema value = schema.getValueType();
        int size = getMapSize(datum);
        out.writeMapStart();
        out.setItemCount(size);
        for (Map.Entry<Object, Object> entry : getMapEntries(datum)) {
            out.startItem();
            writeString(entry.getKey(), out);
            write(value, entry.getValue(), out);
        }
        out.writeMapEnd();
    }

    protected int getMapSize(Object map) {
        return ((Map) map).size();
    }

    protected Iterable<Map.Entry<Object, Object>> getMapEntries(Object map) {
        return ((Map) map).entrySet();
    }

    protected void writeString(Schema schema, Object datum, Encoder out) throws IOException {
        writeString(datum, out);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void writeString(Object datum, Encoder out) throws IOException {
        out.writeString((CharSequence) datum);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public void writeBytes(Object datum, Encoder out) throws IOException {
        out.writeBytes((ByteBuffer) datum);
    }

    protected void writeFixed(Schema schema, Object datum, Encoder out) throws IOException {
        out.writeFixed(((GenericFixed) datum).bytes(), 0, schema.getFixedSize());
    }

    private void error(Schema schema, Object datum) {
        throw new AvroTypeException("Not a " + schema + ": " + datum);
    }
}
