package com.flurry.org.apache.avro.generic;

import com.flurry.org.apache.avro.AvroRuntimeException;
import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.generic.GenericData;
import com.flurry.org.apache.avro.io.DatumReader;
import com.flurry.org.apache.avro.io.Decoder;
import com.flurry.org.apache.avro.io.DecoderFactory;
import com.flurry.org.apache.avro.io.ResolvingDecoder;
import com.flurry.org.apache.avro.util.Utf8;
import com.flurry.org.apache.avro.util.WeakIdentityHashMap;
import com.prime31.util.IabHelper;
import com.tapjoy.TapjoyVideoObject;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class GenericDatumReader<D> implements DatumReader<D> {
    private static final ThreadLocal<Map<Schema, Map<Schema, ResolvingDecoder>>> RESOLVER_CACHE = new ThreadLocal<Map<Schema, Map<Schema, ResolvingDecoder>>>() { // from class: com.flurry.org.apache.avro.generic.GenericDatumReader.1
        /* JADX INFO: Access modifiers changed from: protected */
        @Override // java.lang.ThreadLocal
        public Map<Schema, Map<Schema, ResolvingDecoder>> initialValue() {
            return new WeakIdentityHashMap();
        }
    };
    private Schema actual;
    private final Thread creator;
    private ResolvingDecoder creatorResolver;
    private final GenericData data;
    private Schema expected;

    public GenericDatumReader() {
        this(null, null, GenericData.get());
    }

    public GenericDatumReader(Schema schema) {
        this(schema, schema, GenericData.get());
    }

    public GenericDatumReader(Schema writer, Schema reader) {
        this(writer, reader, GenericData.get());
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public GenericDatumReader(Schema writer, Schema reader, GenericData data) {
        this.creatorResolver = null;
        this.actual = writer;
        this.expected = reader;
        this.data = data;
        this.creator = Thread.currentThread();
    }

    public GenericData getData() {
        return this.data;
    }

    public Schema getSchema() {
        return this.actual;
    }

    @Override // com.flurry.org.apache.avro.io.DatumReader
    public void setSchema(Schema writer) {
        this.actual = writer;
        if (this.expected == null) {
            this.expected = this.actual;
        }
        this.creatorResolver = null;
    }

    public Schema getExpected() {
        return this.expected;
    }

    public void setExpected(Schema reader) {
        this.expected = reader;
        this.creatorResolver = null;
    }

    protected final ResolvingDecoder getResolver(Schema actual, Schema expected) throws IOException {
        Thread currThread = Thread.currentThread();
        if (currThread == this.creator && this.creatorResolver != null) {
            return this.creatorResolver;
        }
        Map<Schema, ResolvingDecoder> cache = RESOLVER_CACHE.get().get(actual);
        if (cache == null) {
            cache = new WeakIdentityHashMap<>();
            RESOLVER_CACHE.get().put(actual, cache);
        }
        ResolvingDecoder resolver = cache.get(expected);
        if (resolver == null) {
            resolver = DecoderFactory.get().resolvingDecoder(Schema.applyAliases(actual, expected), expected, null);
            cache.put(expected, resolver);
        }
        if (currThread == this.creator) {
            this.creatorResolver = resolver;
            return resolver;
        }
        return resolver;
    }

    @Override // com.flurry.org.apache.avro.io.DatumReader
    public D read(D reuse, Decoder in) throws IOException {
        ResolvingDecoder resolver = getResolver(this.actual, this.expected);
        resolver.configure(in);
        D result = (D) read(reuse, this.expected, resolver);
        resolver.drain();
        return result;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* renamed from: com.flurry.org.apache.avro.generic.GenericDatumReader$2  reason: invalid class name */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public static /* synthetic */ class AnonymousClass2 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$avro$Schema$Type = new int[Schema.Type.values().length];

        static {
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.RECORD.ordinal()] = 1;
            } catch (NoSuchFieldError e) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.ENUM.ordinal()] = 2;
            } catch (NoSuchFieldError e2) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.ARRAY.ordinal()] = 3;
            } catch (NoSuchFieldError e3) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.MAP.ordinal()] = 4;
            } catch (NoSuchFieldError e4) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.UNION.ordinal()] = 5;
            } catch (NoSuchFieldError e5) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.FIXED.ordinal()] = 6;
            } catch (NoSuchFieldError e6) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.STRING.ordinal()] = 7;
            } catch (NoSuchFieldError e7) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.BYTES.ordinal()] = 8;
            } catch (NoSuchFieldError e8) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.INT.ordinal()] = 9;
            } catch (NoSuchFieldError e9) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.LONG.ordinal()] = 10;
            } catch (NoSuchFieldError e10) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.FLOAT.ordinal()] = 11;
            } catch (NoSuchFieldError e11) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.DOUBLE.ordinal()] = 12;
            } catch (NoSuchFieldError e12) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.BOOLEAN.ordinal()] = 13;
            } catch (NoSuchFieldError e13) {
            }
            try {
                $SwitchMap$org$apache$avro$Schema$Type[Schema.Type.NULL.ordinal()] = 14;
            } catch (NoSuchFieldError e14) {
            }
        }
    }

    protected Object read(Object old, Schema expected, ResolvingDecoder in) throws IOException {
        switch (AnonymousClass2.$SwitchMap$org$apache$avro$Schema$Type[expected.getType().ordinal()]) {
            case 1:
                return readRecord(old, expected, in);
            case 2:
                return readEnum(expected, in);
            case 3:
                return readArray(old, expected, in);
            case 4:
                return readMap(old, expected, in);
            case 5:
                return read(old, expected.getTypes().get(in.readIndex()), in);
            case 6:
                return readFixed(old, expected, in);
            case IabHelper.BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED /* 7 */:
                return readString(old, expected, in);
            case 8:
                return readBytes(old, in);
            case 9:
                return readInt(old, expected, in);
            case TapjoyVideoObject.BUTTON_MAX /* 10 */:
                return Long.valueOf(in.readLong());
            case 11:
                return Float.valueOf(in.readFloat());
            case 12:
                return Double.valueOf(in.readDouble());
            case 13:
                return Boolean.valueOf(in.readBoolean());
            case 14:
                in.readNull();
                return null;
            default:
                throw new AvroRuntimeException("Unknown type: " + expected);
        }
    }

    protected Object readRecord(Object old, Schema expected, ResolvingDecoder in) throws IOException {
        Object r = this.data.newRecord(old, expected);
        Object state = this.data.getRecordState(r, expected);
        Schema.Field[] arr$ = in.readFieldOrder();
        for (Schema.Field f : arr$) {
            int pos = f.pos();
            String name = f.name();
            Object oldDatum = old != null ? this.data.getField(r, name, pos, state) : null;
            this.data.setField(r, name, pos, read(oldDatum, f.schema(), in), state);
        }
        return r;
    }

    protected Object readEnum(Schema expected, Decoder in) throws IOException {
        return createEnum(expected.getEnumSymbols().get(in.readEnum()), expected);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public Object createEnum(String symbol, Schema schema) {
        return new GenericData.EnumSymbol(schema, symbol);
    }

    protected Object readArray(Object old, Schema expected, ResolvingDecoder in) throws IOException {
        Schema expectedType = expected.getElementType();
        long l = in.readArrayStart();
        long base = 0;
        if (l > 0) {
            Object array = newArray(old, (int) l, expected);
            do {
                for (long i = 0; i < l; i++) {
                    addToArray(array, base + i, read(peekArray(array), expectedType, in));
                }
                base += l;
                l = in.arrayNext();
            } while (l > 0);
            return array;
        }
        return newArray(old, 0, expected);
    }

    protected Object peekArray(Object array) {
        if (array instanceof GenericArray) {
            return ((GenericArray) array).peek();
        }
        return null;
    }

    protected void addToArray(Object array, long pos, Object e) {
        ((Collection) array).add(e);
    }

    protected Object readMap(Object old, Schema expected, ResolvingDecoder in) throws IOException {
        Schema eValue = expected.getValueType();
        long l = in.readMapStart();
        Object map = newMap(old, (int) l);
        if (l > 0) {
            do {
                for (int i = 0; i < l; i++) {
                    addToMap(map, readString(null, expected, in), read(null, eValue, in));
                }
                l = in.mapNext();
            } while (l > 0);
            return map;
        }
        return map;
    }

    protected void addToMap(Object map, Object key, Object value) {
        ((Map) map).put(key, value);
    }

    protected Object readFixed(Object old, Schema expected, Decoder in) throws IOException {
        GenericFixed fixed = (GenericFixed) this.data.createFixed(old, expected);
        in.readFixed(fixed.bytes(), 0, expected.getFixedSize());
        return fixed;
    }

    @Deprecated
    protected Object createFixed(Object old, Schema schema) {
        return this.data.createFixed(old, schema);
    }

    @Deprecated
    protected Object createFixed(Object old, byte[] bytes, Schema schema) {
        return this.data.createFixed(old, bytes, schema);
    }

    @Deprecated
    protected Object newRecord(Object old, Schema schema) {
        return this.data.newRecord(old, schema);
    }

    protected Object newArray(Object old, int size, Schema schema) {
        if (old instanceof Collection) {
            ((Collection) old).clear();
            return old;
        }
        return new GenericData.Array(size, schema);
    }

    protected Object newMap(Object old, int size) {
        if (old instanceof Map) {
            ((Map) old).clear();
            return old;
        }
        return new HashMap(size);
    }

    protected Object readString(Object old, Schema expected, Decoder in) throws IOException {
        GenericData genericData = this.data;
        GenericData genericData2 = this.data;
        return "String".equals(expected.getProp("avro.java.string")) ? in.readString() : readString(old, in);
    }

    /* JADX INFO: Access modifiers changed from: protected */
    public Object readString(Object old, Decoder in) throws IOException {
        return in.readString(old instanceof Utf8 ? (Utf8) old : null);
    }

    protected Object createString(String value) {
        return new Utf8(value);
    }

    protected Object readBytes(Object old, Decoder in) throws IOException {
        return in.readBytes(old instanceof ByteBuffer ? (ByteBuffer) old : null);
    }

    protected Object readInt(Object old, Schema expected, Decoder in) throws IOException {
        return Integer.valueOf(in.readInt());
    }

    protected Object createBytes(byte[] value) {
        return ByteBuffer.wrap(value);
    }

    public static void skip(Schema schema, Decoder in) throws IOException {
        switch (AnonymousClass2.$SwitchMap$org$apache$avro$Schema$Type[schema.getType().ordinal()]) {
            case 1:
                for (Schema.Field field : schema.getFields()) {
                    skip(field.schema(), in);
                }
                return;
            case 2:
                in.readInt();
                return;
            case 3:
                Schema elementType = schema.getElementType();
                long l = in.skipArray();
                while (l > 0) {
                    for (long i = 0; i < l; i++) {
                        skip(elementType, in);
                    }
                    l = in.skipArray();
                }
                return;
            case 4:
                Schema value = schema.getValueType();
                long l2 = in.skipMap();
                while (l2 > 0) {
                    for (long i2 = 0; i2 < l2; i2++) {
                        in.skipString();
                        skip(value, in);
                    }
                    l2 = in.skipMap();
                }
                return;
            case 5:
                skip(schema.getTypes().get(in.readIndex()), in);
                return;
            case 6:
                in.skipFixed(schema.getFixedSize());
                return;
            case IabHelper.BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED /* 7 */:
                in.skipString();
                return;
            case 8:
                in.skipBytes();
                return;
            case 9:
                in.readInt();
                return;
            case TapjoyVideoObject.BUTTON_MAX /* 10 */:
                in.readLong();
                return;
            case 11:
                in.readFloat();
                return;
            case 12:
                in.readDouble();
                return;
            case 13:
                in.readBoolean();
                return;
            case 14:
                return;
            default:
                throw new RuntimeException("Unknown type: " + schema);
        }
    }
}
