package com.flurry.org.apache.avro.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.xerial.snappy.Snappy;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
class SnappyCodec extends Codec {
    private CRC32 crc32;

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    static class Option extends CodecFactory {
        @Override // com.flurry.org.apache.avro.file.CodecFactory
        protected Codec createInstance() {
            return new SnappyCodec();
        }
    }

    private SnappyCodec() {
        this.crc32 = new CRC32();
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // com.flurry.org.apache.avro.file.Codec
    public String getName() {
        return DataFileConstants.SNAPPY_CODEC;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // com.flurry.org.apache.avro.file.Codec
    public ByteBuffer compress(ByteBuffer in) throws IOException {
        ByteBuffer out = ByteBuffer.allocate(Snappy.maxCompressedLength(in.remaining()) + 4);
        int size = Snappy.compress(in.array(), in.position(), in.remaining(), out.array(), 0);
        this.crc32.reset();
        this.crc32.update(in.array(), in.position(), in.remaining());
        out.putInt(size, (int) this.crc32.getValue());
        out.limit(size + 4);
        return out;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // com.flurry.org.apache.avro.file.Codec
    public ByteBuffer decompress(ByteBuffer in) throws IOException {
        ByteBuffer out = ByteBuffer.allocate(Snappy.uncompressedLength(in.array(), in.position(), in.remaining() - 4));
        int size = Snappy.uncompress(in.array(), in.position(), in.remaining() - 4, out.array(), 0);
        out.limit(size);
        this.crc32.reset();
        this.crc32.update(out.array(), 0, size);
        if (in.getInt(in.limit() - 4) != ((int) this.crc32.getValue())) {
            throw new IOException("Checksum failure");
        }
        return out;
    }

    @Override // com.flurry.org.apache.avro.file.Codec
    public int hashCode() {
        return getName().hashCode();
    }

    @Override // com.flurry.org.apache.avro.file.Codec
    public boolean equals(Object obj) {
        return this == obj || getClass() == obj.getClass();
    }
}
