package com.flurry.org.apache.avro.file;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class SeekableFileInput extends FileInputStream implements SeekableInput {
    public SeekableFileInput(File file) throws IOException {
        super(file);
    }

    public SeekableFileInput(FileDescriptor fd) throws IOException {
        super(fd);
    }

    @Override // com.flurry.org.apache.avro.file.SeekableInput
    public void seek(long p) throws IOException {
        getChannel().position(p);
    }

    @Override // com.flurry.org.apache.avro.file.SeekableInput
    public long tell() throws IOException {
        return getChannel().position();
    }

    @Override // com.flurry.org.apache.avro.file.SeekableInput
    public long length() throws IOException {
        return getChannel().size();
    }
}
