package com.flurry.org.apache.avro.file;

import java.io.IOException;
import java.nio.ByteBuffer;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
final class NullCodec extends Codec {
    private static final NullCodec INSTANCE = new NullCodec();
    public static final CodecFactory OPTION = new Option();

    NullCodec() {
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    static class Option extends CodecFactory {
        Option() {
        }

        @Override // com.flurry.org.apache.avro.file.CodecFactory
        protected Codec createInstance() {
            return NullCodec.INSTANCE;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // com.flurry.org.apache.avro.file.Codec
    public String getName() {
        return DataFileConstants.NULL_CODEC;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // com.flurry.org.apache.avro.file.Codec
    public ByteBuffer compress(ByteBuffer buffer) throws IOException {
        return buffer;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // com.flurry.org.apache.avro.file.Codec
    public ByteBuffer decompress(ByteBuffer data) throws IOException {
        return data;
    }

    @Override // com.flurry.org.apache.avro.file.Codec
    public boolean equals(Object other) {
        return this == other || getClass() == other.getClass();
    }

    @Override // com.flurry.org.apache.avro.file.Codec
    public int hashCode() {
        return 2;
    }
}
