package com.flurry.org.apache.avro.file;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
class LengthLimitedInputStream extends FilterInputStream {
    private long remaining;

    protected LengthLimitedInputStream(InputStream in, long maxLength) {
        super(in);
        this.remaining = maxLength;
    }

    @Override // java.io.FilterInputStream, java.io.InputStream
    public int read() throws IOException {
        if (this.remaining > 0) {
            int v = super.read();
            if (v != -1) {
                this.remaining--;
                return v;
            }
            return v;
        }
        return -1;
    }

    @Override // java.io.FilterInputStream, java.io.InputStream
    public int read(byte[] b) throws IOException {
        return read(b, 0, b.length);
    }

    private int remainingInt() {
        return (int) Math.min(this.remaining, 2147483647L);
    }

    @Override // java.io.FilterInputStream, java.io.InputStream
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.remaining == 0) {
            return -1;
        }
        if (len > this.remaining) {
            len = remainingInt();
        }
        int v = super.read(b, off, len);
        if (v != -1) {
            this.remaining -= v;
            return v;
        }
        return v;
    }

    @Override // java.io.FilterInputStream, java.io.InputStream
    public int available() throws IOException {
        return Math.min(super.available(), remainingInt());
    }

    @Override // java.io.FilterInputStream, java.io.InputStream
    public long skip(long n) throws IOException {
        long v = super.skip(Math.min(this.remaining, n));
        this.remaining -= v;
        return v;
    }
}
