package com.flurry.org.apache.avro.file;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
class DeflateCodec extends Codec {
    private int compressionLevel;
    private Deflater deflater;
    private Inflater inflater;
    private boolean nowrap = true;
    private ByteArrayOutputStream outputBuffer;

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    static class Option extends CodecFactory {
        private int compressionLevel;

        /* JADX INFO: Access modifiers changed from: package-private */
        public Option(int compressionLevel) {
            this.compressionLevel = compressionLevel;
        }

        @Override // com.flurry.org.apache.avro.file.CodecFactory
        protected Codec createInstance() {
            return new DeflateCodec(this.compressionLevel);
        }
    }

    public DeflateCodec(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // com.flurry.org.apache.avro.file.Codec
    public String getName() {
        return DataFileConstants.DEFLATE_CODEC;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // com.flurry.org.apache.avro.file.Codec
    public ByteBuffer compress(ByteBuffer data) throws IOException {
        ByteArrayOutputStream baos = getOutputBuffer(data.remaining());
        DeflaterOutputStream ios = new DeflaterOutputStream(baos, getDeflater());
        writeAndClose(data, ios);
        ByteBuffer result = ByteBuffer.wrap(baos.toByteArray());
        return result;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    @Override // com.flurry.org.apache.avro.file.Codec
    public ByteBuffer decompress(ByteBuffer data) throws IOException {
        ByteArrayOutputStream baos = getOutputBuffer(data.remaining());
        InflaterOutputStream ios = new InflaterOutputStream(baos, getInflater());
        writeAndClose(data, ios);
        ByteBuffer result = ByteBuffer.wrap(baos.toByteArray());
        return result;
    }

    private void writeAndClose(ByteBuffer data, OutputStream to) throws IOException {
        byte[] input = data.array();
        int offset = data.arrayOffset() + data.position();
        int length = data.remaining();
        try {
            to.write(input, offset, length);
        } finally {
            to.close();
        }
    }

    private Inflater getInflater() {
        if (this.inflater == null) {
            this.inflater = new Inflater(this.nowrap);
        }
        this.inflater.reset();
        return this.inflater;
    }

    private Deflater getDeflater() {
        if (this.deflater == null) {
            this.deflater = new Deflater(this.compressionLevel, this.nowrap);
        }
        this.deflater.reset();
        return this.deflater;
    }

    private ByteArrayOutputStream getOutputBuffer(int suggestedLength) {
        if (this.outputBuffer == null) {
            this.outputBuffer = new ByteArrayOutputStream(suggestedLength);
        }
        this.outputBuffer.reset();
        return this.outputBuffer;
    }

    @Override // com.flurry.org.apache.avro.file.Codec
    public int hashCode() {
        return this.nowrap ? 0 : 1;
    }

    @Override // com.flurry.org.apache.avro.file.Codec
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        DeflateCodec other = (DeflateCodec) obj;
        return this.nowrap == other.nowrap;
    }

    @Override // com.flurry.org.apache.avro.file.Codec
    public String toString() {
        return getName() + "-" + this.compressionLevel;
    }
}
