package com.flurry.org.apache.avro.file;

import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.file.DataFileReader;
import com.flurry.org.apache.avro.io.BinaryDecoder;
import com.flurry.org.apache.avro.io.DatumReader;
import com.flurry.org.apache.avro.io.DecoderFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class DataFileReader12<D> implements FileReader<D>, Closeable {
    private static final String CODEC = "codec";
    private static final String COUNT = "count";
    private static final long FOOTER_BLOCK = -1;
    static final byte[] MAGIC = {79, 98, 106, 0};
    private static final String NULL_CODEC = "null";
    private static final String SCHEMA = "schema";
    private static final String SYNC = "sync";
    private static final int SYNC_INTERVAL = 16000;
    private static final int SYNC_SIZE = 16;
    private static final byte VERSION = 0;
    private long blockCount;
    private long blockStart;
    private long count;
    private DataFileReader.SeekableInputStream in;
    private D peek;
    private DatumReader<D> reader;
    private Schema schema;
    private byte[] sync;
    private BinaryDecoder vin;
    private Map<String, byte[]> meta = new HashMap();
    private byte[] syncBuffer = new byte[16];

    public DataFileReader12(SeekableInput sin, DatumReader<D> reader) throws IOException {
        String codec;
        this.sync = new byte[16];
        this.in = new DataFileReader.SeekableInputStream(sin);
        byte[] magic = new byte[4];
        this.in.read(magic);
        if (!Arrays.equals(MAGIC, magic)) {
            throw new IOException("Not a data file.");
        }
        long length = this.in.length();
        this.in.seek(length - 4);
        int footerSize = (this.in.read() << 24) + (this.in.read() << 16) + (this.in.read() << 8) + this.in.read();
        seek(length - footerSize);
        long l = this.vin.readMapStart();
        if (l > 0) {
            do {
                for (long i = 0; i < l; i++) {
                    String key = this.vin.readString(null).toString();
                    ByteBuffer value = this.vin.readBytes(null);
                    byte[] bb = new byte[value.remaining()];
                    value.get(bb);
                    this.meta.put(key, bb);
                }
                l = this.vin.mapNext();
            } while (l != 0);
            this.sync = getMeta(SYNC);
            this.count = getMetaLong(COUNT);
            codec = getMetaString(CODEC);
            if (codec == null && !codec.equals("null")) {
                throw new IOException("Unknown codec: " + codec);
            }
            this.schema = Schema.parse(getMetaString(SCHEMA));
            this.reader = reader;
            reader.setSchema(this.schema);
            seek(MAGIC.length);
        }
        this.sync = getMeta(SYNC);
        this.count = getMetaLong(COUNT);
        codec = getMetaString(CODEC);
        if (codec == null) {
        }
        this.schema = Schema.parse(getMetaString(SCHEMA));
        this.reader = reader;
        reader.setSchema(this.schema);
        seek(MAGIC.length);
    }

    public synchronized byte[] getMeta(String key) {
        return this.meta.get(key);
    }

    public synchronized String getMetaString(String key) {
        String str;
        byte[] value = getMeta(key);
        if (value == null) {
            str = null;
        } else {
            try {
                str = new String(value, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return str;
    }

    public synchronized long getMetaLong(String key) {
        return Long.parseLong(getMetaString(key));
    }

    @Override // com.flurry.org.apache.avro.file.FileReader
    public Schema getSchema() {
        return this.schema;
    }

    @Override // java.lang.Iterable
    public Iterator<D> iterator() {
        return this;
    }

    @Override // java.util.Iterator
    public boolean hasNext() {
        if (this.peek == null && this.blockCount == 0) {
            this.peek = next();
            return this.peek != null;
        }
        return true;
    }

    @Override // java.util.Iterator
    public D next() {
        if (this.peek != null) {
            D result = this.peek;
            this.peek = null;
            return result;
        }
        try {
            D result2 = next(null);
            return result2;
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override // java.util.Iterator
    public void remove() {
        throw new UnsupportedOperationException();
    }

    /* JADX WARN: Code restructure failed: missing block: B:18:0x0043, code lost:
        r4.blockCount--;
        r0 = r4.reader.read(r5, r4.vin);
     */
    @Override // com.flurry.org.apache.avro.file.FileReader
    /*
        Code decompiled incorrectly, please refer to instructions dump.
        To view partially-correct code enable 'Show inconsistent code' option in preferences
    */
    public synchronized D next(D r5) throws java.io.IOException {
        /*
            r4 = this;
            monitor-enter(r4)
        L1:
            long r0 = r4.blockCount     // Catch: java.lang.Throwable -> L40
            r2 = 0
            int r0 = (r0 > r2 ? 1 : (r0 == r2 ? 0 : -1))
            if (r0 != 0) goto L43
            com.flurry.org.apache.avro.file.DataFileReader$SeekableInputStream r0 = r4.in     // Catch: java.lang.Throwable -> L40
            long r0 = r0.tell()     // Catch: java.lang.Throwable -> L40
            com.flurry.org.apache.avro.file.DataFileReader$SeekableInputStream r2 = r4.in     // Catch: java.lang.Throwable -> L40
            long r2 = r2.length()     // Catch: java.lang.Throwable -> L40
            int r0 = (r0 > r2 ? 1 : (r0 == r2 ? 0 : -1))
            if (r0 != 0) goto L1c
            r0 = 0
        L1a:
            monitor-exit(r4)
            return r0
        L1c:
            r4.skipSync()     // Catch: java.lang.Throwable -> L40
            com.flurry.org.apache.avro.io.BinaryDecoder r0 = r4.vin     // Catch: java.lang.Throwable -> L40
            long r0 = r0.readLong()     // Catch: java.lang.Throwable -> L40
            r4.blockCount = r0     // Catch: java.lang.Throwable -> L40
            long r0 = r4.blockCount     // Catch: java.lang.Throwable -> L40
            r2 = -1
            int r0 = (r0 > r2 ? 1 : (r0 == r2 ? 0 : -1))
            if (r0 != 0) goto L1
            com.flurry.org.apache.avro.io.BinaryDecoder r0 = r4.vin     // Catch: java.lang.Throwable -> L40
            long r0 = r0.readLong()     // Catch: java.lang.Throwable -> L40
            com.flurry.org.apache.avro.file.DataFileReader$SeekableInputStream r2 = r4.in     // Catch: java.lang.Throwable -> L40
            long r2 = r2.tell()     // Catch: java.lang.Throwable -> L40
            long r0 = r0 + r2
            r4.seek(r0)     // Catch: java.lang.Throwable -> L40
            goto L1
        L40:
            r0 = move-exception
            monitor-exit(r4)
            throw r0
        L43:
            long r0 = r4.blockCount     // Catch: java.lang.Throwable -> L40
            r2 = 1
            long r0 = r0 - r2
            r4.blockCount = r0     // Catch: java.lang.Throwable -> L40
            com.flurry.org.apache.avro.io.DatumReader<D> r0 = r4.reader     // Catch: java.lang.Throwable -> L40
            com.flurry.org.apache.avro.io.BinaryDecoder r1 = r4.vin     // Catch: java.lang.Throwable -> L40
            java.lang.Object r0 = r0.read(r5, r1)     // Catch: java.lang.Throwable -> L40
            goto L1a
        */
        throw new UnsupportedOperationException("Method not decompiled: com.flurry.org.apache.avro.file.DataFileReader12.next(java.lang.Object):java.lang.Object");
    }

    private void skipSync() throws IOException {
        this.vin.readFixed(this.syncBuffer);
        if (!Arrays.equals(this.syncBuffer, this.sync)) {
            throw new IOException("Invalid sync!");
        }
    }

    public synchronized void seek(long position) throws IOException {
        this.in.seek(position);
        this.blockCount = 0L;
        this.blockStart = position;
        this.vin = DecoderFactory.get().binaryDecoder(this.in, this.vin);
    }

    @Override // com.flurry.org.apache.avro.file.FileReader
    public synchronized void sync(long position) throws IOException {
        if (this.in.tell() + 16 >= this.in.length()) {
            seek(this.in.length());
        } else {
            this.in.seek(position);
            this.vin.readFixed(this.syncBuffer);
            int i = 0;
            while (true) {
                if (this.in.tell() < this.in.length()) {
                    int j = 0;
                    while (j < this.sync.length && this.sync[j] == this.syncBuffer[(i + j) % this.sync.length]) {
                        j++;
                    }
                    if (j == this.sync.length) {
                        seek(this.in.tell() - 16);
                        break;
                    } else {
                        this.syncBuffer[i % this.sync.length] = (byte) this.in.read();
                        i++;
                    }
                } else {
                    seek(this.in.length());
                    break;
                }
            }
        }
    }

    @Override // com.flurry.org.apache.avro.file.FileReader
    public boolean pastSync(long position) throws IOException {
        return this.blockStart >= 16 + position || this.blockStart >= this.in.length();
    }

    @Override // com.flurry.org.apache.avro.file.FileReader
    public long tell() throws IOException {
        return this.in.tell();
    }

    @Override // java.io.Closeable, java.lang.AutoCloseable
    public synchronized void close() throws IOException {
        this.in.close();
    }
}
