package com.flurry.org.apache.avro.file;

import com.flurry.org.apache.avro.AvroRuntimeException;
import com.flurry.org.apache.avro.file.DeflateCodec;
import com.flurry.org.apache.avro.file.SnappyCodec;
import java.util.HashMap;
import java.util.Map;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public abstract class CodecFactory {
    private static final int DEFAULT_DEFLATE_LEVEL = -1;
    private static final Map<String, CodecFactory> REGISTERED = new HashMap();

    /* JADX INFO: Access modifiers changed from: protected */
    public abstract Codec createInstance();

    public static CodecFactory nullCodec() {
        return NullCodec.OPTION;
    }

    public static CodecFactory deflateCodec(int compressionLevel) {
        return new DeflateCodec.Option(compressionLevel);
    }

    public static CodecFactory snappyCodec() {
        return new SnappyCodec.Option();
    }

    static {
        addCodec(DataFileConstants.NULL_CODEC, nullCodec());
        addCodec(DataFileConstants.DEFLATE_CODEC, deflateCodec(-1));
        addCodec(DataFileConstants.SNAPPY_CODEC, snappyCodec());
    }

    public static CodecFactory fromString(String s) {
        CodecFactory o = REGISTERED.get(s);
        if (o == null) {
            throw new AvroRuntimeException("Unrecognized codec: " + s);
        }
        return o;
    }

    public static CodecFactory addCodec(String name, CodecFactory c) {
        return REGISTERED.put(name, c);
    }

    public String toString() {
        Codec instance = createInstance();
        return instance.toString();
    }
}
