package com.flurry.org.apache.avro.data;

import com.flurry.org.apache.avro.AvroRuntimeException;
import com.flurry.org.apache.avro.Schema;
import com.flurry.org.apache.avro.io.DatumReader;
import com.flurry.org.apache.avro.io.DatumWriter;
import com.flurry.org.apache.avro.io.Decoder;
import com.flurry.org.apache.avro.io.DecoderFactory;
import com.flurry.org.apache.avro.io.Encoder;
import com.flurry.org.apache.avro.io.ResolvingDecoder;
import com.flurry.org.codehaus.jackson.JsonNode;
import com.flurry.org.codehaus.jackson.JsonToken;
import com.flurry.org.codehaus.jackson.node.ArrayNode;
import com.flurry.org.codehaus.jackson.node.BooleanNode;
import com.flurry.org.codehaus.jackson.node.DoubleNode;
import com.flurry.org.codehaus.jackson.node.JsonNodeFactory;
import com.flurry.org.codehaus.jackson.node.LongNode;
import com.flurry.org.codehaus.jackson.node.NullNode;
import com.flurry.org.codehaus.jackson.node.ObjectNode;
import com.flurry.org.codehaus.jackson.node.TextNode;
import com.prime31.util.IabHelper;
import java.io.IOException;
import java.util.Iterator;

/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public class Json {
    public static final Schema SCHEMA;

    /* JADX INFO: Access modifiers changed from: private */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public enum JsonType {
        LONG,
        DOUBLE,
        STRING,
        BOOLEAN,
        NULL,
        ARRAY,
        OBJECT
    }

    private Json() {
    }

    static {
        try {
            SCHEMA = Schema.parse(Json.class.getResourceAsStream("/com/flurry/org/apache/avro/data/Json.avsc"));
        } catch (IOException e) {
            throw new AvroRuntimeException(e);
        }
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public static class Writer implements DatumWriter<JsonNode> {
        @Override // com.flurry.org.apache.avro.io.DatumWriter
        public void setSchema(Schema schema) {
            if (!Json.SCHEMA.equals(schema)) {
                throw new RuntimeException("Not the Json schema: " + schema);
            }
        }

        @Override // com.flurry.org.apache.avro.io.DatumWriter
        public void write(JsonNode datum, Encoder out) throws IOException {
            Json.write(datum, out);
        }
    }

    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public static class Reader implements DatumReader<JsonNode> {
        private ResolvingDecoder resolver;
        private Schema written;

        @Override // com.flurry.org.apache.avro.io.DatumReader
        public void setSchema(Schema schema) {
            if (Json.SCHEMA.equals(this.written)) {
                schema = null;
            }
            this.written = schema;
        }

        @Override // com.flurry.org.apache.avro.io.DatumReader
        public JsonNode read(JsonNode reuse, Decoder in) throws IOException {
            if (this.written == null) {
                return Json.read(in);
            }
            if (this.resolver == null) {
                this.resolver = DecoderFactory.get().resolvingDecoder(this.written, Json.SCHEMA, null);
            }
            this.resolver.configure(in);
            JsonNode read = Json.read(this.resolver);
            this.resolver.drain();
            return read;
        }
    }

    public static void write(JsonNode node, Encoder out) throws IOException {
        switch (AnonymousClass1.$SwitchMap$org$codehaus$jackson$JsonToken[node.asToken().ordinal()]) {
            case 1:
                out.writeIndex(JsonType.LONG.ordinal());
                out.writeLong(node.getLongValue());
                return;
            case 2:
                out.writeIndex(JsonType.DOUBLE.ordinal());
                out.writeDouble(node.getDoubleValue());
                return;
            case 3:
                out.writeIndex(JsonType.STRING.ordinal());
                out.writeString(node.getTextValue());
                return;
            case 4:
                out.writeIndex(JsonType.BOOLEAN.ordinal());
                out.writeBoolean(true);
                return;
            case 5:
                out.writeIndex(JsonType.BOOLEAN.ordinal());
                out.writeBoolean(false);
                return;
            case 6:
                out.writeIndex(JsonType.NULL.ordinal());
                out.writeNull();
                return;
            case IabHelper.BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED /* 7 */:
                out.writeIndex(JsonType.ARRAY.ordinal());
                out.writeArrayStart();
                out.setItemCount(node.size());
                Iterator i$ = node.iterator();
                while (i$.hasNext()) {
                    JsonNode element = i$.next();
                    out.startItem();
                    write(element, out);
                }
                out.writeArrayEnd();
                return;
            case 8:
                out.writeIndex(JsonType.OBJECT.ordinal());
                out.writeMapStart();
                out.setItemCount(node.size());
                Iterator<String> i = node.getFieldNames();
                while (i.hasNext()) {
                    out.startItem();
                    String name = i.next();
                    out.writeString(name);
                    write(node.get(name), out);
                }
                out.writeMapEnd();
                return;
            default:
                throw new AvroRuntimeException(node.asToken() + " unexpected: " + node);
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    /* renamed from: com.flurry.org.apache.avro.data.Json$1  reason: invalid class name */
    /* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
    public static /* synthetic */ class AnonymousClass1 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$avro$data$Json$JsonType = new int[JsonType.values().length];
        static final /* synthetic */ int[] $SwitchMap$org$codehaus$jackson$JsonToken;

        static {
            try {
                $SwitchMap$org$apache$avro$data$Json$JsonType[JsonType.LONG.ordinal()] = 1;
            } catch (NoSuchFieldError e) {
            }
            try {
                $SwitchMap$org$apache$avro$data$Json$JsonType[JsonType.DOUBLE.ordinal()] = 2;
            } catch (NoSuchFieldError e2) {
            }
            try {
                $SwitchMap$org$apache$avro$data$Json$JsonType[JsonType.STRING.ordinal()] = 3;
            } catch (NoSuchFieldError e3) {
            }
            try {
                $SwitchMap$org$apache$avro$data$Json$JsonType[JsonType.BOOLEAN.ordinal()] = 4;
            } catch (NoSuchFieldError e4) {
            }
            try {
                $SwitchMap$org$apache$avro$data$Json$JsonType[JsonType.NULL.ordinal()] = 5;
            } catch (NoSuchFieldError e5) {
            }
            try {
                $SwitchMap$org$apache$avro$data$Json$JsonType[JsonType.ARRAY.ordinal()] = 6;
            } catch (NoSuchFieldError e6) {
            }
            try {
                $SwitchMap$org$apache$avro$data$Json$JsonType[JsonType.OBJECT.ordinal()] = 7;
            } catch (NoSuchFieldError e7) {
            }
            $SwitchMap$org$codehaus$jackson$JsonToken = new int[JsonToken.values().length];
            try {
                $SwitchMap$org$codehaus$jackson$JsonToken[JsonToken.VALUE_NUMBER_INT.ordinal()] = 1;
            } catch (NoSuchFieldError e8) {
            }
            try {
                $SwitchMap$org$codehaus$jackson$JsonToken[JsonToken.VALUE_NUMBER_FLOAT.ordinal()] = 2;
            } catch (NoSuchFieldError e9) {
            }
            try {
                $SwitchMap$org$codehaus$jackson$JsonToken[JsonToken.VALUE_STRING.ordinal()] = 3;
            } catch (NoSuchFieldError e10) {
            }
            try {
                $SwitchMap$org$codehaus$jackson$JsonToken[JsonToken.VALUE_TRUE.ordinal()] = 4;
            } catch (NoSuchFieldError e11) {
            }
            try {
                $SwitchMap$org$codehaus$jackson$JsonToken[JsonToken.VALUE_FALSE.ordinal()] = 5;
            } catch (NoSuchFieldError e12) {
            }
            try {
                $SwitchMap$org$codehaus$jackson$JsonToken[JsonToken.VALUE_NULL.ordinal()] = 6;
            } catch (NoSuchFieldError e13) {
            }
            try {
                $SwitchMap$org$codehaus$jackson$JsonToken[JsonToken.START_ARRAY.ordinal()] = 7;
            } catch (NoSuchFieldError e14) {
            }
            try {
                $SwitchMap$org$codehaus$jackson$JsonToken[JsonToken.START_OBJECT.ordinal()] = 8;
            } catch (NoSuchFieldError e15) {
            }
        }
    }

    public static JsonNode read(Decoder in) throws IOException {
        switch (AnonymousClass1.$SwitchMap$org$apache$avro$data$Json$JsonType[JsonType.values()[in.readIndex()].ordinal()]) {
            case 1:
                return new LongNode(in.readLong());
            case 2:
                return new DoubleNode(in.readDouble());
            case 3:
                return new TextNode(in.readString());
            case 4:
                return in.readBoolean() ? BooleanNode.TRUE : BooleanNode.FALSE;
            case 5:
                in.readNull();
                return NullNode.getInstance();
            case 6:
                ArrayNode array = JsonNodeFactory.instance.arrayNode();
                long l = in.readArrayStart();
                while (l > 0) {
                    for (long i = 0; i < l; i++) {
                        array.add(read(in));
                    }
                    l = in.arrayNext();
                }
                return array;
            case IabHelper.BILLING_RESPONSE_RESULT_ITEM_ALREADY_OWNED /* 7 */:
                ObjectNode object = JsonNodeFactory.instance.objectNode();
                long l2 = in.readMapStart();
                while (l2 > 0) {
                    for (long i2 = 0; i2 < l2; i2++) {
                        object.put(in.readString(), read(in));
                    }
                    l2 = in.mapNext();
                }
                return object;
            default:
                throw new AvroRuntimeException("Unexpected Json node type");
        }
    }
}
