package com.flurry.android;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.json.JSONException;
import org.json.JSONObject;

/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public final class y {
    y() {
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static void a(int i, String str, String str2) {
        if (str2.length() > 4000) {
            str2.substring(0, 4000);
            a(i, str, str2.substring(4000));
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static String a(String str) {
        return str == null ? "" : str.length() > 255 ? str.substring(0, 255) : str;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static String b(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            bc.d("FlurryAgent", "Cannot encode '" + str + "'");
            return "";
        }
    }

    private static String g(String str) {
        try {
            return URLDecoder.decode(str, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            bc.d("FlurryAgent", "Cannot decode '" + str + "'");
            return "";
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static void a(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            } catch (Throwable th) {
            }
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static byte[] c(String str) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(str.getBytes(), 0, str.length());
            return messageDigest.digest();
        } catch (NoSuchAlgorithmException e) {
            bc.b("FlurryAgent", "Unsupported SHA1: " + e.getMessage());
            return null;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static boolean a(long j) {
        if (System.currentTimeMillis() > j) {
            return false;
        }
        return true;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static Map<String, String> d(String str) {
        HashMap hashMap;
        String string;
        HashMap hashMap2;
        HashMap hashMap3 = null;
        try {
            JSONObject jSONObject = new JSONObject(str);
            Iterator<String> keys = jSONObject.keys();
            while (keys.hasNext()) {
                try {
                    String next = keys.next();
                    try {
                        string = jSONObject.getString(next);
                        hashMap2 = new HashMap();
                    } catch (JSONException e) {
                    }
                    try {
                        hashMap2.put(next, string);
                        hashMap3 = hashMap2;
                    } catch (JSONException e2) {
                        hashMap3 = hashMap2;
                        bc.a("FlurryAgent", "Cannot iterate over key: " + next);
                        return hashMap3;
                    }
                } catch (JSONException e3) {
                    hashMap = hashMap3;
                    bc.a("FlurryAgent", "Cannot convert json to map for: " + str);
                    return hashMap;
                }
            }
            return hashMap3;
        } catch (JSONException e4) {
            hashMap = null;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static boolean a(Context context, String str) {
        Intent data = new Intent("android.intent.action.VIEW").setData(Uri.parse(str));
        if (a(context, data)) {
            bc.a("FlurryAgent", "Launching intent for " + str);
            context.startActivity(data);
            return true;
        }
        return false;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static boolean a(Context context, Intent intent) {
        return context.getPackageManager().queryIntentActivities(intent, 65536).size() > 0;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static HttpResponse a(ax axVar, String str, int i, int i2, boolean z) {
        try {
            HttpGet httpGet = new HttpGet(str);
            BasicHttpParams basicHttpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout(basicHttpParams, 10000);
            HttpConnectionParams.setSoTimeout(basicHttpParams, 15000);
            basicHttpParams.setParameter("http.protocol.handle-redirects", Boolean.valueOf(z));
            return axVar.a(basicHttpParams).execute(httpGet);
        } catch (UnknownHostException e) {
            bc.a("FlurryAgent", "Unknown host: " + e.getMessage());
            return null;
        } catch (Exception e2) {
            bc.a("FlurryAgent", "Failed to hit URL: " + str, e2);
            return null;
        }
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static bb a(be beVar, String str) {
        long b = beVar.b();
        beVar.d();
        bb bbVar = new bb(b, str);
        beVar.a(bbVar);
        return bbVar;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static int a(Context context, int i) {
        return Math.round(i / context.getResources().getDisplayMetrics().density);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static int b(Context context, int i) {
        return Math.round(context.getResources().getDisplayMetrics().density * i);
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static int a(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static int b(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static String e(String str) {
        return str.replace("'", "\\'");
    }

    /* JADX INFO: Access modifiers changed from: package-private */
    public static Map<String, String> f(String str) {
        HashMap hashMap = new HashMap();
        if (str != null) {
            for (String str2 : str.split("&")) {
                String[] split = str2.split("=");
                if (!split[0].equals("event")) {
                    hashMap.put(g(split[0]), g(split[1]));
                }
            }
        }
        return hashMap;
    }
}
