package com.flurry.android;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import com.google.ads.AdSize;
import com.google.ads.AdView;
import com.google.ads.InterstitialAd;

/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public final class x extends AdNetworkView {
    private static boolean e;
    private InterstitialAd f;

    /* JADX INFO: Access modifiers changed from: package-private */
    public x(Context context, be beVar, bb bbVar, AdCreative adCreative) {
        super(context, beVar, bbVar, adCreative);
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        } catch (PackageManager.NameNotFoundException e2) {
            Log.d("FlurryAgent", "Cannot find manifest for app");
        }
        Bundle bundle = applicationInfo.metaData;
        sAdNetworkApiKey = bundle.getString("com.flurry.admob.MY_AD_UNIT_ID");
        e = bundle.getBoolean("com.flurry.admob.test");
        if (sAdNetworkApiKey == null) {
            Log.d("FlurryAgent", "com.flurry.admob.MY_AD_UNIT_ID not set in manifest");
        }
        setFocusable(true);
    }

    @Override // com.flurry.android.o
    public final void initLayout(Context context) {
        AdSize adSize;
        if (this.fAdCreative.getFormat().equals(AdCreative.kFormatTakeover)) {
            this.f = new InterstitialAd((Activity) context, sAdNetworkApiKey);
            this.f.setAdListener(new i(this));
            com.google.ads.AdRequest adRequest = new com.google.ads.AdRequest();
            if (e) {
                Log.d("FlurryAgent", "Admob AdView set to Test Mode.");
                adRequest.addTestDevice(com.google.ads.AdRequest.TEST_EMULATOR);
            }
            this.f.loadAd(adRequest);
            return;
        }
        int height = this.fAdCreative.getHeight();
        int width = this.fAdCreative.getWidth();
        if (width >= AdSize.IAB_LEADERBOARD.getWidth() && height >= AdSize.IAB_LEADERBOARD.getHeight()) {
            Log.d("FlurryAgent", "Determined Admob AdSize as IAB_LEADERBOARD");
            adSize = AdSize.IAB_LEADERBOARD;
        } else if (width >= AdSize.IAB_BANNER.getWidth() && height >= AdSize.IAB_BANNER.getHeight()) {
            Log.d("FlurryAgent", "Determined Admob AdSize as IAB_BANNER");
            adSize = AdSize.IAB_BANNER;
        } else if (width >= AdSize.BANNER.getWidth() && height >= AdSize.BANNER.getHeight()) {
            Log.d("FlurryAgent", "Determined Admob AdSize as BANNER");
            adSize = AdSize.BANNER;
        } else if (width < AdSize.IAB_MRECT.getWidth() || height < AdSize.IAB_MRECT.getHeight()) {
            Log.d("FlurryAgent", "Could not find Admob AdSize that matches size");
            adSize = null;
        } else {
            Log.d("FlurryAgent", "Determined Admob AdSize as IAB_MRECT");
            adSize = AdSize.IAB_MRECT;
        }
        if (adSize != null) {
            AdView adView = new AdView((Activity) context, adSize, sAdNetworkApiKey);
            adView.setAdListener(new ay(this));
            addView(adView);
            com.google.ads.AdRequest adRequest2 = new com.google.ads.AdRequest();
            if (e) {
                Log.d("FlurryAgent", "Admob AdView set to Test Mode.");
                adRequest2.addTestDevice(com.google.ads.AdRequest.TEST_EMULATOR);
            }
            adView.loadAd(adRequest2);
            return;
        }
        Log.d("FlurryAgent", "**********Could not load Admob Ad");
    }
}
