package com.flurry.android;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.flurry.org.codehaus.jackson.util.MinimalPrettyPrinter;
import com.millennialmedia.android.MMAdView;
import java.util.Hashtable;

/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public final class ag extends AdNetworkView {
    private boolean e;

    /* JADX INFO: Access modifiers changed from: package-private */
    public ag(Context context, be beVar, bb bbVar, AdCreative adCreative) {
        super(context, beVar, bbVar, adCreative);
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        } catch (PackageManager.NameNotFoundException e) {
            Log.d("FlurryAgent", "Cannot find manifest for app");
        }
        String string = applicationInfo.metaData.getString("com.flurry.millennial.MYAPID");
        sAdNetworkApiKey = string;
        if (string == null) {
            Log.d("FlurryAgent", "com.flurry.millennial.MYAPID not set in manifest");
        }
        setFocusable(true);
    }

    @Override // com.flurry.android.o
    public final void initLayout(Context context) {
        String str = null;
        if (this.fAdCreative.getFormat().equals(AdCreative.kFormatTakeover)) {
            MMAdView mMAdView = new MMAdView((Activity) context, sAdNetworkApiKey, "MMFullScreenAdTransition", true, (Hashtable) null);
            mMAdView.setId(1897808290);
            mMAdView.setListener(new as(this));
            mMAdView.fetch();
            this.e = mMAdView.display();
            if (!this.e) {
                Log.d("FlurryAgent", "Millennial MMAdView Interstitial ad did not display immediately:" + System.currentTimeMillis() + MinimalPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR + this.e);
                return;
            } else {
                Log.d("FlurryAgent", "Millennial MMAdView Interstitial ad displayed immediately:" + System.currentTimeMillis() + MinimalPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR + this.e);
                return;
            }
        }
        int height = this.fAdCreative.getHeight();
        int width = this.fAdCreative.getWidth();
        if (width >= 320 && height >= 50) {
            Log.d("FlurryAgent", "Determined Millennial AdSize as MMBannerAdBottom");
            str = "MMBannerAdBottom";
        } else if (width < 300 || height < 250) {
            Log.d("FlurryAgent", "Could not find Millennial AdSize that matches size");
        } else {
            Log.d("FlurryAgent", "Determined Millennial AdSize as MMBannerAdRectangle");
            str = "MMBannerAdRectangle";
        }
        if (str != null) {
            MMAdView mMAdView2 = new MMAdView((Activity) context, sAdNetworkApiKey, str, 0);
            mMAdView2.setId(1897808289);
            mMAdView2.setListener(new af(this));
            addView(mMAdView2);
            return;
        }
        Log.d("FlurryAgent", "**********Could not load Millennial Ad");
    }
}
