package com.flurry.android;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.mobclix.android.sdk.MobclixFullScreenAdView;
import com.mobclix.android.sdk.MobclixIABRectangleMAdView;
import com.mobclix.android.sdk.MobclixMMABannerXLAdView;

/* JADX INFO: Access modifiers changed from: package-private */
/* loaded from: /storage/emulated/0/Documents/jadec/sources/com.UBI.A90.WW/dex-files/0.dex */
public final class ac extends AdNetworkView {
    /* JADX INFO: Access modifiers changed from: package-private */
    public ac(Context context, be beVar, bb bbVar, AdCreative adCreative) {
        super(context, beVar, bbVar, adCreative);
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
        } catch (PackageManager.NameNotFoundException e) {
            Log.d("FlurryAgent", "Cannot find manifest for app");
        }
        String string = applicationInfo.metaData.getString("com.mobclix.APPLICATION_ID");
        sAdNetworkApiKey = string;
        if (string == null) {
            Log.d("MobclixTestApp", "com.mobclix.APPLICATION_ID not set in manifest");
        }
        setFocusable(true);
    }

    @Override // com.flurry.android.o
    public final void initLayout(Context context) {
        MobclixMMABannerXLAdView mobclixMMABannerXLAdView;
        if (this.fAdCreative.getFormat().equals(AdCreative.kFormatTakeover)) {
            MobclixFullScreenAdView mobclixFullScreenAdView = new MobclixFullScreenAdView((Activity) context);
            mobclixFullScreenAdView.addMobclixAdViewListener(new z(this));
            mobclixFullScreenAdView.requestAndDisplayAd();
            return;
        }
        int height = this.fAdCreative.getHeight();
        int width = this.fAdCreative.getWidth();
        if (width >= 320 && height >= 50) {
            Log.d("FlurryAgent", "Determined Mobclix AdSize as BANNER");
            mobclixMMABannerXLAdView = new MobclixMMABannerXLAdView((Activity) context);
        } else if (width < 300 || height < 250) {
            Log.d("FlurryAgent", "Could not find Mobclix AdSize that matches size");
            mobclixMMABannerXLAdView = null;
        } else {
            Log.d("FlurryAgent", "Determined Mobclix AdSize as IAB_RECT");
            mobclixMMABannerXLAdView = new MobclixIABRectangleMAdView((Activity) context);
        }
        mobclixMMABannerXLAdView.addMobclixAdViewListener(new ah(this));
        addView(mobclixMMABannerXLAdView);
        mobclixMMABannerXLAdView.setRefreshTime(-1L);
    }
}
